/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.parser.choreo;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import org.savara.bpmn2.internal.parser.choreo.BPMN2ChoreographyParserUtil;
import org.savara.bpmn2.internal.parser.choreo.rules.BPMN2ParserRule;
import org.savara.bpmn2.internal.parser.choreo.rules.DefaultBPMN2ParserContext;
import org.savara.bpmn2.internal.parser.choreo.rules.ParserRuleFactory;
import org.savara.bpmn2.internal.parser.choreo.rules.Scope;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TImport;
import org.savara.bpmn2.model.TItemDefinition;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TRootElement;
import org.savara.bpmn2.util.BPMN2ModelUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.protocol.util.FeedbackHandlerProxy;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.DataType;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.parser.AnnotationProcessor;
import org.scribble.protocol.parser.ProtocolParser;

public class BPMN2ChoreographyProtocolParser
implements ProtocolParser {
    private static final String BPMN_FILE_EXTENSION = "bpmn";
    private static Logger logger = Logger.getLogger(BPMN2ChoreographyProtocolParser.class.getName());

    public boolean isSupported(Content content) {
        return content.hasExtension(BPMN_FILE_EXTENSION);
    }

    public ProtocolModel parse(ProtocolContext context, Content content, Journal journal) throws IOException {
        ProtocolModel ret = null;
        InputStream is = content.getInputStream();
        TDefinitions defns = BPMN2ModelUtil.deserialize(is);
        is.close();
        Scope scope = BPMN2ChoreographyParserUtil.createScope(defns);
        BPMN2ChoreographyParserUtil.initializeScope(scope, defns);
        DefaultBPMN2ParserContext parserContext = new DefaultBPMN2ParserContext((FeedbackHandler)new FeedbackHandlerProxy(journal), scope);
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            if (elem.getDeclaredType() != TChoreography.class) continue;
            TChoreography choreo = (TChoreography)elem.getValue();
            ProtocolModel pm = new ProtocolModel();
            Protocol p = new Protocol();
            p.setName(choreo.getName());
            p.setBlock(new Block());
            pm.setProtocol(p);
            this.initialize(pm, defns);
            Annotation pann = new Annotation("Protocol");
            pann.getProperties().put("namespace", defns.getTargetNamespace());
            p.getAnnotations().add(pann);
            Annotation scann = new Annotation("SourceComponent");
            scann.getProperties().put("id", choreo.getId());
            p.getAnnotations().add(scann);
            p.getProperties().put("scribble.uri", choreo.getId());
            parserContext.pushScope();
            BPMN2ChoreographyParserUtil.initializeScope(parserContext.getScope(), choreo);
            BPMN2ParserRule rule = ParserRuleFactory.getParserRule(choreo);
            rule.parse(parserContext, choreo, p.getBlock());
            parserContext.popScope();
            ret = pm;
            break;
        }
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
    }

    protected void initialize(ProtocolModel pm, TDefinitions defns) {
        HashMap<String, String> nsprefix = new HashMap<String, String>();
        Vector<String> defaultprefix = new Vector<String>();
        HashMap<String, String> nslocation = new HashMap<String, String>();
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            if (elem.getDeclaredType() != TMessage.class) continue;
            TMessage message = (TMessage)elem.getValue();
            if (message.getItemRef() == null) {
                logger.severe("No item definition set for message '" + message.getName() + "'");
                continue;
            }
            TItemDefinition itemdefn = this.getItemDefinition(message.getItemRef().getLocalPart(), defns);
            if (itemdefn == null) {
                logger.severe("No item definition found for message '" + message.getName() + "'");
                continue;
            }
            String prefix = itemdefn.getStructureRef().getPrefix();
            if (prefix == null || prefix.trim().length() == 0) {
                if (!defaultprefix.contains(itemdefn.getStructureRef().getNamespaceURI())) {
                    prefix = "defns" + nsprefix.size();
                    defaultprefix.add(itemdefn.getStructureRef().getNamespaceURI());
                } else {
                    prefix = null;
                }
            }
            if (prefix != null) {
                nsprefix.put(prefix, itemdefn.getStructureRef().getNamespaceURI());
            }
            TypeImport ti = new TypeImport();
            ti.setName(message.getName());
            DataType dt = new DataType();
            dt.setDetails(itemdefn.getStructureRef().toString());
            ti.setDataType(dt);
            TypeImportList tilist = new TypeImportList();
            tilist.setFormat("xsd");
            String location = null;
            for (TImport imp : defns.getImport()) {
                if (!imp.getNamespace().equals(itemdefn.getStructureRef().getNamespaceURI())) continue;
                if (imp.getLocation() == null) break;
                location = imp.getLocation();
                break;
            }
            if (location != null && prefix != null) {
                tilist.setLocation(location);
                nslocation.put(prefix, location);
            }
            tilist.getTypeImports().add(ti);
            pm.getImports().add(tilist);
        }
        for (String prefix : nsprefix.keySet()) {
            String ns = (String)nsprefix.get(prefix);
            String location = (String)nslocation.get(prefix);
            Annotation pann = new Annotation("Type");
            pann.getProperties().put("prefix", prefix);
            pann.getProperties().put("namespace", ns);
            if (location != null) {
                pann.getProperties().put("location", location);
            }
            pm.getProtocol().getAnnotations().add(pann);
        }
    }

    protected TItemDefinition getItemDefinition(String id, TDefinitions defns) {
        for (JAXBElement<? extends TRootElement> elem : defns.getRootElement()) {
            TItemDefinition itemdefn;
            if (elem.getDeclaredType() != TItemDefinition.class || !(itemdefn = (TItemDefinition)elem.getValue()).getId().equals(id)) continue;
            return itemdefn;
        }
        return null;
    }
}

