/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.generation.choreo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNDiagram;
import org.savara.bpmn2.internal.generation.components.ChoiceActivity;
import org.savara.bpmn2.internal.generation.components.Choreography;
import org.savara.bpmn2.internal.generation.components.ChoreographyTask;
import org.savara.bpmn2.internal.generation.components.DoActivity;
import org.savara.bpmn2.internal.generation.components.DoBlockActivity;
import org.savara.bpmn2.internal.generation.components.ForkActivity;
import org.savara.bpmn2.internal.generation.components.JoinActivity;
import org.savara.bpmn2.internal.generation.components.ParallelActivity;
import org.savara.bpmn2.internal.generation.components.RepeatActivity;
import org.savara.bpmn2.internal.generation.components.RunActivity;
import org.savara.bpmn2.internal.generation.components.SequenceActivity;
import org.savara.bpmn2.model.ObjectFactory;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TError;
import org.savara.bpmn2.model.TImport;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TItemDefinition;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TOperation;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.util.BPMN2ServiceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.common.model.generator.ModelGenerator;
import org.savara.common.resources.ResourceLocator;
import org.savara.protocol.model.Fork;
import org.savara.protocol.model.Join;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.CustomActivity;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToBPMN2ChoreoModelGenerator
implements ModelGenerator {
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String BPMN_FILE_EXTENSION = ".bpmn";
    private boolean _consecutiveIds = false;
    private ObjectFactory _objectFactory = new ObjectFactory();
    private static final Logger logger = Logger.getLogger(ProtocolToBPMN2ChoreoModelGenerator.class.getName());

    public void setUseConsecutiveIds(boolean b) {
        this._consecutiveIds = b;
    }

    public boolean isSupported(Object source, String targetType) {
        return source instanceof ProtocolModel && !((ProtocolModel)source).isLocated() && (targetType.equals("bpmn2") || targetType.equals("bpmn"));
    }

    public Map<String, Object> generate(Object source, FeedbackHandler handler, ResourceLocator locator) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (source instanceof ProtocolModel) {
            ProtocolModel pm = (ProtocolModel)source;
            this.processProtocol(pm, pm.getProtocol(), ret, handler, locator);
        }
        return ret;
    }

    protected String getProtocolName(Protocol p) {
        String ret = p.getName();
        if (p.getParent() instanceof Protocol) {
            ret = this.getProtocolName((Protocol)p.getParent()) + "_" + ret;
        }
        return ret;
    }

    protected String processProtocol(ProtocolModel pm, Protocol p, Map<String, Object> modelMap, FeedbackHandler handler, ResourceLocator locator) {
        TDefinitions defns = new TDefinitions();
        defns.setId("id-" + pm.getProtocol().getName());
        BPMN2ModelFactory model = new BPMN2ModelFactory(defns);
        BPMN2NotationFactory notation = new BPMN2NotationFactory(model);
        model.setUseConsecutiveIds(this._consecutiveIds);
        notation.setUseConsecutiveIds(this._consecutiveIds);
        this.initNamespace(defns, pm, p);
        this.initImports(defns, pm);
        this.initMessages(defns, pm);
        String modelName = this.getProtocolName(p);
        BPMN2ModelVisitor visitor = new BPMN2ModelVisitor(modelName, p, model, notation);
        this.generateChoreography(p, visitor, handler, locator);
        visitor.completeModels();
        Map<TParticipant, TInterface> intfs = BPMN2ServiceUtil.introspect(defns);
        if (intfs.size() > 0) {
            BPMN2ServiceUtil.merge(defns, intfs);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("No interfaces detected in generated BPMN2 choreography");
        }
        String ret = modelName + BPMN_FILE_EXTENSION;
        modelMap.put(ret, defns);
        for (Protocol nested : p.getNestedProtocols()) {
            String nestedModelFile = this.processProtocol(pm, nested, modelMap, handler, locator);
            TDefinitions nestedDefn = (TDefinitions)modelMap.get(nestedModelFile);
            TImport imp = new TImport();
            imp.setImportType("http://www.omg.org/spec/BPMN/20100524/MODEL");
            imp.setLocation(nestedModelFile);
            imp.setNamespace(nestedDefn.getTargetNamespace());
            defns.getImport().add(imp);
        }
        return ret;
    }

    protected void initNamespace(TDefinitions defns, ProtocolModel pm, Protocol p) {
        Annotation ann = AnnotationDefinitions.getAnnotation((List)p.getAnnotations(), (String)"Protocol");
        if (ann != null) {
            defns.setTargetNamespace((String)ann.getProperties().get("namespace"));
        }
    }

    protected void initImports(TDefinitions defns, ProtocolModel pm) {
        List anns = AnnotationDefinitions.getAnnotations((List)pm.getProtocol().getAnnotations(), (String)"Type");
        for (Annotation ann : anns) {
            String ns = (String)ann.getProperties().get("namespace");
            String loc = (String)ann.getProperties().get("location");
            if (ns.equals(XSD_NAMESPACE)) continue;
            TImport imp = new TImport();
            imp.setImportType(XSD_NAMESPACE);
            imp.setLocation(loc);
            imp.setNamespace(ns);
            defns.getImport().add(imp);
        }
    }

    protected void initMessages(TDefinitions defns, ProtocolModel pm) {
        for (ImportList il : pm.getImports()) {
            if (!(il instanceof TypeImportList)) continue;
            TypeImportList til = (TypeImportList)il;
            for (TypeImport ti : til.getTypeImports()) {
                TItemDefinition itemDef = new TItemDefinition();
                itemDef.setId("ITEM" + ti.getName());
                itemDef.setStructureRef(QName.valueOf(ti.getDataType().getDetails()));
                defns.getRootElement().add(this._objectFactory.createItemDefinition(itemDef));
                TMessage mesg = new TMessage();
                mesg.setId("ID" + ti.getName());
                mesg.setName(ti.getName());
                mesg.setItemRef(new QName(defns.getTargetNamespace(), itemDef.getId()));
                defns.getRootElement().add(this._objectFactory.createMessage(mesg));
            }
        }
    }

    protected TInterface getInterface(TDefinitions defns, Role role) {
        TInterface ret = null;
        String intfName = role.getName();
        for (JAXBElement rootElem : defns.getRootElement()) {
            if (!(rootElem.getValue() instanceof TInterface) || !((TInterface)rootElem.getValue()).getName().equals(intfName)) continue;
            ret = (TInterface)rootElem.getValue();
            break;
        }
        if (ret == null) {
            ret = new TInterface();
            ret.setId(intfName + "Interface");
            ret.setName(intfName);
            defns.getRootElement().add(this._objectFactory.createInterface(ret));
        }
        return ret;
    }

    protected void generateChoreography(Protocol p, BPMN2ModelVisitor visitor, FeedbackHandler handler, ResourceLocator locator) {
        p.visit((Visitor)visitor);
    }

    public class BPMN2ModelVisitor
    extends DefaultVisitor {
        private BPMN2ModelFactory _modelFactory = null;
        private BPMN2NotationFactory _notationFactory = null;
        private String _choreoName = null;
        private Protocol _protocol = null;
        private List<BPMNActivity> _bpmnActivityStack = new ArrayList<BPMNActivity>();
        private Map<String, BPMNDiagram> _activityModels = new HashMap<String, BPMNDiagram>();

        public BPMN2ModelVisitor(String choreoName, Protocol p, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
            this._choreoName = choreoName;
            this._protocol = p;
            this._modelFactory = model;
            this._notationFactory = notation;
        }

        public boolean start(Protocol elem) {
            if (elem == this._protocol) {
                try {
                    BPMNDiagram diagram = this.getBPMNModel(elem);
                    Choreography choreo = diagram.createChoreography(this._choreoName);
                    this.pushBPMNActivity(choreo);
                }
                catch (Exception e) {
                    logger.severe("Failed to get state machine for behavior '" + elem + "': " + e);
                }
                return true;
            }
            return false;
        }

        public void end(Protocol elem) {
            if (elem == this._protocol) {
                BPMNActivity umls = this.getBPMNActivity();
                if (umls != null) {
                    umls.childrenComplete();
                }
                this.popBPMNActivity();
            }
        }

        public boolean start(Choice elem) {
            try {
                this.pushBPMNActivity(new ChoiceActivity(elem, this.getBPMNActivity(), this._modelFactory, this._notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create choice state: " + e);
            }
            return true;
        }

        public void end(Choice elem) {
            this.popBPMNActivity();
        }

        public boolean start(Parallel elem) {
            try {
                this.pushBPMNActivity(new ParallelActivity(elem, this.getBPMNActivity(), this._modelFactory, this._notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create parallel state: " + e);
            }
            return true;
        }

        public void end(Parallel elem) {
            this.popBPMNActivity();
        }

        public void accept(Run elem) {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                new RunActivity((Activity)elem, umls, this._modelFactory, this._notationFactory);
            }
        }

        public boolean start(Do elem) {
            DoActivity state = null;
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                state = new DoActivity((Activity)elem, umls, this._modelFactory, this._notationFactory);
                this.pushBPMNActivity(state);
                DoBlockActivity inline = new DoBlockActivity(state, this._modelFactory, this._notationFactory);
                this.pushBPMNActivity(inline);
            }
            return true;
        }

        public void end(Do elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            this.popBPMNActivity();
        }

        public boolean start(Interrupt elem) {
            if (this.getBPMNActivity() instanceof DoBlockActivity) {
                this.popBPMNActivity();
            }
            return true;
        }

        public void end(Interrupt elem) {
        }

        public void accept(Interaction elem) {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                new ChoreographyTask(elem, umls, this._modelFactory, this._notationFactory);
            }
        }

        public boolean start(Block elem) {
            try {
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this._modelFactory, this._notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create sequence state: " + e);
            }
            return true;
        }

        public void end(Block elem) {
            this.popBPMNActivity();
        }

        public boolean start(Repeat elem) {
            try {
                this.pushBPMNActivity(new RepeatActivity(elem, this.getBPMNActivity(), this._modelFactory, this._notationFactory));
                this.pushBPMNActivity(new SequenceActivity(this.getBPMNActivity(), this._modelFactory, this._notationFactory));
            }
            catch (Exception e) {
                logger.severe("Failed to create while Activity: " + e);
            }
            return true;
        }

        public void end(Repeat elem) {
            this.popBPMNActivity();
            this.popBPMNActivity();
        }

        public void accept(CustomActivity act) {
            BPMNActivity umls;
            if (act instanceof Fork) {
                BPMNActivity umls2 = this.getBPMNActivity();
                if (umls2 != null) {
                    new ForkActivity((Fork)act, umls2, this._modelFactory, this._notationFactory);
                }
            } else if (act instanceof Join && (umls = this.getBPMNActivity()) != null) {
                new JoinActivity((Join)act, umls, this._modelFactory, this._notationFactory);
            }
        }

        protected BPMNDiagram getBPMNModel(Protocol elem) throws BPMN2GenerationException {
            String name = elem.getName();
            BPMNDiagram ret = this._activityModels.get(name);
            if (ret == null) {
                ret = new BPMNDiagram(this._choreoName, name, null, this._modelFactory, this._notationFactory);
                this._activityModels.put(name, ret);
            }
            return ret;
        }

        protected void pushBPMNActivity(BPMNActivity act) {
            this._bpmnActivityStack.add(0, act);
        }

        protected BPMNActivity getBPMNActivity() {
            BPMNActivity ret = null;
            if (this._bpmnActivityStack.size() > 0) {
                ret = this._bpmnActivityStack.get(0);
            }
            return ret;
        }

        protected void popBPMNActivity() {
            BPMNActivity umls = this.getBPMNActivity();
            if (umls != null) {
                umls.childrenComplete();
            }
            if (this._bpmnActivityStack.size() > 0) {
                this._bpmnActivityStack.remove(0);
            }
        }

        public void completeModels() {
            for (BPMNDiagram amodel : this._activityModels.values()) {
                amodel.completeModel();
            }
        }

        protected QName getOperationReference(Interaction interaction, QName messageRef) {
            QName ret = null;
            if (interaction.getMessageSignature().getOperation() == null) {
                return null;
            }
            Role serverRole = null;
            if (InteractionUtil.isRequest((Interaction)interaction)) {
                if (interaction.getToRoles().size() > 0) {
                    serverRole = (Role)interaction.getToRoles().get(0);
                }
                if (serverRole == null) {
                    serverRole = interaction.getEnclosingProtocol().getLocatedRole();
                }
            } else {
                serverRole = interaction.getFromRole();
                if (serverRole == null) {
                    serverRole = interaction.getEnclosingProtocol().getLocatedRole();
                }
            }
            if (serverRole == null) {
                return null;
            }
            TInterface intf = ProtocolToBPMN2ChoreoModelGenerator.this.getInterface(this._modelFactory.getDefinitions(), serverRole);
            if (intf == null) {
                return null;
            }
            TOperation op = null;
            for (TOperation curop : intf.getOperation()) {
                if (interaction.getMessageSignature().getOperation() == null || !curop.getName().equals(interaction.getMessageSignature().getOperation())) continue;
                op = curop;
                break;
            }
            if (op == null) {
                op = new TOperation();
                op.setName(interaction.getMessageSignature().getOperation());
                op.setId("OP_" + serverRole.getName() + "_" + op.getName());
                intf.getOperation().add(op);
            }
            ret = new QName(this._modelFactory.getDefinitions().getTargetNamespace(), op.getId());
            if (InteractionUtil.isRequest((Interaction)interaction)) {
                if (op.getInMessageRef() == null) {
                    op.setInMessageRef(messageRef);
                } else if (!op.getInMessageRef().equals(messageRef)) {
                    // empty if block
                }
            } else if (InteractionUtil.isFaultResponse((Interaction)interaction)) {
                String faultName = InteractionUtil.getFaultName((Interaction)interaction);
                TError error = null;
                for (JAXBElement rootElem : this._modelFactory.getDefinitions().getRootElement()) {
                    TError cur;
                    if (!(rootElem.getValue() instanceof TError) || !(cur = (TError)rootElem.getValue()).getErrorCode().equals(faultName)) continue;
                    error = cur;
                    break;
                }
                if (error != null) {
                    QName qname = new QName(this._modelFactory.getDefinitions().getTargetNamespace(), error.getId());
                    if (!op.getErrorRef().contains(qname)) {
                        op.getErrorRef().add(qname);
                    }
                }
            } else if (op.getOutMessageRef() == null) {
                op.setOutMessageRef(messageRef);
            } else if (!op.getOutMessageRef().equals(messageRef)) {
                // empty if block
            }
            return ret;
        }
    }
}

