/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation;

import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.model.ObjectFactory;
import org.savara.bpmn2.model.TBaseElement;
import org.savara.bpmn2.model.TBoundaryEvent;
import org.savara.bpmn2.model.TCallActivity;
import org.savara.bpmn2.model.TCallChoreography;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TChoreographyTask;
import org.savara.bpmn2.model.TCollaboration;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TEndEvent;
import org.savara.bpmn2.model.TError;
import org.savara.bpmn2.model.TEvent;
import org.savara.bpmn2.model.TExclusiveGateway;
import org.savara.bpmn2.model.TFlowElement;
import org.savara.bpmn2.model.TFlowNode;
import org.savara.bpmn2.model.TGateway;
import org.savara.bpmn2.model.TInclusiveGateway;
import org.savara.bpmn2.model.TIntermediateCatchEvent;
import org.savara.bpmn2.model.TIntermediateThrowEvent;
import org.savara.bpmn2.model.TLinkEventDefinition;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TMessageFlow;
import org.savara.bpmn2.model.TParallelGateway;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.model.TProcess;
import org.savara.bpmn2.model.TReceiveTask;
import org.savara.bpmn2.model.TSendTask;
import org.savara.bpmn2.model.TSequenceFlow;
import org.savara.bpmn2.model.TServiceTask;
import org.savara.bpmn2.model.TStartEvent;
import org.savara.bpmn2.model.TSubChoreography;
import org.savara.bpmn2.model.TSubProcess;
import org.savara.bpmn2.model.TTask;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.protocol.model.Fork;
import org.savara.protocol.model.Join;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMN2ModelFactory {
    private TDefinitions m_definitions = null;
    private TCollaboration m_collaboration = null;
    private TChoreography _choreography = null;
    private ObjectFactory m_factory = new ObjectFactory();
    private boolean m_consecutiveIds = false;
    private int m_id = 1;

    public BPMN2ModelFactory(TDefinitions defns) {
        this.m_definitions = defns;
    }

    public void setUseConsecutiveIds(boolean b) {
        this.m_consecutiveIds = b;
    }

    public String createId() {
        if (this.m_consecutiveIds) {
            return "MID" + this.m_id++;
        }
        return "id-" + UUID.randomUUID().toString();
    }

    public Object createDiagram() {
        return this.m_definitions;
    }

    public TDefinitions getDefinitions() {
        return this.m_definitions;
    }

    public TCollaboration getCollaboration() {
        return this.m_collaboration;
    }

    public Object createPool(Object diagram, String name) {
        if (this.m_collaboration == null) {
            this.m_collaboration = new TCollaboration();
            this.m_collaboration.setId(this.createId());
            this.m_definitions.getRootElement().add(this.m_factory.createCollaboration(this.m_collaboration));
        }
        TProcess process = new TProcess();
        process.setId(this.createId());
        process.setName(name);
        this.m_definitions.getRootElement().add(this.m_factory.createProcess(process));
        TParticipant participant = new TParticipant();
        participant.setId(this.createId());
        participant.setName(name);
        participant.setProcessRef(new QName(this.m_definitions.getTargetNamespace(), process.getId()));
        this.m_collaboration.getParticipant().add(participant);
        return process;
    }

    public Object createChoreography(Object diagram, String name) {
        TChoreography choreo = new TChoreography();
        choreo.setId(this.createId());
        choreo.setName(name);
        this.m_definitions.getRootElement().add(this.m_factory.createChoreography(choreo));
        this._choreography = choreo;
        return choreo;
    }

    public Object createInitialNode(Object container) {
        TStartEvent startEvent = new TStartEvent();
        startEvent.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createStartEvent(startEvent));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createStartEvent(startEvent));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createStartEvent(startEvent));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createStartEvent(startEvent));
        }
        return startEvent;
    }

    public Object createSimpleTask(Object container, Activity activity) {
        TTask task = new TTask();
        task.setId(this.createId());
        task.setName("task: " + activity);
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createTask(task));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createTask(task));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createTask(task));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createTask(task));
        }
        return task;
    }

    public Object createCallActivity(Object container, Run run) {
        TCallActivity ret = null;
        if (container instanceof TProcess || container instanceof TSubProcess) {
            TCallActivity task = new TCallActivity();
            task.setName("Call: " + run.getProtocolReference().getName() + "_" + run.getProtocolReference().getRole());
            if (container instanceof TProcess) {
                ((TProcess)container).getFlowElement().add(this.m_factory.createCallActivity(task));
            } else if (container instanceof TSubProcess) {
                ((TSubProcess)container).getFlowElement().add(this.m_factory.createCallActivity(task));
            }
            task.setId(this.createId());
            ret = task;
        } else if (container instanceof TChoreography || container instanceof TSubChoreography) {
            TCallChoreography task = new TCallChoreography();
            task.setName("Call: " + run.getProtocolReference().getName() + "_" + run.getProtocolReference().getRole());
            if (container instanceof TChoreography) {
                ((TChoreography)container).getFlowElement().add(this.m_factory.createCallChoreography(task));
            } else if (container instanceof TSubChoreography) {
                ((TChoreography)container).getFlowElement().add(this.m_factory.createCallChoreography(task));
            }
            task.setId(this.createId());
            ret = task;
        }
        return ret;
    }

    public Object createSubProcess(Object container) {
        TSubProcess task = new TSubProcess();
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createSubProcess(task));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createSubProcess(task));
        }
        task.setId(this.createId());
        return task;
    }

    public Object createForkTask(Object container, Activity activity) {
        Fork sync = (Fork)activity;
        TIntermediateThrowEvent event = new TIntermediateThrowEvent();
        TLinkEventDefinition led = new TLinkEventDefinition();
        led.setName(sync.getLabel());
        event.getEventDefinition().add(this.m_factory.createLinkEventDefinition(led));
        event.setId(this.createId());
        event.setName(sync.getLabel());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createEvent((TEvent)event));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createEvent((TEvent)event));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createEvent((TEvent)event));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createEvent((TEvent)event));
        }
        return event;
    }

    public Object createJoinTask(Object container, Activity activity) {
        Join join = (Join)activity;
        TExclusiveGateway gw = null;
        if (join.getXOR()) {
            gw = new TExclusiveGateway();
            if (container instanceof TProcess) {
                ((TProcess)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gw));
            } else if (container instanceof TSubProcess) {
                ((TSubProcess)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gw));
            } else if (container instanceof TChoreography) {
                ((TChoreography)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gw));
            } else if (container instanceof TSubChoreography) {
                ((TSubChoreography)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gw));
            }
        } else {
            gw = new TParallelGateway();
            if (container instanceof TProcess) {
                ((TProcess)container).getFlowElement().add(this.m_factory.createParallelGateway((TParallelGateway)gw));
            } else if (container instanceof TSubProcess) {
                ((TSubProcess)container).getFlowElement().add(this.m_factory.createParallelGateway((TParallelGateway)gw));
            } else if (container instanceof TChoreography) {
                ((TChoreography)container).getFlowElement().add(this.m_factory.createParallelGateway((TParallelGateway)gw));
            } else if (container instanceof TSubChoreography) {
                ((TSubChoreography)container).getFlowElement().add(this.m_factory.createParallelGateway((TParallelGateway)gw));
            }
        }
        gw.setId(this.createId());
        return gw;
    }

    public Object createLinkTarget(Object container, String label) {
        TIntermediateCatchEvent linkTarget = new TIntermediateCatchEvent();
        TLinkEventDefinition led = new TLinkEventDefinition();
        led.setName(label);
        linkTarget.getEventDefinition().add(this.m_factory.createLinkEventDefinition(led));
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createIntermediateCatchEvent(linkTarget));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createIntermediateCatchEvent(linkTarget));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createIntermediateCatchEvent(linkTarget));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createIntermediateCatchEvent(linkTarget));
        }
        linkTarget.setId(this.createId());
        linkTarget.setName(label);
        return linkTarget;
    }

    public TParticipant getParticipant(String name) {
        TParticipant participant = null;
        List participants = this._choreography != null ? this._choreography.getParticipant() : this.m_collaboration.getParticipant();
        for (TParticipant p : participants) {
            if (!p.getName().equals(name)) continue;
            participant = p;
            break;
        }
        if (participant == null) {
            participant = new TParticipant();
            participant.setId(this.createId());
            participant.setName(name);
            participants.add(participant);
        }
        return participant;
    }

    protected QName getMessageReference(Interaction interaction) {
        QName ret = null;
        if (interaction.getMessageSignature() == null || interaction.getMessageSignature().getTypeReferences().size() == 0) {
            return null;
        }
        for (JAXBElement rootElem : this.getDefinitions().getRootElement()) {
            TMessage mesg;
            if (!(rootElem.getValue() instanceof TMessage) || !(mesg = (TMessage)rootElem.getValue()).getName().equals(((TypeReference)interaction.getMessageSignature().getTypeReferences().get(0)).getName())) continue;
            ret = new QName(this.getDefinitions().getTargetNamespace(), mesg.getId());
            if (!InteractionUtil.isFaultResponse((Interaction)interaction)) break;
            String faultName = InteractionUtil.getFaultName((Interaction)interaction);
            boolean found = false;
            for (JAXBElement subRootElem : this.getDefinitions().getRootElement()) {
                if (!(subRootElem.getValue() instanceof TError) || !((TError)subRootElem.getValue()).getStructureRef().equals(mesg.getItemRef()) || !((TError)subRootElem.getValue()).getName().equals(faultName)) continue;
                found = true;
            }
            if (found) break;
            TError error = new TError();
            error.setId("ERR" + faultName);
            error.setName(faultName);
            error.setErrorCode(faultName);
            error.setStructureRef(mesg.getItemRef());
            this.getDefinitions().getRootElement().add(this.m_factory.createError(error));
            break;
        }
        return ret;
    }

    public Object createChoreographyTask(Object container, Interaction interaction) {
        TChoreographyTask task = new TChoreographyTask();
        task.setId(this.createId());
        task.setName(interaction.getMessageSignature().toString());
        Role fromRole = interaction.getFromRole();
        TParticipant fromParticipant = this.getParticipant(fromRole.getName());
        Role toRole = (Role)interaction.getToRoles().get(0);
        TParticipant toParticipant = this.getParticipant(toRole.getName());
        task.getParticipantRef().add(new QName(this.m_definitions.getTargetNamespace(), fromParticipant.getId()));
        task.getParticipantRef().add(new QName(this.m_definitions.getTargetNamespace(), toParticipant.getId()));
        task.setInitiatingParticipantRef(new QName(this.m_definitions.getTargetNamespace(), fromParticipant.getId()));
        TMessageFlow mf = new TMessageFlow();
        mf.setId(this.createId());
        mf.setSourceRef(new QName(this.m_definitions.getTargetNamespace(), fromParticipant.getId()));
        mf.setTargetRef(new QName(this.m_definitions.getTargetNamespace(), toParticipant.getId()));
        QName mesg = this.getMessageReference(interaction);
        if (mesg != null) {
            mf.setMessageRef(mesg);
        }
        this._choreography.getMessageFlow().add(mf);
        task.getMessageFlowRef().add(new QName(this.m_definitions.getTargetNamespace(), mf.getId()));
        if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createChoreographyTask(task));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createChoreographyTask(task));
        }
        Annotation ann = AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Fault");
        if (ann != null) {
            // empty if block
        }
        return task;
    }

    public Object createServiceTask(Object container, Activity activity) {
        TServiceTask task = new TServiceTask();
        task.setId(this.createId());
        task.setName("Service: " + org.scribble.protocol.util.InteractionUtil.getMessageSignature((ModelObject)activity) + " to " + org.scribble.protocol.util.InteractionUtil.getToRole((ModelObject)activity));
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        }
        return task;
    }

    public Object createSendTask(Object container, Activity activity) {
        TSendTask task = new TSendTask();
        task.setId(this.createId());
        task.setName("Send: " + org.scribble.protocol.util.InteractionUtil.getMessageSignature((ModelObject)activity) + " to " + org.scribble.protocol.util.InteractionUtil.getToRole((ModelObject)activity));
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        }
        return task;
    }

    public Object createReceiveTask(Object container, Activity activity) {
        TReceiveTask task = new TReceiveTask();
        task.setId(this.createId());
        task.setName("Receive: " + org.scribble.protocol.util.InteractionUtil.getMessageSignature((ModelObject)activity) + " from " + org.scribble.protocol.util.InteractionUtil.getFromRole((ModelObject)activity));
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createTask((TTask)task));
        }
        return task;
    }

    public Object createEventBasedXORGateway(Object container) {
        TExclusiveGateway gateway = new TExclusiveGateway();
        gateway.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gateway));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gateway));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gateway));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createExclusiveGateway(gateway));
        }
        return gateway;
    }

    public Object createANDGateway(Object container) {
        TParallelGateway gateway = new TParallelGateway();
        gateway.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createParallelGateway(gateway));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createParallelGateway(gateway));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createParallelGateway(gateway));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createParallelGateway(gateway));
        }
        return gateway;
    }

    public Object createDataBasedXORGateway(Object container) {
        TInclusiveGateway gateway = new TInclusiveGateway();
        gateway.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createInclusiveGateway(gateway));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createInclusiveGateway(gateway));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createInclusiveGateway(gateway));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createInclusiveGateway(gateway));
        }
        return gateway;
    }

    public Object createFinalNode(Object container) {
        TEndEvent endEvent = new TEndEvent();
        endEvent.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createEndEvent(endEvent));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createEndEvent(endEvent));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createEndEvent(endEvent));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createEndEvent(endEvent));
        }
        return endEvent;
    }

    public Object createBoundaryEvent(Object container) {
        TBoundaryEvent event = new TBoundaryEvent();
        event.setId(this.createId());
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createBoundaryEvent(event));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createBoundaryEvent(event));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createBoundaryEvent(event));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createBoundaryEvent(event));
        }
        return event;
    }

    public Object createControlLink(Object container, Object fromNode, Object toNode, String conditionalExpression) {
        TSequenceFlow link = new TSequenceFlow();
        link.setId(this.createId());
        link.setSourceRef(fromNode);
        link.setTargetRef(toNode);
        link.setName(conditionalExpression);
        if (fromNode instanceof TFlowNode) {
            ((TFlowNode)fromNode).getOutgoing().add(new QName(this.getDefinitions().getTargetNamespace(), link.getId()));
        }
        if (toNode instanceof TFlowNode) {
            ((TFlowNode)toNode).getIncoming().add(new QName(this.getDefinitions().getTargetNamespace(), link.getId()));
        }
        if (container instanceof TProcess) {
            ((TProcess)container).getFlowElement().add(this.m_factory.createSequenceFlow(link));
        } else if (container instanceof TSubProcess) {
            ((TSubProcess)container).getFlowElement().add(this.m_factory.createSequenceFlow(link));
        } else if (container instanceof TChoreography) {
            ((TChoreography)container).getFlowElement().add(this.m_factory.createSequenceFlow(link));
        } else if (container instanceof TSubChoreography) {
            ((TSubChoreography)container).getFlowElement().add(this.m_factory.createSequenceFlow(link));
        }
        return link;
    }

    public Object createMessageLink(Object container, Object fromNode, Object toNode, Interaction receive) {
        TMessageFlow link = new TMessageFlow();
        link.setId(this.createId());
        if (fromNode instanceof TBaseElement) {
            link.setSourceRef(new QName(this.getDefinitions().getTargetNamespace(), ((TBaseElement)fromNode).getId()));
        }
        if (toNode instanceof TBaseElement) {
            link.setTargetRef(new QName(this.getDefinitions().getTargetNamespace(), ((TBaseElement)toNode).getId()));
        }
        link.setName(receive.toString());
        this.m_collaboration.getMessageFlow().add(link);
        return link;
    }

    public Object setLinkExpression(Object link, String expression) {
        if (link instanceof TSequenceFlow) {
            ((TSequenceFlow)link).setName(expression);
        }
        return link;
    }

    public boolean isDecision(Object node) {
        return false;
    }

    public boolean isJoin(Object node) {
        boolean ret = false;
        if (node instanceof TGateway) {
            TGateway gw = (TGateway)node;
            ret = gw.getIncoming().size() > 1;
        }
        return ret;
    }

    public boolean isTerminal(Object node) {
        boolean ret = false;
        if (node instanceof TEndEvent) {
            ret = true;
        }
        return ret;
    }

    public void setLabel(Object entity, String label) {
        if (entity instanceof TFlowElement) {
            ((TFlowElement)entity).setName(label);
        }
    }

    public Object getSource(Object link) {
        Object ret = null;
        if (link instanceof TSequenceFlow) {
            ret = ((TSequenceFlow)link).getSourceRef();
        }
        return ret;
    }

    public void setSource(Object link, Object node) {
        if (link instanceof TSequenceFlow) {
            ((TSequenceFlow)link).setSourceRef(node);
        }
    }

    public Object getTarget(Object link) {
        Object ret = null;
        if (link instanceof TSequenceFlow) {
            ret = ((TSequenceFlow)link).getTargetRef();
        }
        return ret;
    }

    public void setTarget(Object link, Object node) {
        if (link instanceof TSequenceFlow) {
            ((TSequenceFlow)link).setTargetRef(node);
        }
    }

    public List<Object> getControlLinks(Object node) {
        Vector<Object> ret = new Vector<Object>();
        List list = null;
        if (node instanceof TProcess) {
            list = ((TProcess)node).getFlowElement();
        } else if (node instanceof TSubProcess) {
            list = ((TSubProcess)node).getFlowElement();
        } else if (node instanceof TChoreography) {
            list = ((TChoreography)node).getFlowElement();
        } else if (node instanceof TSubChoreography) {
            list = ((TSubChoreography)node).getFlowElement();
        }
        if (list != null) {
            for (JAXBElement jbfe : list) {
                TFlowElement fe = (TFlowElement)jbfe.getValue();
                if (!(fe instanceof TSequenceFlow)) continue;
                ret.add(fe);
            }
        }
        return ret;
    }

    public List<Object> getInboundControlLinks(Object node) {
        Vector<Object> ret = new Vector<Object>();
        return ret;
    }

    public List<Object> getOutboundControlLinks(Object node) {
        Vector<Object> ret = new Vector<Object>();
        return ret;
    }

    public List<Object> getInboundMessageLinks(Object node) {
        Vector<Object> ret = new Vector<Object>();
        if (node instanceof TBaseElement) {
            QName id = new QName(this.getDefinitions().getTargetNamespace(), ((TBaseElement)node).getId());
            for (TMessageFlow mf : this.m_collaboration.getMessageFlow()) {
                if (mf.getTargetRef() == null || !mf.getTargetRef().equals(id)) continue;
                ret.add(mf);
            }
        }
        return ret;
    }

    public List<Object> getOutboundMessageLinks(Object node) {
        Vector<Object> ret = new Vector<Object>();
        if (node instanceof TBaseElement) {
            QName id = new QName(this.getDefinitions().getTargetNamespace(), ((TBaseElement)node).getId());
            for (TMessageFlow mf : this.m_collaboration.getMessageFlow()) {
                if (mf.getSourceRef() == null || !mf.getSourceRef().equals(id)) continue;
                ret.add(mf);
            }
        }
        return ret;
    }

    public void delete(Object entity) {
    }

    public boolean isDeleted(Object entity) {
        return false;
    }
}

