/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.logging.Logger;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.JunctionActivity;
import org.scribble.protocol.model.Choice;

public class ChoiceActivity
extends AbstractBPMNActivity {
    private static Logger LOG = Logger.getLogger(ChoiceActivity.class.getName());
    private boolean m_completed = false;
    private BPMNActivity m_choiceState = null;
    private BPMNActivity m_junctionState = null;

    public ChoiceActivity(Choice choice, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) throws BPMN2GenerationException {
        super(parent, model, notation);
        this.initialize(choice);
    }

    protected void initialize(Choice elem) throws BPMN2GenerationException {
        Object choiceState = this.getModelFactory().createEventBasedXORGateway(this.getContainer());
        this.m_choiceState = new JunctionActivity(choiceState, this, this.getModelFactory(), this.getNotationFactory());
        Object junctionState = this.getModelFactory().createEventBasedXORGateway(this.getContainer());
        this.m_junctionState = new JunctionActivity(junctionState, this, this.getModelFactory(), this.getNotationFactory());
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            int width = this.m_choiceState.getWidth() + this.m_junctionState.getWidth() + 100;
            int height = 0;
            if (this.getChildStates().remove(this.m_junctionState)) {
                this.getChildStates().add(this.m_junctionState);
            }
            int maxwidth = 0;
            for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
                BPMNActivity umls = this.getChildStates().get(i);
                height += umls.getHeight();
                if (i != 1) {
                    height += 40;
                }
                if (umls.getWidth() <= maxwidth) continue;
                maxwidth = umls.getWidth();
            }
            width += maxwidth;
            if (height < this.m_choiceState.getHeight()) {
                height = this.m_choiceState.getHeight();
            }
            if (height < this.m_junctionState.getHeight()) {
                height = this.m_junctionState.getHeight();
            }
            this.setWidth(width);
            this.setHeight(height);
            this.adjustWidth(width);
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int cury = y;
        int midx = x + this.getWidth() / 2;
        int midy = y + this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.calculatePosition(midx - act.getWidth() / 2, cury);
            cury += act.getHeight() + 40;
        }
        this.m_choiceState.calculatePosition(x, midy - this.m_choiceState.getHeight() / 2);
        this.m_junctionState.calculatePosition(x + this.getWidth() - this.m_junctionState.getWidth(), midy - this.m_junctionState.getHeight() / 2);
    }

    public Object getStartNode() {
        return this.m_choiceState.getStartNode();
    }

    public Object getEndNode() {
        return this.m_junctionState.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this.m_choiceState;
    }

    public BPMNActivity getEndState() {
        return this.m_junctionState;
    }

    public void adjustWidth(int width) {
        int extrawidth = this.m_choiceState.getWidth() + this.m_junctionState.getWidth() + 100;
        this.setWidth(width);
        for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
            BPMNActivity umls = this.getChildStates().get(i);
            umls.adjustWidth(width - extrawidth);
        }
    }

    public void draw(Object parent) {
        BPMNActivity act;
        int i;
        for (i = 0; i < this.getChildStates().size(); ++i) {
            act = this.getChildStates().get(i);
            act.draw(parent);
        }
        for (i = 1; i < this.getChildStates().size(); ++i) {
            act = this.getChildStates().get(i);
            if (act == this.m_junctionState) continue;
            this.getStartState().transitionTo(act, null, parent);
            if (act.getEndState() != null) {
                act.getEndState().transitionTo(this.m_junctionState, null, parent);
                continue;
            }
            LOG.severe("Attempting to link activity " + act + " 'null' end state to junction " + this.m_junctionState);
        }
    }
}

