/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.List;
import javax.xml.namespace.QName;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.DoBlockActivity;
import org.savara.bpmn2.model.BPMNEdge;
import org.savara.bpmn2.model.Point;
import org.savara.bpmn2.model.TBoundaryEvent;
import org.scribble.protocol.model.Activity;

public class DoActivity
extends AbstractBPMNActivity {
    private boolean m_completed = false;
    private static final int CATCH_OFFSET = 50;

    public DoActivity(Activity act, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        super(parent, model, notation);
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            int height = 0;
            int maxwidth = 0;
            for (int i = 0; i < this.getChildStates().size(); ++i) {
                BPMNActivity act = this.getChildStates().get(i);
                int width = act.getWidth();
                if (i > 0) {
                    width += (this.getChildStates().size() - i) * 50;
                }
                if (width > maxwidth) {
                    maxwidth = width;
                }
                height += act.getHeight() + 40;
            }
            this.setHeight(height - 40);
            this.setWidth(maxwidth + 100);
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int curx = x + 50;
        int cury = y;
        this.setX(x);
        this.setY(y);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            int newx = curx;
            if (i > 0) {
                newx += (this.getChildStates().size() - i) * 50;
            }
            act.calculatePosition(newx, cury);
            cury += act.getHeight() + 40;
        }
    }

    public void draw(Object parent) {
        DoBlockActivity tryblock = (DoBlockActivity)this.getChildStates().get(0);
        tryblock.draw(parent);
        for (int i = 1; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            TBoundaryEvent boundaryEvent = (TBoundaryEvent)this.getModelFactory().createBoundaryEvent(this.getContainer());
            boundaryEvent.setAttachedToRef(new QName(this.getModelFactory().getDefinitions().getTargetNamespace(), tryblock.getSubProcess().getId()));
            this.getNotationFactory().createEvent(this.getModelFactory(), boundaryEvent, parent, tryblock.getX() + (this.getChildStates().size() - i - 1) * 50, tryblock.getY() + tryblock.getHeight() - 15, 30, 30);
            Object link = this.getModelFactory().createControlLink(this.getContainer(), boundaryEvent, act.getStartNode(), null);
            BPMNEdge edge = (BPMNEdge)this.getNotationFactory().createSequenceLink(this.getModelFactory(), link, parent);
            ((Point)edge.getWaypoint().get(0)).setX(((Point)edge.getWaypoint().get(0)).getX() - 15.0);
            ((Point)edge.getWaypoint().get(0)).setY(((Point)edge.getWaypoint().get(0)).getY() + 15.0);
            Point p1 = new Point();
            p1.setY(((Point)edge.getWaypoint().get(1)).getY());
            p1.setX(((Point)edge.getWaypoint().get(0)).getX());
            edge.getWaypoint().add(1, p1);
        }
    }

    public void breakLinks() {
        Object node = this.getStartNode();
        List<Object> list = this.getModelFactory().getInboundControlLinks(node);
        for (int i = list.size() - 1; i >= 0; --i) {
            Object edge = list.get(i);
            this.tidyUpEdge(edge);
        }
    }

    protected void tidyUpEdge(Object edge) {
        Object sourceNode = this.getModelFactory().getSource(edge);
        this.getModelFactory().delete(edge);
        if (this.getModelFactory().getInboundControlLinks(sourceNode).size() <= 1 && this.getModelFactory().getOutboundControlLinks(sourceNode).size() == 0 && (this.getModelFactory().isDecision(sourceNode) || this.getModelFactory().isJoin(sourceNode))) {
            if (this.getModelFactory().getInboundControlLinks(sourceNode).size() == 1) {
                Object actedge = this.getModelFactory().getInboundControlLinks(sourceNode).get(0);
                this.tidyUpEdge(actedge);
            }
            this.getModelFactory().delete(sourceNode);
        }
    }

    public Object getStartNode() {
        BPMNActivity act = this.getChildStates().get(0);
        return act.getStartNode();
    }

    public Object getEndNode() {
        BPMNActivity act = this.getChildStates().get(0);
        return act.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this;
    }

    public BPMNActivity getEndState() {
        return this;
    }
}

