/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.savara.bpmn2.model.ObjectFactory;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TChoreographyTask;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TError;
import org.savara.bpmn2.model.TFlowElement;
import org.savara.bpmn2.model.TFlowNode;
import org.savara.bpmn2.model.TInterface;
import org.savara.bpmn2.model.TMessage;
import org.savara.bpmn2.model.TMessageFlow;
import org.savara.bpmn2.model.TOperation;
import org.savara.bpmn2.model.TParticipant;
import org.savara.bpmn2.model.TRootElement;
import org.savara.bpmn2.model.TSequenceFlow;
import org.savara.bpmn2.model.TStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMN2ServiceUtil {
    public static final String INTERFACE_ID_SUFFIX = "Interface";
    private static final Logger LOG = Logger.getLogger(BPMN2ServiceUtil.class.getName());

    public static Map<TParticipant, TInterface> introspect(TDefinitions defns) {
        HashMap<TParticipant, TInterface> ret = new HashMap<TParticipant, TInterface>();
        for (JAXBElement elem : defns.getRootElement()) {
            if (elem.getDeclaredType() != TChoreography.class) continue;
            TChoreography choreo = (TChoreography)elem.getValue();
            TStartEvent startEvent = null;
            for (JAXBElement jaxb : choreo.getFlowElement()) {
                if (((TFlowElement)jaxb.getValue()).getClass() != TStartEvent.class) continue;
                if (startEvent != null) {
                    LOG.severe("Multiple start events found in choreography");
                    continue;
                }
                startEvent = (TStartEvent)jaxb.getValue();
            }
            if (startEvent == null) continue;
            BPMN2ServiceUtil.processNode((TFlowNode)startEvent, ret, new Vector<InteractionInfo>(), new ModelInfo(choreo.getParticipant(), choreo.getMessageFlow(), choreo.getFlowElement(), defns.getRootElement(), defns.getTargetNamespace()), new Vector<TFlowNode>());
        }
        return ret;
    }

    protected static void processNode(TFlowNode node, Map<TParticipant, TInterface> intfs, List<InteractionInfo> ii, ModelInfo modelInfo, List<TFlowNode> processedNodes) {
        if (!processedNodes.contains(node)) {
            processedNodes.add(node);
            if (node instanceof TChoreographyTask) {
                BPMN2ServiceUtil.processChoreographyTask((TChoreographyTask)node, intfs, ii, modelInfo);
            }
            for (QName outgoing : node.getOutgoing()) {
                TSequenceFlow sf = (TSequenceFlow)modelInfo.getFlowElement(outgoing.getLocalPart());
                if (sf == null) continue;
                if (sf.getTargetRef() != null) {
                    BPMN2ServiceUtil.processNode((TFlowNode)sf.getTargetRef(), intfs, new Vector<InteractionInfo>(ii), modelInfo, processedNodes);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Node's outgoing flow has no target ref: " + node);
            }
        }
    }

    protected static void processChoreographyTask(TChoreographyTask node, Map<TParticipant, TInterface> intfs, List<InteractionInfo> ii, ModelInfo modelInfo) {
        InteractionInfo initiatingii = null;
        InteractionInfo respondingii = null;
        for (QName mflowQName : node.getMessageFlowRef()) {
            TMessageFlow mflow = modelInfo.getMessageFlow(mflowQName.getLocalPart());
            if (mflow == null) continue;
            TParticipant from = modelInfo.getParticipant(mflow.getSourceRef().getLocalPart());
            TParticipant to = modelInfo.getParticipant(mflow.getTargetRef().getLocalPart());
            TMessage mesg = modelInfo.getMessage(mflow.getMessageRef().getLocalPart());
            if (from == null || to == null || mesg == null) continue;
            if (mflow.getSourceRef().equals(node.getInitiatingParticipantRef())) {
                initiatingii = new InteractionInfo(from, to, mesg);
                continue;
            }
            respondingii = new InteractionInfo(to, from, mesg);
        }
        if (initiatingii != null && respondingii != null) {
            BPMN2ServiceUtil.storeMEP(initiatingii, respondingii, intfs, modelInfo);
        } else if (initiatingii != null) {
            InteractionInfo cur;
            int i;
            InteractionInfo match = null;
            for (i = ii.size() - 1; match == null && i >= 0; --i) {
                cur = ii.get(i);
                if (!cur.getFrom().equals(initiatingii.getTo()) || !cur.getTo().equals(initiatingii.getFrom())) continue;
                match = cur;
            }
            if (match != null) {
                BPMN2ServiceUtil.storeMEP(match, initiatingii, intfs, modelInfo);
                ii.remove(match);
            } else {
                for (i = ii.size() - 1; match == null && i >= 0; --i) {
                    cur = ii.get(i);
                    if (!cur.getFrom().equals(initiatingii.getTo()) || !cur.getTo().equals(initiatingii.getFrom())) continue;
                    match = cur;
                }
                if (match != null) {
                    BPMN2ServiceUtil.storeMEP(match, null, intfs, modelInfo);
                    ii.remove(match);
                }
                ii.add(initiatingii);
            }
        } else if (respondingii != null) {
            LOG.severe("Only a response interaction has been found for ChoreographyTask: " + node);
        } else {
            LOG.severe("No interactions have been found for ChoreographyTask: " + node);
        }
    }

    protected static void storeMEP(InteractionInfo req, InteractionInfo resp, Map<TParticipant, TInterface> intfs, ModelInfo modelInfo) {
        TParticipant participant = req.getTo();
        TInterface intf = intfs.get(participant);
        if (intf == null) {
            String intfName = BPMN2ServiceUtil.getInterfaceName(participant);
            intf = new TInterface();
            intf.setId(intfName + INTERFACE_ID_SUFFIX);
            intf.setName(intfName);
            QName impl = new QName(modelInfo.getTargetNamespace() + "/" + participant.getName(), participant.getName());
            intf.setImplementationRef(impl);
            intfs.put(participant, intf);
        }
        TOperation operation = null;
        for (TOperation op : intf.getOperation()) {
            if (!op.getInMessageRef().getLocalPart().equals(req.getMessage().getId())) continue;
            operation = op;
            break;
        }
        if (operation == null) {
            operation = new TOperation();
            String opname = BPMN2ServiceUtil.getOperationName(req.getMessage());
            operation.setId(opname);
            operation.setName(opname);
            operation.setInMessageRef(new QName(modelInfo.getTargetNamespace(), req.getMessage().getId()));
            intf.getOperation().add(operation);
        }
        if (resp != null) {
            TError err = modelInfo.getErrorForItemDefinition(resp.getMessage().getItemRef());
            if (err != null) {
                QName errQName = new QName(modelInfo.getTargetNamespace(), err.getId());
                if (!operation.getErrorRef().contains(errQName)) {
                    operation.getErrorRef().add(errQName);
                }
            } else if (operation.getOutMessageRef() == null) {
                operation.setOutMessageRef(new QName(modelInfo.getTargetNamespace(), resp.getMessage().getId()));
            }
        }
    }

    public static String getInterfaceName(TParticipant participant) {
        return participant.getName();
    }

    public static String getOperationName(TMessage message) {
        String ret = Character.toLowerCase(message.getName().charAt(0)) + message.getName().substring(1);
        ret = ret.replaceAll("Request", "");
        ret = ret.replaceAll("Response", "");
        ret = ret.replaceAll("Req", "");
        ret = ret.replaceAll("Resp", "");
        return ret;
    }

    public static void merge(TDefinitions defns, Map<TParticipant, TInterface> interfaces) {
        ObjectFactory factory = new ObjectFactory();
        Vector<TParticipant> participants = new Vector<TParticipant>(interfaces.keySet());
        Collections.sort(participants, new Comparator<TParticipant>(){

            @Override
            public int compare(TParticipant o1, TParticipant o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ModelInfo modelInfo = new ModelInfo(null, null, null, defns.getRootElement(), defns.getTargetNamespace());
        for (TParticipant participant : participants) {
            TInterface intf = interfaces.get(participant);
            if (participant.getInterfaceRef().size() == 0) {
                defns.getRootElement().add(factory.createInterface(intf));
                participant.getInterfaceRef().add(new QName(modelInfo.getTargetNamespace(), intf.getId()));
                continue;
            }
            for (TOperation op : intf.getOperation()) {
                TOperation other = null;
                for (QName qname : participant.getInterfaceRef()) {
                    TInterface otherintf = (TInterface)modelInfo.getRootElement(qname.getLocalPart());
                    if (otherintf == null) continue;
                    for (TOperation otherOp : otherintf.getOperation()) {
                        if (!op.getName().equals(otherOp.getName())) continue;
                        other = otherOp;
                        break;
                    }
                    if (other == null) continue;
                    break;
                }
                if (other == null) {
                    TInterface otherintf = (TInterface)modelInfo.getRootElement(((QName)participant.getInterfaceRef().get(0)).getLocalPart());
                    otherintf.getOperation().add(op);
                    continue;
                }
                BPMN2ServiceUtil.mergeOperation(op, other);
            }
        }
    }

    protected static void mergeOperation(TOperation newOp, TOperation existingOp) {
        boolean mergeResponse = false;
        if (existingOp.getInMessageRef() == null) {
            existingOp.setInMessageRef(newOp.getInMessageRef());
            mergeResponse = true;
        } else if (newOp.getInMessageRef() != null) {
            if (newOp.getInMessageRef().equals(existingOp.getInMessageRef())) {
                mergeResponse = true;
            } else {
                LOG.severe("Incompatible request message type for operation '" + existingOp.getName() + "'");
            }
        } else {
            mergeResponse = true;
        }
        if (mergeResponse) {
            if (existingOp.getOutMessageRef() == null) {
                existingOp.setOutMessageRef(newOp.getOutMessageRef());
            } else if (newOp.getOutMessageRef() != null && !newOp.getOutMessageRef().equals(existingOp.getOutMessageRef())) {
                LOG.severe("Incompatible response message type for operation '" + existingOp.getName() + "'");
            }
            for (QName errQName : newOp.getErrorRef()) {
                if (existingOp.getErrorRef().contains(errQName)) continue;
                existingOp.getErrorRef().add(errQName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ModelInfo {
        private List<TParticipant> _participants = null;
        private List<TMessageFlow> _messageFlows = null;
        private List<JAXBElement<? extends TFlowElement>> _flowElements;
        private List<JAXBElement<? extends TRootElement>> _rootElements;
        private String _targetNamespace = null;
        private ObjectFactory _factory = new ObjectFactory();

        public ModelInfo(List<TParticipant> participants, List<TMessageFlow> messageFlows, List<JAXBElement<? extends TFlowElement>> flowElements, List<JAXBElement<? extends TRootElement>> rootElements, String targetNamespace) {
            this._participants = participants;
            this._messageFlows = messageFlows;
            this._flowElements = flowElements;
            this._rootElements = rootElements;
            this._targetNamespace = targetNamespace;
        }

        public String getTargetNamespace() {
            return this._targetNamespace;
        }

        public void addError(TError err) {
            this._rootElements.add((JAXBElement<? extends TRootElement>)this._factory.createError(err));
        }

        public TError getErrorForItemDefinition(QName itemRef) {
            TError ret = null;
            for (JAXBElement<? extends TRootElement> fejaxb : this._rootElements) {
                TRootElement fe = (TRootElement)fejaxb.getValue();
                if (!(fe instanceof TError) || !((TError)fe).getStructureRef().equals(itemRef)) continue;
                ret = (TError)fe;
                break;
            }
            return ret;
        }

        public TParticipant getParticipant(String id) {
            TParticipant ret = null;
            for (TParticipant part : this._participants) {
                if (!part.getId().equals(id)) continue;
                ret = part;
                break;
            }
            return ret;
        }

        public TMessageFlow getMessageFlow(String id) {
            TMessageFlow ret = null;
            for (TMessageFlow mflow : this._messageFlows) {
                if (!mflow.getId().equals(id)) continue;
                ret = mflow;
                break;
            }
            return ret;
        }

        public TMessage getMessage(String id) {
            return (TMessage)this.getRootElement(id);
        }

        public TRootElement getRootElement(String id) {
            TRootElement ret = null;
            for (JAXBElement<? extends TRootElement> fejaxb : this._rootElements) {
                TRootElement fe = (TRootElement)fejaxb.getValue();
                if (!fe.getId().equals(id)) continue;
                ret = fe;
                break;
            }
            return ret;
        }

        public TFlowElement getFlowElement(String id) {
            TFlowElement ret = null;
            for (JAXBElement<? extends TFlowElement> fejaxb : this._flowElements) {
                TFlowElement fe = (TFlowElement)fejaxb.getValue();
                if (!fe.getId().equals(id)) continue;
                ret = fe;
                break;
            }
            return ret;
        }

        public TError getError(String id) {
            return (TError)this.getRootElement(id);
        }
    }

    protected static class InteractionInfo {
        private TParticipant _from = null;
        private TParticipant _to = null;
        private TMessage _message = null;

        public InteractionInfo(TParticipant from, TParticipant to, TMessage message) {
            this._from = from;
            this._to = to;
            this._message = message;
        }

        public TParticipant getFrom() {
            return this._from;
        }

        public TParticipant getTo() {
            return this._to;
        }

        public TMessage getMessage() {
            return this._message;
        }
    }
}

