/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.JunctionActivity;

public class Choreography
extends AbstractBPMNActivity {
    private boolean _completed = false;
    private Object _choreography = null;
    private BPMNActivity _initialState = null;
    private BPMNActivity _finalState = null;

    public Choreography(Object diagram, String name, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        super(parent, model, notation);
        this.initialize(diagram, name);
    }

    public void initialize(Object diagram, String name) {
        this._choreography = this.getModelFactory().createChoreography(diagram, name);
        this._initialState = new JunctionActivity(this.getModelFactory().createInitialNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
        this._finalState = new JunctionActivity(this.getModelFactory().createFinalNode(this.getContainer()), this, this.getModelFactory(), this.getNotationFactory());
    }

    public Object getContainer() {
        return this._choreography;
    }

    public Object getStartNode() {
        return this._initialState.getStartNode();
    }

    public Object getEndNode() {
        return this._finalState.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this._initialState;
    }

    public BPMNActivity getEndState() {
        return this._finalState;
    }

    public void childrenComplete() {
        if (!this._completed) {
            if (this.getChildStates().remove(this._finalState)) {
                this.getChildStates().add(this._finalState);
            }
            this.transitionSequentialNodes();
            this.setHeight(this.getHeight() + 80);
            this.setWidth(this.getWidth() + 100);
            this._completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int curx = 50;
        int midy = this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.calculatePosition(curx, y + (midy - act.getHeight() / 2));
            curx += act.getWidth() + 50;
        }
    }

    public void draw(Object parent) {
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            BPMNActivity prev = this.getChildStates().get(i - 1);
            prev.transitionTo(act, null, parent);
        }
    }
}

