/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.ArrayList;
import java.util.List;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNDiagram;
import org.savara.bpmn2.model.BPMNEdge;
import org.savara.bpmn2.model.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBPMNActivity
implements BPMNActivity {
    public static final int VERTICAL_GAP = 40;
    public static final int HORIZONTAL_GAP = 50;
    private BPMNActivity m_parent = null;
    private BPMN2ModelFactory m_modelFactory = null;
    private BPMN2NotationFactory m_notationFactory = null;
    private List<BPMNActivity> m_childStates = new ArrayList<BPMNActivity>();
    private int m_x = 0;
    private int m_y = 0;
    private int m_width = 0;
    private int m_height = 0;

    public AbstractBPMNActivity(BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) {
        this.m_parent = parent;
        this.m_modelFactory = model;
        this.m_notationFactory = notation;
        if (parent instanceof AbstractBPMNActivity) {
            ((AbstractBPMNActivity)parent).addChildState(this);
        }
    }

    @Override
    public BPMNActivity getParent() {
        return this.m_parent;
    }

    @Override
    public Object getContainer() {
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.getContainer();
    }

    protected BPMN2ModelFactory getModelFactory() {
        return this.m_modelFactory;
    }

    protected BPMN2NotationFactory getNotationFactory() {
        return this.m_notationFactory;
    }

    protected void addChildState(BPMNActivity child) {
        this.m_childStates.add(child);
    }

    protected List<BPMNActivity> getChildStates() {
        return this.m_childStates;
    }

    protected void promote(List<BPMNActivity> children, AbstractBPMNActivity parent, BPMNActivity after) {
        int pos = parent.getChildStates().indexOf(after);
        if (pos != -1) {
            parent.getChildStates().addAll(pos + 1, children);
        } else {
            parent.getChildStates().addAll(children);
        }
    }

    @Override
    public void childrenComplete() {
    }

    @Override
    public BPMNDiagram getBPMNDiagram() {
        BPMNDiagram ret = null;
        if (this.m_parent != null) {
            ret = this.m_parent.getBPMNDiagram();
        }
        return ret;
    }

    @Override
    public Object transitionFrom(BPMNActivity fromNode, String conditionalExpression) {
        Object ret = this.getModelFactory().createControlLink(this.getContainer(), fromNode.getEndNode(), this.getStartNode(), conditionalExpression);
        return ret;
    }

    @Override
    public void transitionTo(BPMNActivity toNode, String expression, Object parent) {
        Object ret = this.getModelFactory().createControlLink(this.getContainer(), this.getEndNode(), toNode.getStartNode(), expression);
        BPMNEdge edge = (BPMNEdge)this.getNotationFactory().createSequenceLink(this.getModelFactory(), ret, parent);
        if (edge.getWaypoint().size() > 0 && ((Point)edge.getWaypoint().get(0)).getY() != ((Point)edge.getWaypoint().get(1)).getY()) {
            double midx = ((Point)edge.getWaypoint().get(0)).getX() + (((Point)edge.getWaypoint().get(1)).getX() - ((Point)edge.getWaypoint().get(0)).getX()) / 2.0;
            if (((Point)edge.getWaypoint().get(1)).getX() - midx > 50.0) {
                midx = ((Point)edge.getWaypoint().get(1)).getX() - 50.0;
            }
            Point p1 = new Point();
            p1.setY(((Point)edge.getWaypoint().get(0)).getY());
            p1.setX(midx);
            Point p2 = new Point();
            p2.setY(((Point)edge.getWaypoint().get(1)).getY());
            p2.setX(p1.getX());
            edge.getWaypoint().add(1, p1);
            edge.getWaypoint().add(2, p2);
        }
    }

    public void transitionSequentialNodes() {
        int width = 0;
        int height = 0;
        if (this.getChildStates().size() > 0) {
            BPMNActivity v1 = this.getChildStates().get(0);
            width += v1.getWidth();
            height = v1.getHeight();
        }
        for (int i = 1; i < this.getChildStates().size(); ++i) {
            BPMNActivity v1 = this.getChildStates().get(i - 1);
            BPMNActivity v2 = this.getChildStates().get(i);
            width += v2.getWidth();
            width += 50;
            if (height < v2.getHeight()) {
                height = v2.getHeight();
            }
            Object endNode = v1.getEndNode();
            if (!v1.canDeleteEndNode() || !this.getModelFactory().isJoin(endNode) && !this.getModelFactory().isTerminal(endNode)) continue;
            List<Object> list = this.getModelFactory().getInboundControlLinks(endNode);
            for (int j = list.size() - 1; j >= 0; --j) {
                Object transition = list.get(j);
                this.getModelFactory().setTarget(transition, v2.getStartNode());
            }
            this.getModelFactory().delete(endNode);
        }
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public int getX() {
        return this.m_x;
    }

    @Override
    public void setX(int x) {
        this.m_x = x;
    }

    @Override
    public int getY() {
        return this.m_y;
    }

    @Override
    public void setY(int y) {
        this.m_y = y;
    }

    @Override
    public int getWidth() {
        return this.m_width;
    }

    @Override
    public void setWidth(int width) {
        this.m_width = width;
    }

    @Override
    public int getHeight() {
        return this.m_height;
    }

    @Override
    public void setHeight(int height) {
        this.m_height = height;
    }

    @Override
    public void adjustWidth(int width) {
        float percentChange = width / this.getWidth();
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            int cur = act.getWidth();
            int newWidth = (int)((float)cur * percentChange);
            act.adjustWidth(newWidth);
            int change = act.getWidth() - cur;
            this.setWidth(this.getWidth() + change);
        }
    }

    @Override
    public void calculatePosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    @Override
    public void draw(Object parent) {
    }

    @Override
    public boolean canDeleteEndNode() {
        return true;
    }
}

