/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNPool;
import org.savara.bpmn2.internal.generation.components.Choreography;
import org.savara.bpmn2.internal.generation.components.ReceiveActivity;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.scribble.protocol.model.Interaction;

public class BPMNDiagram
extends AbstractBPMNActivity {
    private Object m_diagram = null;
    private Object m_container = null;
    private Map<String, BPMNActivity> m_sendActivities = new HashMap<String, BPMNActivity>();
    private Map<String, BPMNActivity> m_receiveActivities = new HashMap<String, BPMNActivity>();
    private Map<String, BPMNPool> m_pools = new HashMap<String, BPMNPool>();
    private List<BPMNPool> m_duplicatePools = new Vector<BPMNPool>();
    private boolean m_sendReceiveAsControlLink = true;
    private boolean m_controlFromSendOnly = false;

    public BPMNDiagram(String choreoName, String diagramName, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) throws BPMN2GenerationException {
        super(parent, model, notation);
        this.m_diagram = model.createDiagram();
    }

    public Object getContainer() {
        return this.m_container;
    }

    public BPMNPool createPool(String participant) {
        BPMNPool ret = new BPMNPool(this.m_diagram, participant, this, this.getModelFactory(), this.getNotationFactory());
        if (this.m_pools.containsKey(participant)) {
            this.m_duplicatePools.add(ret);
        } else {
            this.m_pools.put(participant, ret);
        }
        return ret;
    }

    public Choreography createChoreography(String choreoName) {
        Choreography ret = new Choreography(this.m_diagram, choreoName, this, this.getModelFactory(), this.getNotationFactory());
        return ret;
    }

    public BPMNDiagram getBPMNDiagram() {
        return this;
    }

    public Object getStartNode() {
        return null;
    }

    public Object getEndNode() {
        return null;
    }

    public BPMNActivity getStartState() {
        return null;
    }

    public BPMNActivity getEndState() {
        return null;
    }

    public void registerSendActivity(Interaction send, BPMNActivity activity) {
        Annotation ann;
        if (!this.isPoolDuplicate(activity) && (ann = AnnotationDefinitions.getAnnotation((List)send.getAnnotations(), (String)"SourceComponent")) != null && ann.getProperties().containsKey("id")) {
            this.m_sendActivities.put((String)ann.getProperties().get("id"), activity);
        }
    }

    public void registerReceiveActivity(Interaction recv, BPMNActivity activity) {
        Annotation ann;
        if (!this.isPoolDuplicate(activity) && (ann = AnnotationDefinitions.getAnnotation((List)recv.getAnnotations(), (String)"SourceComponent")) != null && ann.getProperties().containsKey("id")) {
            this.m_receiveActivities.put((String)ann.getProperties().get("id"), activity);
        }
    }

    protected boolean isPoolDuplicate(BPMNActivity activity) {
        boolean ret = false;
        while (activity != null && !(activity instanceof BPMNPool)) {
            activity = activity.getParent();
        }
        if (activity != null) {
            ret = this.m_duplicatePools.contains(activity);
        }
        return ret;
    }

    public void completeModel() {
        Iterator<String> iter = this.m_sendActivities.keySet().iterator();
        ArrayList<Object> messageLinks = new ArrayList<Object>();
        while (iter.hasNext()) {
            String sendId = iter.next();
            BPMNActivity sendActivity = this.m_sendActivities.get(sendId);
            ReceiveActivity receiveActivity = (ReceiveActivity)this.m_receiveActivities.get(sendId);
            if (sendActivity == null || receiveActivity == null || !this.m_sendReceiveAsControlLink) continue;
            if (this.m_controlFromSendOnly) {
                receiveActivity.breakLinks();
            }
            messageLinks.add(this.getModelFactory().createMessageLink(this.m_diagram, sendActivity.getEndNode(), receiveActivity.getStartNode(), receiveActivity.getReceive()));
            this.checkForRedundantTargetLinks(sendActivity, receiveActivity);
        }
        for (int i = 0; i < this.m_duplicatePools.size(); ++i) {
            BPMNPool pool = this.m_duplicatePools.get(i);
            this.getModelFactory().delete(pool.getContainer());
            this.getChildStates().remove(pool);
        }
        int cury = 0;
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.calculatePosition(0, cury);
            cury += act.getHeight() + 100;
        }
        Object diagramNotation = this.getNotationFactory().createDiagram(this.getModelFactory(), this.m_diagram, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            this.getChildStates().get(i).draw(diagramNotation);
        }
    }

    protected void checkForRedundantTargetLinks(BPMNActivity source, BPMNActivity target) {
        List<Object> outgoing1 = this.getModelFactory().getOutboundControlLinks(target.getStartNode());
        for (int i = 0; i < outgoing1.size(); ++i) {
            Object ae1 = outgoing1.get(i);
            List<Object> outgoing2 = this.getModelFactory().getOutboundControlLinks(source.getStartNode());
            boolean f_found = false;
            for (int j = 0; !f_found && j < outgoing2.size(); ++j) {
                Object ae2 = outgoing2.get(j);
                if (this.getModelFactory().getTarget(ae1) != this.getModelFactory().getTarget(ae2)) continue;
                f_found = true;
                this.getModelFactory().delete(ae2);
            }
        }
    }
}

