/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.List;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.JunctionActivity;
import org.savara.bpmn2.internal.generation.components.SequenceActivity;
import org.savara.bpmn2.model.BPMNEdge;
import org.savara.bpmn2.model.Point;
import org.scribble.protocol.model.Repeat;

public class RepeatActivity
extends AbstractBPMNActivity {
    private boolean m_completed = false;
    private BPMNActivity m_initialChoiceState = null;

    public RepeatActivity(Repeat repeat, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) throws BPMN2GenerationException {
        super(parent, model, notation);
        this.initialize(repeat);
    }

    protected void initialize(Repeat elem) throws BPMN2GenerationException {
        Object choiceState = this.getModelFactory().createDataBasedXORGateway(this.getContainer());
        this.m_initialChoiceState = new JunctionActivity(choiceState, this, this.getModelFactory(), this.getNotationFactory());
    }

    public void childrenComplete() {
        if (!this.m_completed) {
            List<Object> list;
            this.transitionSequentialNodes();
            if (this.m_initialChoiceState != null && (list = this.getModelFactory().getOutboundControlLinks(this.m_initialChoiceState.getEndNode())).size() > 0) {
                Object outgoing = list.get(0);
                this.getModelFactory().setLinkExpression(outgoing, "<non-observable>");
            }
            int width = 0;
            int height = 0;
            width = this.m_initialChoiceState.getWidth() + 50;
            height = this.m_initialChoiceState.getHeight();
            this.setWidth(this.getWidth() + width);
            this.setHeight(this.getHeight() + (height += 80));
            this.m_completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int junctionY = y + this.getHeight() - 40;
        this.m_initialChoiceState.calculatePosition(x, junctionY - this.m_initialChoiceState.getHeight() / 2);
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            if (!(act instanceof SequenceActivity)) continue;
            int gap = 10;
            act.calculatePosition(x + this.m_initialChoiceState.getWidth() + 50, junctionY - act.getHeight() - gap);
        }
    }

    public void draw(Object parent) {
        for (int i = 0; i < this.getChildStates().size(); ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.draw(parent);
            if (i <= 0) continue;
            BPMNActivity prev = this.getChildStates().get(i - 1);
            prev.transitionTo(act, null, parent);
        }
        if (this.getChildStates().size() > 0) {
            BPMNActivity act = this.getChildStates().get(this.getChildStates().size() - 1);
            Object link = this.getModelFactory().createControlLink(this.getContainer(), act.getEndNode(), this.getStartNode(), null);
            BPMNEdge edge = (BPMNEdge)this.getNotationFactory().createSequenceLink(this.getModelFactory(), link, parent);
            Point p1 = new Point();
            p1.setY(((Point)edge.getWaypoint().get(0)).getY());
            p1.setX(((Point)edge.getWaypoint().get(0)).getX() + 40.0);
            Point p2 = new Point();
            p2.setY((double)(act.getY() - 20));
            p2.setX(((Point)edge.getWaypoint().get(0)).getX() + 40.0);
            Point p3 = new Point();
            p3.setY((double)(act.getY() - 20));
            p3.setX(((Point)edge.getWaypoint().get(1)).getX() + 22.0);
            ((Point)edge.getWaypoint().get(1)).setX(((Point)edge.getWaypoint().get(1)).getX() + 22.0);
            ((Point)edge.getWaypoint().get(1)).setY(((Point)edge.getWaypoint().get(1)).getY() - 22.0);
            edge.getWaypoint().add(1, p1);
            edge.getWaypoint().add(2, p2);
            edge.getWaypoint().add(3, p3);
        }
    }

    public void transitionTo(BPMNActivity toNode, String expression, Object parent) {
        Object ret = this.getModelFactory().createControlLink(this.getContainer(), this.getEndNode(), toNode.getStartNode(), expression);
        BPMNEdge edge = (BPMNEdge)this.getNotationFactory().createSequenceLink(this.getModelFactory(), ret, parent);
        Point p1 = new Point();
        p1.setY(((Point)edge.getWaypoint().get(0)).getY());
        p1.setX(((Point)edge.getWaypoint().get(1)).getX() - 40.0);
        Point p2 = new Point();
        p2.setY(((Point)edge.getWaypoint().get(1)).getY());
        p2.setX(((Point)edge.getWaypoint().get(1)).getX() - 40.0);
        edge.getWaypoint().add(1, p1);
        edge.getWaypoint().add(2, p2);
    }

    public Object getStartNode() {
        Object ret = null;
        BPMNActivity state = this.getStartState();
        if (state != null) {
            ret = state.getStartNode();
        }
        return ret;
    }

    public BPMNActivity getStartState() {
        return this.m_initialChoiceState;
    }

    public BPMNActivity getEndState() {
        return this.m_initialChoiceState;
    }

    public Object getEndNode() {
        return this.m_initialChoiceState.getEndNode();
    }

    public boolean canDeleteEndNode() {
        return false;
    }
}

