/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.generation.components;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.savara.bpmn2.internal.generation.BPMN2GenerationException;
import org.savara.bpmn2.internal.generation.BPMN2ModelFactory;
import org.savara.bpmn2.internal.generation.BPMN2NotationFactory;
import org.savara.bpmn2.internal.generation.components.AbstractBPMNActivity;
import org.savara.bpmn2.internal.generation.components.BPMNActivity;
import org.savara.bpmn2.internal.generation.components.BoundaryEvent;
import org.savara.bpmn2.internal.generation.components.JunctionActivity;
import org.savara.bpmn2.internal.generation.components.SequenceActivity;
import org.savara.bpmn2.internal.generation.components.ServiceTaskActivity;
import org.savara.bpmn2.model.TServiceTask;
import org.scribble.protocol.model.Interaction;

public class ServiceInvocationActivity
extends AbstractBPMNActivity {
    private boolean _completed = false;
    private ServiceTaskActivity _serviceTaskState = null;
    private BPMNActivity _junctionState = null;
    private Map<BPMNActivity, BoundaryEvent> _faults = new HashMap<BPMNActivity, BoundaryEvent>();

    public ServiceInvocationActivity(Interaction request, BPMNActivity parent, BPMN2ModelFactory model, BPMN2NotationFactory notation) throws BPMN2GenerationException {
        super(parent, model, notation);
        this.initialize(request);
    }

    protected void initialize(Interaction req) throws BPMN2GenerationException {
        this._serviceTaskState = new ServiceTaskActivity(req, (BPMNActivity)this, this.getModelFactory(), this.getNotationFactory());
    }

    protected void addChildState(BPMNActivity child) {
        if (this._junctionState == null && child instanceof SequenceActivity) {
            Object junctionState = this.getModelFactory().createEventBasedXORGateway(this.getContainer(), true);
            this._junctionState = new JunctionActivity(junctionState, this, this.getModelFactory(), this.getNotationFactory());
        }
        super.addChildState(child);
    }

    public TServiceTask getServiceTask() {
        return this._serviceTaskState.getServiceTask();
    }

    public void register(BPMNActivity act, BoundaryEvent be) {
        this._faults.put(act, be);
    }

    public void childrenComplete() {
        if (!this._completed) {
            if (this.getChildStates().remove(this._junctionState)) {
                this.getChildStates().add(this._junctionState);
            }
            if (this._junctionState == null) {
                Vector<BPMNActivity> children = new Vector<BPMNActivity>();
                while (this.getChildStates().size() > 1) {
                    BPMNActivity act = this.getChildStates().get(1);
                    this.getChildStates().remove(1);
                    children.add(act);
                }
                if (children.size() > 0) {
                    this.promote(children, (AbstractBPMNActivity)this.getParent(), this);
                }
                this.setWidth(this._serviceTaskState.getWidth());
                this.setHeight(this._serviceTaskState.getHeight());
            } else {
                int width = this._serviceTaskState.getWidth() + this._junctionState.getWidth() + 100;
                int height = 0;
                int maxwidth = 0;
                BPMNActivity normalPath = null;
                for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
                    BPMNActivity umls = this.getChildStates().get(i);
                    if (!this._faults.containsKey(umls) && i > 1) {
                        normalPath = umls;
                    }
                    height += umls.getHeight();
                    if (i != 1) {
                        height += 40;
                    }
                    if (umls.getWidth() <= maxwidth) continue;
                    maxwidth = umls.getWidth();
                }
                if (normalPath != null) {
                    this.getChildStates().remove(normalPath);
                    this.getChildStates().add(1, normalPath);
                }
                width += maxwidth;
                if (height < this._serviceTaskState.getHeight()) {
                    height = this._serviceTaskState.getHeight();
                }
                if (height < this._junctionState.getHeight()) {
                    height = this._junctionState.getHeight();
                }
                this.setWidth(width);
                this.setHeight(height);
                this.adjustWidth(width);
            }
            this._completed = true;
        }
    }

    public void calculatePosition(int x, int y) {
        int cury = y;
        int midy = y + this.getHeight() / 2;
        this.setX(x);
        this.setY(y);
        int boundaryCount = 0;
        for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
            BPMNActivity act = this.getChildStates().get(i);
            act.calculatePosition(x + this._serviceTaskState.getWidth() + 50, cury);
            cury += act.getHeight() + 40;
            BoundaryEvent be = this._faults.get(act);
            if (be == null) continue;
            be.calculatePosition(x + 30 * boundaryCount++, midy + this._serviceTaskState.getHeight() / 2 - 15);
        }
        this._serviceTaskState.calculatePosition(x, midy - this._serviceTaskState.getHeight() / 2);
        if (this._junctionState != null) {
            this._junctionState.calculatePosition(x + this.getWidth() - this._junctionState.getWidth(), midy - this._junctionState.getHeight() / 2);
        }
    }

    public Object getStartNode() {
        return this._serviceTaskState.getStartNode();
    }

    public Object getEndNode() {
        return this._junctionState == null ? this._serviceTaskState.getEndNode() : this._junctionState.getEndNode();
    }

    public BPMNActivity getStartState() {
        return this._serviceTaskState;
    }

    public BPMNActivity getEndState() {
        return this._junctionState == null ? this._serviceTaskState : this._junctionState;
    }

    public void adjustWidth(int width) {
        if (this._junctionState == null) {
            this.setWidth(width);
        } else {
            int extrawidth = this._serviceTaskState.getWidth() + this._junctionState.getWidth() + 100;
            this.setWidth(width);
            for (int i = 1; i < this.getChildStates().size() - 1; ++i) {
                BPMNActivity umls = this.getChildStates().get(i);
                umls.adjustWidth(width - extrawidth);
            }
        }
    }

    public void draw(Object parent) {
        BPMNActivity act;
        int i;
        for (i = 0; i < this.getChildStates().size(); ++i) {
            act = this.getChildStates().get(i);
            act.draw(parent);
        }
        if (this._junctionState != null) {
            for (i = 1; i < this.getChildStates().size(); ++i) {
                act = this.getChildStates().get(i);
                if (act == this._junctionState) continue;
                BoundaryEvent be = this._faults.get(act);
                if (be != null) {
                    be.draw(parent);
                    if (act.getStartState() != null) {
                        be.transitionTo(act, null, parent);
                    } else {
                        be.transitionTo(this._junctionState, null, parent);
                    }
                } else if (act.getStartState() != null) {
                    this.getStartState().transitionTo(act, null, parent);
                } else {
                    this.getStartState().transitionTo(this._junctionState, null, parent);
                }
                if (act.getEndState() == null) continue;
                act.getEndState().transitionTo(this._junctionState, null, parent);
            }
        }
    }
}

