/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpmn2.internal.parser.choreo.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.savara.bpmn2.model.TChoreography;
import org.savara.bpmn2.model.TDefinitions;
import org.savara.bpmn2.model.TFlowNode;
import org.savara.protocol.model.Fork;
import org.savara.protocol.model.Join;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private TDefinitions m_definitions = null;
    private TChoreography _choreography = null;
    private Scope m_parent = null;
    private Map<String, Object> m_elements = new HashMap<String, Object>();
    private Map<String, Role> _roles = new HashMap<String, Role>();
    private Map<String, Join> _joins = new HashMap<String, Join>();
    private Map<String, Fork> _forks = new HashMap<String, Fork>();
    private Map<TFlowNode, Block> _joinBlocks = new HashMap<TFlowNode, Block>();
    private Map<Role, Introduces> _introduces = new HashMap<Role, Introduces>();
    private List<Parallel> _parallelReviewList = new Vector<Parallel>();

    public Scope(TDefinitions defns) {
        this.m_definitions = defns;
    }

    public Scope(Scope parent) {
        this.m_parent = parent;
    }

    public TDefinitions getDefinitions() {
        if (this.m_parent != null) {
            return this.m_parent.getDefinitions();
        }
        return this.m_definitions;
    }

    public void setChoreography(TChoreography choreo) {
        this._choreography = choreo;
    }

    public TChoreography getChoreography() {
        return this._choreography;
    }

    public Scope getParent() {
        return this.m_parent;
    }

    public Object getBPMN2Element(String id) {
        if (this.m_elements.containsKey(id)) {
            return this.m_elements.get(id);
        }
        if (this.m_parent != null) {
            return this.m_parent.getBPMN2Element(id);
        }
        return null;
    }

    public void registerBPMN2Element(String id, Object obj) {
        this.m_elements.put(id, obj);
    }

    public Role getRole(String name) {
        return this._roles.get(name);
    }

    public void registerRole(Role r) {
        this._roles.put(r.getName(), r);
    }

    public Fork getFork(String name) {
        return this._forks.get(name);
    }

    public void registerFork(Fork fork) {
        this._forks.put(fork.getLabel(), fork);
    }

    public Join getJoin(String name) {
        return this._joins.get(name);
    }

    public void registerJoin(Join join) {
        for (String label : join.getLabels()) {
            this._joins.put(label, join);
        }
    }

    public Map<Role, Introduces> getIntroduces() {
        return this._introduces;
    }

    public Map<TFlowNode, Block> getJoinBlocks() {
        return this._joinBlocks;
    }

    public List<Parallel> getParallelReviewList() {
        return this._parallelReviewList;
    }
}

