/*
 * Decompiled with CFR 0.152.
 */
package org.savara.java.generator;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.savara.common.resources.ResourceLocator;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaServiceGenerator {
    private static final Logger logger = Logger.getLogger(JavaServiceGenerator.class.getName());
    private WSDLReader _reader = null;

    public static void main(String[] args) {
        JavaServiceGenerator gen = new JavaServiceGenerator();
        if (args.length != 3) {
            System.err.println("Usage: SwitchyardJavaGenerator WSDLPath RelativeWSDLLocation DestinationFolder");
        }
        try {
            gen.createServiceInterfaceFromWSDL(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavaServiceGenerator() {
        try {
            this._reader = WSDLFactory.newInstance().newWSDLReader();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get WSDL reader", e);
        }
    }

    protected WSDLReader getWSDLReader() {
        return this._reader;
    }

    public void createServiceInterfaceFromWSDL(String wsdlPath, String wsdlLocation, String srcFolder) throws Exception {
        String[] cxfargs = new String[]{"-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
    }

    public void createServiceImplementationFromWSDL(Role role, List<Role> refRoles, ProtocolModel behaviour, String wsdlPath, String wsdlLocation, List<String> refWsdlPaths, String srcFolder, ResourceLocator locator) throws Exception {
        String[] cxfargs = new String[]{"-impl", "-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
    }
}

