/*
 * Decompiled with CFR 0.152.
 */
package org.savara.java.generator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.common.resources.ResourceLocator;
import org.savara.java.generator.util.JavaGeneratorUtil;
import org.savara.protocol.model.util.ChoiceUtil;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.util.TypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBehaviourGenerator {
    private static final Logger logger = Logger.getLogger(JavaBehaviourGenerator.class.getName());
    private ProtocolModel _behaviour = null;
    private ResourceLocator _locator = null;
    private List<String> _importedTypes = new Vector<String>();

    public JavaBehaviourGenerator(ProtocolModel behaviour, ResourceLocator locator) {
        this._behaviour = behaviour;
        this._locator = locator;
    }

    protected String getImportedType(String type) {
        String ret = type;
        if (ret.indexOf(46) != -1 && !this._importedTypes.contains(ret)) {
            this._importedTypes.add(ret);
        }
        return JavaBehaviourGenerator.getLocalJavaType(ret);
    }

    protected String getImportedType(Interaction interaction, ResourceLocator locator) {
        String ret = JavaBehaviourGenerator.getJavaType(interaction, locator);
        if (ret.indexOf(46) != -1 && !this._importedTypes.contains(ret)) {
            this._importedTypes.add(ret);
        }
        return JavaBehaviourGenerator.getLocalJavaType(ret);
    }

    protected static String getJavaType(Interaction interaction, ResourceLocator locator) {
        String ret = null;
        TypeReference tref = (TypeReference)interaction.getMessageSignature().getTypeReferences().get(0);
        TypeImport ti = TypesUtil.getTypeImport((TypeReference)tref);
        if (ti != null && ti.getDataType() != null) {
            QName type = QName.valueOf(ti.getDataType().getDetails());
            ret = JavaGeneratorUtil.getJavaPackage(type.getNamespaceURI());
            if (InteractionUtil.isFaultResponse((Interaction)interaction)) {
                Annotation ann;
                ret = JavaGeneratorUtil.getJavaClassName(InteractionUtil.getFaultName((Interaction)interaction)) + "Fault";
                if (!InteractionUtil.isSend((Interaction)interaction) && (ann = AnnotationDefinitions.getAnnotationWithProperty((List)interaction.getEnclosingProtocol().getAnnotations(), (String)"Interface", (String)"role", (Object)interaction.getFromRole().getName())) != null) {
                    String ns = (String)ann.getProperties().get("namespace");
                    ret = JavaGeneratorUtil.getJavaPackage(ns) + "." + ret;
                }
            } else {
                ret = ret + "." + JavaGeneratorUtil.getJavaClassName(type.getLocalPart());
                if (locator != null && ti.getParent() instanceof TypeImportList && ((TypeImportList)ti.getParent()).getLocation() != null) {
                    String location = ((TypeImportList)ti.getParent()).getLocation();
                    ret = JavaGeneratorUtil.getElementJavaType(type, location, locator);
                }
            }
        }
        return ret;
    }

    protected static String getLocalJavaType(String qualifiedType) {
        String ret = qualifiedType;
        int ind = qualifiedType.lastIndexOf(46);
        if (ind != -1) {
            ret = qualifiedType.substring(ind + 1);
        }
        return ret;
    }

    public static String getVariableName(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public String getOperationBody(String opName, String returnType, String parameterType, String parameterName, Map<Role, String> roleMapping) {
        String ret = null;
        Block block = this.getStatelessBehaviourForOperation(opName);
        if (block != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Behaviour for operation=" + opName + " is: " + block);
            }
            StringBuffer code = new StringBuffer();
            int indent = 2;
            HashMap<String, String> typeVarMap = new HashMap<String, String>();
            typeVarMap.put(this.getImportedType(parameterType), parameterName);
            if (!returnType.equals("void")) {
                this.newline(code, indent);
                String localType = this.getImportedType(returnType);
                code.append(localType + " ret=null;\r\n");
                typeVarMap.put(localType, "ret");
            }
            this.processBlock(block, code, indent, roleMapping, typeVarMap, this._locator);
            if (!returnType.equals("void")) {
                this.newline(code, indent);
                code.append("return (ret);");
            }
            ret = code.toString();
        }
        return ret;
    }

    public String getImportStatements() {
        StringBuffer code = new StringBuffer();
        for (String type : this._importedTypes) {
            code.append("import " + type + ";\r\n");
        }
        return code.toString();
    }

    protected Block getStatelessBehaviourForOperation(String opName) {
        Block ret = null;
        if (this._behaviour.getProtocol().getBlock().size() == 1 && this._behaviour.getProtocol().getBlock().get(0) instanceof Choice) {
            for (Block b : ((Choice)this._behaviour.getProtocol().getBlock().get(0)).getPaths()) {
                List interactions = org.scribble.protocol.util.InteractionUtil.getInitialInteractions((ModelObject)b);
                if (interactions == null) continue;
                if (interactions.size() == 1) {
                    MessageSignature msig = org.scribble.protocol.util.InteractionUtil.getMessageSignature((ModelObject)((ModelObject)interactions.get(0)));
                    if (msig.getOperation() == null || !msig.getOperation().equals(opName)) continue;
                    ret = b;
                    break;
                }
                logger.severe("Stateless behaviour shouldn't have more than one initial interaction for path: " + b);
            }
        } else {
            List interactions = org.scribble.protocol.util.InteractionUtil.getInitialInteractions((ModelObject)this._behaviour.getProtocol().getBlock());
            if (interactions != null) {
                if (interactions.size() == 1) {
                    MessageSignature msig = org.scribble.protocol.util.InteractionUtil.getMessageSignature((ModelObject)((ModelObject)interactions.get(0)));
                    if (msig.getOperation() != null && msig.getOperation().equals(opName)) {
                        ret = this._behaviour.getProtocol().getBlock();
                    }
                } else {
                    logger.severe("Stateless behaviour shouldn't have more than one initial interaction for path: " + this._behaviour.getProtocol().getBlock());
                }
            }
        }
        return ret;
    }

    protected void processBlock(Block block, StringBuffer code, int indent, Map<Role, String> roleMap, Map<String, String> typeVarMap, ResourceLocator locator) {
        for (int i = 0; i < block.getContents().size(); ++i) {
            Activity act = (Activity)block.getContents().get(i);
            if (act instanceof Interaction) {
                Interaction interaction = (Interaction)act;
                if (InteractionUtil.isRequest((Interaction)interaction)) {
                    if (InteractionUtil.isSend((Interaction)interaction)) {
                        if (i + 1 >= block.getContents().size()) continue;
                        Activity next = (Activity)block.getContents().get(i + 1);
                        boolean processed = false;
                        if (next instanceof Interaction && InteractionUtil.isResponseForRequest((Interaction)((Interaction)next), (Interaction)interaction)) {
                            this.processInvoke(interaction, (Interaction)next, code, indent, roleMap, typeVarMap, locator);
                            ++i;
                            processed = true;
                        } else if (next instanceof Choice && InteractionUtil.isResponseAndFaultHandler((Choice)((Choice)next), (Interaction)interaction)) {
                            this.processInvoke(interaction, (Choice)next, code, indent, roleMap, typeVarMap, locator);
                            ++i;
                            processed = true;
                        }
                        if (processed) continue;
                        this.processInvoke(interaction, (Interaction)null, code, indent, roleMap, typeVarMap, locator);
                        continue;
                    }
                    this.processReceive(interaction, code, indent, roleMap, typeVarMap, locator);
                    continue;
                }
                if (!InteractionUtil.isResponse((Interaction)interaction) || !InteractionUtil.isSend((Interaction)interaction)) continue;
                this.processResponse(interaction, code, indent, roleMap, typeVarMap, locator);
                continue;
            }
            if (!(act instanceof Choice) || !ChoiceUtil.isDecisionMaker((Choice)((Choice)act))) continue;
            for (int j = 0; j < ((Choice)act).getPaths().size(); ++j) {
                Block path = (Block)((Choice)act).getPaths().get(j);
                HashMap<String, String> savedTypeVarMap = new HashMap<String, String>(typeVarMap);
                this.newline(code, indent);
                if (j == 0) {
                    code.append("if (false) { // TODO: Set expression");
                } else if (j != ((Choice)act).getPaths().size() - 1) {
                    code.append("} else if (false) { // TODO: Set expression");
                } else {
                    code.append("} else {");
                }
                this.processBlock(path, code, indent + 1, roleMap, typeVarMap, locator);
                typeVarMap = savedTypeVarMap;
            }
            this.newline(code, indent);
            code.append("}\r\n");
        }
    }

    protected void newline(StringBuffer code, int indent) {
        code.append("\r\n");
        for (int i = 0; i < indent; ++i) {
            code.append("    ");
        }
    }

    protected void processResponse(Interaction resp, StringBuffer code, int indent, Map<Role, String> roleMap, Map<String, String> typeVarMap, ResourceLocator locator) {
        if (InteractionUtil.isFaultResponse((Interaction)resp)) {
            String faultType = this.getImportedType(resp, locator);
            this.newline(code, indent);
            code.append("throw new " + faultType + "();");
        } else {
            String type = this.getImportedType(resp, locator);
            String name = typeVarMap.get(type);
            this.newline(code, indent);
            code.append("// TODO: Add code here to return response");
            this.newline(code, indent);
            code.append("// " + name + " = ....;");
        }
    }

    protected void processReceive(Interaction req, StringBuffer code, int indent, Map<Role, String> roleMap, Map<String, String> typeVarMap, ResourceLocator locator) {
        String type = this.getImportedType(req, locator);
        String name = typeVarMap.get(type);
        this.newline(code, indent);
        code.append("// TODO: Add code here to handle request (in variable '" + name + "')\r\n");
    }

    protected void processInvoke(Interaction req, Interaction resp, StringBuffer code, int indent, Map<Role, String> roleMap, Map<String, String> typeVarMap, ResourceLocator locator) {
        String roleVar = roleMap.get(req.getToRoles().get(0));
        String reqType = this.getImportedType(req, locator);
        String reqVarName = typeVarMap.get(reqType);
        if (reqVarName == null) {
            this.newline(code, indent);
            reqVarName = JavaBehaviourGenerator.getVariableName(req.getMessageSignature().getOperation()) + "Req";
            typeVarMap.put(reqType, reqVarName);
            code.append("// TODO: Add code here to initialize request");
            this.newline(code, indent);
            code.append(reqType + " " + reqVarName + "=null;\r\n");
        }
        this.newline(code, indent);
        if (resp != null) {
            String typeStr = this.getImportedType(resp, locator);
            String varName = typeVarMap.get(typeStr);
            if (varName == null) {
                varName = JavaBehaviourGenerator.getVariableName(req.getMessageSignature().getOperation()) + "Result";
                typeVarMap.put(typeStr, varName);
                code.append(typeStr + " ");
            }
            code.append(varName + " = ");
        }
        code.append(roleVar + "." + req.getMessageSignature().getOperation() + "(" + reqVarName + ");\r\n");
    }

    protected void processInvoke(Interaction req, Choice respAndFaults, StringBuffer code, int indent, Map<Role, String> roleMap, Map<String, String> typeVarMap, ResourceLocator locator) {
        Block normalPath = null;
        Interaction normalInteraction = null;
        Vector<Block> faultPaths = new Vector<Block>();
        Vector<Interaction> faultInteractions = new Vector<Interaction>();
        for (Block b : respAndFaults.getPaths()) {
            List ints = org.scribble.protocol.util.InteractionUtil.getInitialInteractions((ModelObject)b);
            if (ints.size() != 1) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Response fault handler path should only have single initial interaction: " + b);
                continue;
            }
            if (InteractionUtil.isFaultResponse((Interaction)((Interaction)ints.get(0)))) {
                faultPaths.add(b);
                faultInteractions.add((Interaction)ints.get(0));
                continue;
            }
            if (normalPath == null) {
                normalPath = b;
                normalInteraction = (Interaction)ints.get(0);
                continue;
            }
            logger.severe("More than one normal path exists in the choice: " + respAndFaults);
        }
        this.newline(code, indent);
        code.append("try {");
        ++indent;
        HashMap<String, String> savedTypeVarMap = new HashMap<String, String>(typeVarMap);
        String reqType = this.getImportedType(req, locator);
        String reqVarName = typeVarMap.get(reqType);
        if (reqVarName == null) {
            this.newline(code, indent);
            reqVarName = JavaBehaviourGenerator.getVariableName(req.getMessageSignature().getOperation()) + "Req";
            typeVarMap.put(reqType, reqVarName);
            code.append("// TODO: Add code here to initialize request");
            this.newline(code, indent);
            code.append(reqType + " " + reqVarName + "=null;\r\n");
        }
        this.newline(code, indent);
        if (normalPath != null && normalInteraction != null && normalInteraction.getMessageSignature().getTypeReferences().size() == 1) {
            String typeStr = this.getImportedType(normalInteraction, locator);
            String varName = typeVarMap.get(typeStr);
            if (varName == null) {
                varName = JavaBehaviourGenerator.getVariableName(req.getMessageSignature().getOperation()) + "Result";
                typeVarMap.put(typeStr, varName);
                code.append(typeStr + " ");
            }
            code.append(varName + " = ");
        }
        String roleVar = roleMap.get(req.getToRoles().get(0));
        code.append(roleVar + "." + req.getMessageSignature().getOperation() + "(" + reqVarName + ");\r\n");
        if (normalPath != null) {
            this.processBlock(normalPath, code, indent, roleMap, typeVarMap, locator);
        }
        --indent;
        typeVarMap = savedTypeVarMap;
        for (int i = 0; i < faultPaths.size(); ++i) {
            Block faultPath = (Block)faultPaths.get(i);
            Interaction faultInteraction = (Interaction)faultInteractions.get(i);
            savedTypeVarMap = new HashMap<String, String>(typeVarMap);
            String faultType = this.getImportedType(faultInteraction, locator);
            String faultName = JavaBehaviourGenerator.getVariableName(InteractionUtil.getFaultName((Interaction)faultInteraction));
            this.newline(code, indent);
            code.append("} catch (" + faultType + " " + faultName + ") {");
            typeVarMap.put(faultType, faultName);
            this.processBlock(faultPath, code, indent + 1, roleMap, typeVarMap, locator);
            typeVarMap = savedTypeVarMap;
        }
        this.newline(code, indent);
        code.append("}\r\n");
    }
}

