/*
 * Decompiled with CFR 0.152.
 */
package org.savara.java.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.savara.common.resources.ResourceLocator;
import org.savara.java.generator.util.JavaGeneratorUtil;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaServiceGenerator {
    private static final Logger logger = Logger.getLogger(JavaServiceGenerator.class.getName());
    private WSDLReader _reader = null;

    public static void main(String[] args) {
        JavaServiceGenerator gen = new JavaServiceGenerator();
        if (args.length != 3) {
            System.err.println("Usage: SwitchyardJavaGenerator WSDLPath RelativeWSDLLocation DestinationFolder");
        }
        try {
            gen.createServiceInterfaceFromWSDL(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavaServiceGenerator() {
        try {
            this._reader = WSDLFactory.newInstance().newWSDLReader();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get WSDL reader", e);
        }
    }

    protected WSDLReader getWSDLReader() {
        return this._reader;
    }

    public void createServiceInterfaceFromWSDL(String wsdlPath, String wsdlLocation, String srcFolder) throws Exception {
        String[] cxfargs = new String[]{"-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
    }

    protected void removeWebServiceAndClientAnnotations(String wsdlPath, String srcFolder) throws Exception {
        Definition defn = this.getWSDLReader().readWSDL(wsdlPath);
        if (defn != null) {
            String pack = JavaGeneratorUtil.getJavaPackage(defn.getTargetNamespace());
            String folder = pack.replace('.', File.separatorChar);
            for (PortType portType : defn.getPortTypes().values()) {
                File f = new File(srcFolder + File.separatorChar + folder + File.separatorChar + portType.getQName().getLocalPart() + ".java");
                if (f.exists()) {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] b = new byte[fis.available()];
                    fis.read(b);
                    StringBuffer text = new StringBuffer();
                    text.append(new String(b));
                    fis.close();
                    this.removeLines(text, "import javax.jws.");
                    this.removeLines(text, "        @Web");
                    this.removeLines(text, "    @Web");
                    this.removeLines(text, "@Web");
                    this.removeLines(text, "    @Oneway");
                    this.removeLines(text, "@SOAPBinding");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(text.toString().getBytes());
                    fos.close();
                } else {
                    logger.severe("Service file '" + f.getAbsolutePath() + "' does not exist");
                }
                if (!(f = new File(srcFolder + File.separatorChar + folder + File.separatorChar + portType.getQName().getLocalPart() + "Service.java")).exists() || f.delete()) continue;
                logger.warning("Failed to delete service client: " + f);
            }
        } else {
            logger.severe("Failed to retrieve WSDL definition '" + wsdlPath + "'");
        }
    }

    protected void removeLines(StringBuffer text, String startsWith) {
        int startindex = -1;
        int endindex = -1;
        do {
            startindex = text.indexOf(startsWith);
            endindex = text.indexOf("\n", startindex);
            if (startindex == -1 || endindex == -1) continue;
            text.replace(startindex, endindex + 1, "");
        } while (startindex != -1);
    }

    public void createServiceImplementationFromWSDL(Role role, List<Role> refRoles, ProtocolModel behaviour, String wsdlPath, String wsdlLocation, List<String> refWsdlPaths, String srcFolder, ResourceLocator locator) throws Exception {
        String[] cxfargs = new String[]{"-impl", "-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
    }
}

