/*
 * Decompiled with CFR 0.152.
 */
package org.savara.java.generator.util;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.savara.common.resources.ResourceLocator;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaGeneratorUtil {
    private static final Logger LOG = Logger.getLogger(JavaGeneratorUtil.class.getName());

    public static String getElementJavaType(QName element, String location, ResourceLocator locator) {
        String ret = null;
        try {
            URI uri = locator.getResourceURI(location);
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            DocumentBuilder builder = fact.newDocumentBuilder();
            InputStream is = uri.toURL().openStream();
            Document doc = builder.parse(is);
            is.close();
            NodeList elemList = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "element");
            for (int i = 0; i < elemList.getLength(); ++i) {
                Element elem = (Element)elemList.item(i);
                String name = elem.getAttribute("name");
                String elemType = elem.getAttribute("type");
                if (!elem.hasAttribute("type") && (elemType = name).length() > 0) {
                    elemType = Character.toUpperCase(elemType.charAt(0)) + elemType.substring(1);
                }
                if (!name.equals(element.getLocalPart())) continue;
                String prefix = XMLUtils.getPrefix((String)elemType);
                String ns = null;
                ns = prefix != null && prefix.trim().length() > 0 ? elem.lookupNamespaceURI(prefix) : elem.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
                ret = JavaGeneratorUtil.getJavaPackage(ns);
                ret = ret + "." + JavaGeneratorUtil.getJavaClassName(XMLUtils.getLocalname((String)elemType));
            }
            if (ret == null) {
                NodeList includeList = doc.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
                for (int i = 0; ret == null && i < includeList.getLength(); ++i) {
                    Element elem = (Element)includeList.item(i);
                    String schemaLocation = elem.getAttribute("schemaLocation");
                    File f = new File(location);
                    if (f.getParentFile() != null) {
                        schemaLocation = f.getParentFile().getPath() + File.separator + schemaLocation;
                    }
                    ret = JavaGeneratorUtil.getElementJavaType(element, schemaLocation, locator);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to obtain XSD schema '" + location + "'", e);
        }
        return ret;
    }

    public static String getJavaPackage(String namespace) {
        String ret = null;
        try {
            int index;
            URI uri = new URI(namespace);
            String host = uri.getHost();
            if (host.startsWith("www.")) {
                host = host.substring(4);
            }
            if ((index = host.lastIndexOf(46)) != -1) {
                ret = host.substring(index + 1);
                ret = ret + "." + host.substring(0, index);
            } else {
                ret = host;
            }
            ret = ret + uri.getPath().replace('/', '.');
            ret = ret.toLowerCase();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to get java package from namespace '" + namespace + "'", e);
        }
        return ret;
    }

    public static String getJavaClassName(String name) {
        String ret = name;
        if (name.length() > 0) {
            ret = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return ret;
    }
}

