/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.InteractionUtil;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.savara.common.model.annotation.Annotation;
import org.savara.pi4soa.cdm.parser.rules.ConverterContext;
import org.savara.pi4soa.cdm.parser.rules.ConverterRule;
import org.savara.pi4soa.cdm.parser.rules.ConverterUtil;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionConverterRuleImpl
implements ConverterRule {
    private static Logger logger = Logger.getLogger("org.pi4soa.scribble.cdm.parser.rules");

    @Override
    public boolean isSupported(Class<?> scribbleType, CDLType cdlType) {
        return scribbleType == Activity.class && cdlType instanceof org.pi4soa.cdl.Interaction;
    }

    @Override
    public ModelObject convert(ConverterContext context, Class<?> scribbleType, CDLType cdlType) {
        When cb;
        Block ret = new Block();
        org.pi4soa.cdl.Interaction cdl = (org.pi4soa.cdl.Interaction)cdlType;
        Block block = ret;
        Iterator iter = cdl.getExchangeDetails().iterator();
        Vector<When> cbs = new Vector<When>();
        while (iter.hasNext()) {
            Annotation annotation;
            ExchangeDetails details = (ExchangeDetails)iter.next();
            if (context.shouldIgnore(details)) continue;
            cb = new When();
            Interaction interaction = new Interaction();
            Annotation scannotation = new Annotation("SourceComponent");
            scannotation.getProperties().put("id", CDLTypeUtil.getURIFragment((CDLType)details));
            interaction.getAnnotations().add(scannotation);
            MessageSignature ms = InteractionConverterRuleImpl.createMessageSignature(details, (ModelObject)interaction);
            interaction.setMessageSignature(ms);
            cb.getBlock().add((Activity)interaction);
            if (cdl.getToRoleType() != null) {
                annotation = new Annotation("Interface");
                annotation.getProperties().put("name", InteractionConverterRuleImpl.getInterfaceName(cdl));
                interaction.getAnnotations().add(annotation);
            }
            interaction.setFromRole(new Role(InteractionConverterRuleImpl.getFromRole(context, details)));
            interaction.getToRoles().add(new Role(InteractionConverterRuleImpl.getToRole(context, details)));
            if (details.getAction() == ExchangeActionType.REQUEST) {
                List resps;
                if (details.getSendVariable() != null) {
                    interaction.getProperties().put("SendVariable", details.getSendVariable().getName());
                }
                if (details.getReceiveVariable() != null) {
                    interaction.getProperties().put("ReceiveVariable", details.getReceiveVariable().getName());
                }
                if ((resps = InteractionUtil.getResponseExchangeDetails((ExchangeDetails)details)) != null && resps.size() > 0) {
                    Annotation annotation2 = new Annotation("Correlation");
                    annotation2.getProperties().put("request", ConverterUtil.getLabel(details));
                    interaction.getAnnotations().add(annotation2);
                }
            } else {
                if (details.getReceiveVariable() != null) {
                    interaction.getProperties().put("SendVariable", details.getReceiveVariable().getName());
                }
                if (details.getSendVariable() != null) {
                    interaction.getProperties().put("ReceiveVariable", details.getReceiveVariable().getName());
                }
                if (details.getAction() == ExchangeActionType.RESPOND) {
                    annotation = new Annotation("Correlation");
                    annotation.getProperties().put("replyTo", ConverterUtil.getLabel(details));
                    interaction.getAnnotations().add(annotation);
                }
            }
            cbs.add(cb);
        }
        if (cbs.size() > 2) {
            block.getContents().addAll(((When)cbs.remove(0)).getBlock().getContents());
            Choice choice = new Choice();
            for (int i = 0; i < cbs.size(); ++i) {
                When cb2 = (When)cbs.get(i);
                choice.getWhens().add(cb2);
            }
            block.getContents().add(choice);
        } else {
            for (int i = 0; i < cbs.size(); ++i) {
                cb = (When)cbs.get(i);
                block.getContents().addAll(cb.getBlock().getContents());
            }
        }
        return ret;
    }

    public static Role getFromRole(ConverterContext context, ExchangeDetails ed) {
        ParticipantType ptype;
        Role fromRole = null;
        org.pi4soa.cdl.Interaction cdl = ed.getInteraction();
        if (ed.getAction() == ExchangeActionType.REQUEST) {
            ParticipantType ptype2;
            if (cdl.getFromParticipant() != null) {
                fromRole = (Role)context.getState(XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()));
                if (fromRole == null) {
                    logger.severe("Failed to get 'from' role '" + XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()) + "'");
                }
            } else if (cdl.getFromRoleType() != null && (fromRole = (Role)context.getState(XMLUtils.getLocalname((String)(ptype2 = PackageUtil.getParticipantForRoleType((RoleType)cdl.getFromRoleType())).getName()))) == null) {
                logger.severe("Failed to get 'from' role '" + XMLUtils.getLocalname((String)ptype2.getName()) + "'");
            }
        } else if (cdl.getToParticipant() != null) {
            fromRole = (Role)context.getState(XMLUtils.getLocalname((String)cdl.getToParticipant().getName()));
            if (fromRole == null) {
                logger.severe("Failed to get 'to' role '" + XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()) + "'");
            }
        } else if (cdl.getToRoleType() != null && (fromRole = (Role)context.getState(XMLUtils.getLocalname((String)(ptype = PackageUtil.getParticipantForRoleType((RoleType)cdl.getToRoleType())).getName()))) == null) {
            logger.severe("Failed to get 'to' role '" + XMLUtils.getLocalname((String)ptype.getName()) + "'");
        }
        return fromRole;
    }

    public static Role getToRole(ConverterContext context, ExchangeDetails ed) {
        ParticipantType ptype;
        Role toRole = null;
        org.pi4soa.cdl.Interaction cdl = ed.getInteraction();
        if (ed.getAction() == ExchangeActionType.REQUEST) {
            ParticipantType ptype2;
            if (cdl.getToParticipant() != null) {
                toRole = (Role)context.getState(XMLUtils.getLocalname((String)cdl.getToParticipant().getName()));
                if (toRole == null) {
                    logger.severe("Failed to get 'to' role '" + XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()) + "'");
                }
            } else if (cdl.getToRoleType() != null && (toRole = (Role)context.getState(XMLUtils.getLocalname((String)(ptype2 = PackageUtil.getParticipantForRoleType((RoleType)cdl.getToRoleType())).getName()))) == null) {
                logger.severe("Failed to get 'to' role '" + XMLUtils.getLocalname((String)ptype2.getName()) + "'");
            }
        } else if (cdl.getFromParticipant() != null) {
            toRole = (Role)context.getState(XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()));
            if (toRole == null) {
                logger.severe("Failed to get 'from' role '" + XMLUtils.getLocalname((String)cdl.getFromParticipant().getName()) + "'");
            }
        } else if (cdl.getFromRoleType() != null && (toRole = (Role)context.getState(XMLUtils.getLocalname((String)(ptype = PackageUtil.getParticipantForRoleType((RoleType)cdl.getFromRoleType())).getName()))) == null) {
            logger.severe("Failed to get 'from' role '" + XMLUtils.getLocalname((String)ptype.getName()) + "'");
        }
        return toRole;
    }

    public static MessageSignature createMessageSignature(ExchangeDetails details, ModelObject parent) {
        org.pi4soa.cdl.Interaction cdl = details.getInteraction();
        MessageSignature ms = new MessageSignature();
        ms.setOperation(cdl.getOperation());
        if (NamesUtil.isSet((String)details.getFaultName())) {
            Annotation annotation = new Annotation("Fault");
            annotation.getProperties().put("name", details.getFaultName());
            parent.getAnnotations().add(annotation);
        }
        if (details.getType() instanceof InformationType) {
            InformationType itype = (InformationType)details.getType();
            TypeReference ref = ConverterUtil.getTypeReference(itype);
            ms.getTypeReferences().add(ref);
        }
        return ms;
    }

    protected static String getInterfaceName(org.pi4soa.cdl.Interaction interaction) {
        String ret = null;
        if (interaction != null) {
            String intfName = InteractionConverterRuleImpl.getInterface(interaction);
            String ns = CDLTypeUtil.getNamespace((String)intfName, (CDLType)interaction, (boolean)false);
            if (ns == null) {
                ParticipantType ptype = null;
                if (interaction.getToRoleType() != null && (ptype = PackageUtil.getParticipantForRoleType((RoleType)interaction.getToRoleType())) != null) {
                    ns = CDLTypeUtil.getNamespace((String)ptype.getName(), (CDLType)interaction, (boolean)false);
                    logger.fine("Deriving namespace from interactions 'to' participant type=" + ns);
                }
                if (ns == null) {
                    ns = interaction.getPackage().getTargetNamespace();
                    logger.fine("Using CDL package targetNamespace=" + ns);
                }
            }
            String lp = XMLUtils.getLocalname((String)intfName);
            ret = NameSpaceUtil.getFullyQualifiedName((String)ns, (String)lp);
        }
        return ret;
    }

    protected static String getInterface(org.pi4soa.cdl.Interaction interaction) {
        String ret = null;
        if (interaction != null && interaction.getChannelVariable() != null && interaction.getChannelVariable().getType() instanceof ChannelType) {
            Behavior behavior;
            ChannelType ctype = (ChannelType)interaction.getChannelVariable().getType();
            if (ctype.getBehavior() != null) {
                ret = ctype.getBehavior().getInterface();
                if (!NamesUtil.isSet((String)ret)) {
                    ret = ctype.getBehavior().getName();
                }
            } else if (ctype.getRoleType() != null && (behavior = ctype.getRoleType().getBehavior(null)) != null && !NamesUtil.isSet((String)(ret = behavior.getInterface()))) {
                ret = behavior.getName();
            }
        }
        return ret;
    }
}

