/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Package;
import org.savara.common.logging.FeedbackHandler;
import org.savara.pi4soa.cdm.parser.rules.DefaultParserContext;
import org.savara.pi4soa.cdm.parser.rules.ParserRule;
import org.savara.pi4soa.cdm.parser.rules.ParserRuleFactory;
import org.savara.protocol.util.FeedbackHandlerProxy;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.export.text.TextProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.AnnotationProcessor;
import org.scribble.protocol.parser.ProtocolParser;

public class CDMProtocolParser
implements ProtocolParser {
    private static Logger logger = Logger.getLogger(CDMProtocolParser.class.getName());

    public boolean isSupported(Content content) {
        return content.hasExtension("cdm");
    }

    public ProtocolModel parse(Content content, Journal journal, ProtocolContext context) throws IOException {
        ProtocolModel ret = null;
        if (content != null) {
            try {
                InputStream is = content.getInputStream();
                Package cdlpack = CDLManager.load((InputStream)is);
                is.close();
                ParserRule rule = ParserRuleFactory.getConverter(ProtocolModel.class, (CDLType)cdlpack);
                if (rule != null) {
                    DefaultParserContext cctxt = new DefaultParserContext((FeedbackHandler)new FeedbackHandlerProxy(journal));
                    ret = (ProtocolModel)rule.parse(cctxt, ProtocolModel.class, (CDLType)cdlpack);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load model", e);
            }
            if (logger.isLoggable(Level.FINEST)) {
                TextProtocolExporter exporter = new TextProtocolExporter();
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    exporter.export(ret, journal, (OutputStream)os);
                    String str = new String(os.toByteArray());
                    System.out.println("EXPORTED CDM TEXT:");
                    System.out.println(str);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public void setAnnotationProcessor(AnnotationProcessor ap) {
    }
}

