/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser.rules;

import java.util.List;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.util.NamesUtil;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.pi4soa.cdm.parser.rules.CDMProtocolParserUtil;
import org.savara.pi4soa.cdm.parser.rules.ParserContext;
import org.savara.pi4soa.cdm.parser.rules.ParserRule;
import org.savara.pi4soa.cdm.parser.rules.ParserRuleFactory;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Catch;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.model.Try;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolParserRule
implements ParserRule {
    @Override
    public boolean isSupported(Class<?> scribbleType, CDLType cdlType) {
        return scribbleType == Protocol.class && cdlType instanceof Choreography;
    }

    @Override
    public ModelObject parse(ParserContext context, Class<?> scribbleType, CDLType cdlType) {
        Protocol ret = new Protocol();
        Choreography choreo = (Choreography)cdlType;
        Annotation scannotation = new Annotation("SourceComponent");
        scannotation.getProperties().put("id", CDLTypeUtil.getURIFragment((CDLType)choreo));
        ret.getAnnotations().add(scannotation);
        context.pushScope();
        ret.setName(choreo.getName());
        List<Role> roles = CDMProtocolParserUtil.getRoleParameters(choreo);
        for (Role r : roles) {
            ParameterDefinition pd = new ParameterDefinition();
            pd.setName(r.getName());
            ret.getParameterDefinitions().add(pd);
            context.setState(r.getName(), r);
        }
        roles = CDMProtocolParserUtil.getRoleDeclarations(choreo);
        if (roles.size() > 0) {
            RoleList rl = new RoleList();
            for (Role r : roles) {
                rl.getRoles().add(r);
                context.setState(r.getName(), r);
                Annotation annotation = AnnotationDefinitions.getAnnotation((List)r.getAnnotations(), (String)"Namespace");
                if (annotation == null) continue;
                Annotation pa = new Annotation("Namespace");
                pa.getProperties().putAll(annotation.getProperties());
                pa.getProperties().put("role", r.getName());
                ret.getAnnotations().add(pa);
            }
            ret.getBlock().add((org.scribble.protocol.model.Activity)rl);
        }
        if (choreo.getRoot() == Boolean.TRUE) {
            for (Choreography subchoreo : choreo.getPackage().getChoreographies()) {
                if (subchoreo != choreo) {
                    Protocol subconv = (Protocol)this.parse(context, Protocol.class, (CDLType)subchoreo);
                    ret.getBlock().getContents().add(subconv);
                    context.addProtocol(subconv);
                }
                for (int i = 0; i < subchoreo.getFinalizers().size(); ++i) {
                    FinalizerHandler finalizer = (FinalizerHandler)subchoreo.getFinalizers().get(i);
                    ParserRule rule = ParserRuleFactory.getConverter(Protocol.class, (CDLType)finalizer);
                    if (rule == null) continue;
                    Protocol subconv = (Protocol)rule.parse(context, Protocol.class, (CDLType)finalizer);
                    ret.getBlock().getContents().add(subconv);
                    context.addProtocol(subconv);
                }
            }
        }
        for (Choreography subchoreo : choreo.getEnclosedChoreographies()) {
            Protocol subconv = (Protocol)this.parse(context, Protocol.class, (CDLType)subchoreo);
            ret.getBlock().getContents().add(subconv);
            context.addProtocol(subconv);
            for (int i = 0; i < subchoreo.getFinalizers().size(); ++i) {
                FinalizerHandler finalizer = (FinalizerHandler)subchoreo.getFinalizers().get(i);
                ParserRule rule = ParserRuleFactory.getConverter(Protocol.class, (CDLType)finalizer);
                if (rule == null) continue;
                subconv = (Protocol)rule.parse(context, Protocol.class, (CDLType)finalizer);
                ret.getBlock().getContents().add(subconv);
                context.addProtocol(subconv);
            }
        }
        if (NamesUtil.isSet((String)choreo.getCompletionCondition()) || choreo.getExceptionHandler() != null && choreo.getExceptionHandler().getExceptionWorkUnits().size() > 0) {
            Try te = new Try();
            ret.getBlock().getContents().add(te);
            ProtocolParserRule.convertActivities(context, (List<Activity>)choreo.getActivities(), te.getBlock());
            for (int i = 0; choreo.getExceptionHandler() != null && i < choreo.getExceptionHandler().getExceptionWorkUnits().size(); ++i) {
                ExceptionWorkUnit ewu = (ExceptionWorkUnit)choreo.getExceptionHandler().getExceptionWorkUnits().get(i);
                Catch catchPath = new Catch();
                te.getCatches().add(catchPath);
                ProtocolParserRule.convertActivities(context, (List<Activity>)ewu.getActivities(), catchPath.getBlock());
            }
        } else {
            ProtocolParserRule.convertActivities(context, (List<Activity>)choreo.getActivities(), ret.getBlock());
        }
        if (ret.getBlock().getContents().size() > 0) {
            org.scribble.protocol.model.Activity lastAct = (org.scribble.protocol.model.Activity)ret.getBlock().getContents().get(ret.getBlock().getContents().size() - 1);
            int pos = 0;
            while (ret.getBlock().get(pos) != lastAct) {
                if (ret.getBlock().get(pos) instanceof Protocol) {
                    Protocol c = (Protocol)ret.getBlock().get(pos);
                    ret.getBlock().getContents().remove(pos);
                    ret.getBlock().getContents().add(c);
                    context.removeProtocol(c);
                    continue;
                }
                ++pos;
            }
        }
        context.popScope();
        return ret;
    }

    protected static void convertActivities(ParserContext context, List<Activity> acts, Block block) {
        for (Activity act : acts) {
            org.scribble.protocol.model.Activity activity;
            ParserRule rule = ParserRuleFactory.getConverter(org.scribble.protocol.model.Activity.class, (CDLType)act);
            if (rule == null || (activity = (org.scribble.protocol.model.Activity)rule.parse(context, org.scribble.protocol.model.Activity.class, (CDLType)act)) == null) continue;
            if (activity instanceof Block) {
                block.getContents().addAll(((Block)activity).getContents());
                continue;
            }
            block.getContents().add(activity);
        }
    }
}

