/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.DefaultCDLVisitor;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.savara.common.model.annotation.Annotation;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMProtocolParserUtil {
    public static TypeReference getTypeReference(InformationType infoType) {
        TypeReference ret = new TypeReference();
        String typeName = null;
        if (NamesUtil.isSet((String)infoType.getTypeName())) {
            typeName = infoType.getTypeName();
            Annotation scannotation = new Annotation("XSDType");
            ret.getAnnotations().add(scannotation);
        } else if (NamesUtil.isSet((String)infoType.getElementName())) {
            typeName = infoType.getElementName();
            Annotation scannotation = new Annotation("XSDElement");
            ret.getAnnotations().add(scannotation);
        }
        if (typeName != null) {
            ret.setName(infoType.getName());
        }
        return ret;
    }

    public static String getLabel(ExchangeDetails details) {
        String ret = null;
        if (details.getInteraction() != null) {
            ret = details.getInteraction().getOperation();
        }
        return ret;
    }

    public static List<Role> getRoleParameters(final Choreography choreo) {
        Vector<Role> ret = new Vector<Role>();
        final Vector partTypes = new Vector();
        final Vector partInstances = new Vector();
        choreo.visit((CDLVisitor)new DefaultCDLVisitor(){

            public void interaction(Interaction interaction) {
                ParticipantType ptype;
                if (interaction.getEnclosingChoreography() != choreo || choreo.getRoot() == Boolean.TRUE && (partTypes.size() > 0 || partInstances.size() > 0)) {
                    return;
                }
                if (interaction.getFromParticipant() != null) {
                    if (!partInstances.contains(interaction.getFromParticipant())) {
                        partInstances.add(interaction.getFromParticipant());
                    }
                } else {
                    ptype = PackageUtil.getParticipantForRoleType((RoleType)interaction.getFromRoleType());
                    if (ptype != null && !partTypes.contains(ptype)) {
                        partTypes.add(ptype);
                    }
                }
                if (choreo.getRoot() == Boolean.FALSE) {
                    if (interaction.getToParticipant() != null) {
                        if (!partInstances.contains(interaction.getToParticipant())) {
                            partInstances.add(interaction.getToParticipant());
                        }
                    } else {
                        ptype = PackageUtil.getParticipantForRoleType((RoleType)interaction.getToRoleType());
                        if (ptype != null && !partTypes.contains(ptype)) {
                            partTypes.add(ptype);
                        }
                    }
                }
            }
        });
        for (ParticipantType ptype : partTypes) {
            Role role = new Role();
            role.setName(XMLUtils.getLocalname((String)ptype.getName()));
            Annotation annotation = new Annotation("Namespace");
            annotation.getProperties().put("name", CDLTypeUtil.getNamespace((String)ptype.getName(), (CDLType)ptype, (boolean)true));
            role.getAnnotations().add(annotation);
            ret.add(role);
        }
        for (Participant pinst : partInstances) {
            if (pinst.getFree() != Boolean.TRUE) continue;
            Role role = new Role();
            role.setName(XMLUtils.getLocalname((String)pinst.getName()));
            Annotation annotation = new Annotation("Namespace");
            annotation.getProperties().put("name", CDLTypeUtil.getNamespace((String)pinst.getName(), (CDLType)pinst, (boolean)true));
            role.getAnnotations().add(annotation);
            ret.add(role);
        }
        return ret;
    }

    public static List<Introduces> getRoleDeclarations(final Choreography choreo) {
        Annotation annotation;
        Role role;
        Vector<Introduces> ret = new Vector<Introduces>();
        Vector<Role> roles = new Vector<Role>();
        final Vector partTypes = new Vector();
        final Vector partInstances = new Vector();
        final HashMap introducer = new HashMap();
        choreo.visit((CDLVisitor)new DefaultCDLVisitor(){

            public void interaction(Interaction interaction) {
                ParticipantType ptype;
                String fromRole = null;
                String toRole = null;
                if (interaction.getFromParticipant() != null) {
                    if (!partInstances.contains(interaction.getFromParticipant())) {
                        partInstances.add(interaction.getFromParticipant());
                    }
                    if (CDMProtocolParserUtil.isLocalParticipant(choreo, interaction.getFromParticipant().getName())) {
                        fromRole = XMLUtils.getLocalname((String)interaction.getFromParticipant().getName());
                    }
                } else {
                    ptype = PackageUtil.getParticipantForRoleType((RoleType)interaction.getFromRoleType());
                    if (ptype != null && !partTypes.contains(ptype)) {
                        partTypes.add(ptype);
                    }
                    fromRole = XMLUtils.getLocalname((String)ptype.getName());
                }
                if (interaction.getToParticipant() != null) {
                    if (!partInstances.contains(interaction.getToParticipant())) {
                        partInstances.add(interaction.getToParticipant());
                    }
                    if (CDMProtocolParserUtil.isLocalParticipant(choreo, interaction.getToParticipant().getName())) {
                        toRole = XMLUtils.getLocalname((String)interaction.getToParticipant().getName());
                    }
                } else {
                    ptype = PackageUtil.getParticipantForRoleType((RoleType)interaction.getToRoleType());
                    if (ptype != null && !partTypes.contains(ptype)) {
                        partTypes.add(ptype);
                    }
                    toRole = XMLUtils.getLocalname((String)ptype.getName());
                }
                if (fromRole != null && toRole != null && !introducer.containsKey(toRole)) {
                    introducer.put(toRole, fromRole);
                }
            }
        });
        if (choreo.getRoot() == Boolean.TRUE) {
            for (ParticipantType ptype : choreo.getPackage().getTypeDefinitions().getParticipantTypes()) {
                role = new Role();
                role.setName(XMLUtils.getLocalname((String)ptype.getName()));
                annotation = new Annotation("Namespace");
                annotation.getProperties().put("name", CDLTypeUtil.getNamespace((String)ptype.getName(), (CDLType)ptype, (boolean)true));
                role.getAnnotations().add(annotation);
                roles.add(role);
            }
        }
        for (Participant pinst : partInstances) {
            if (pinst.getFree() != Boolean.FALSE) continue;
            role = new Role();
            role.setName(XMLUtils.getLocalname((String)pinst.getName()));
            annotation = new Annotation("Namespace");
            annotation.getProperties().put("name", CDLTypeUtil.getNamespace((String)pinst.getName(), (CDLType)pinst, (boolean)true));
            role.getAnnotations().add(annotation);
            roles.add(role);
        }
        for (Role r : roles) {
            Introduces intro = null;
            String introducerRole = (String)introducer.get(r.getName());
            if (introducerRole == null) continue;
            for (Introduces i : ret) {
                if (!i.getIntroducer().getName().equals(introducerRole)) continue;
                intro = i;
                break;
            }
            if (intro == null) {
                intro = new Introduces();
                intro.setIntroducer(new Role(introducerRole));
                ret.add(intro);
            }
            intro.getIntroducedRoles().add(r);
        }
        return ret;
    }

    protected static boolean isLocalParticipant(Choreography choreo, String name) {
        boolean ret = false;
        for (Participant p : choreo.getParticipantDefinitions()) {
            if (!p.getName().equals(name)) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

