/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser.rules;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.NameSpace;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xml.XMLUtils;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.pi4soa.cdm.parser.rules.ParserContext;
import org.savara.pi4soa.cdm.parser.rules.ParserRule;
import org.savara.pi4soa.cdm.parser.rules.ParserRuleFactory;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DataType;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.util.InteractionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolModelParserRule
implements ParserRule {
    private static Logger logger = Logger.getLogger(ProtocolModelParserRule.class.getName());

    @Override
    public boolean isSupported(Class<?> scribbleType, CDLType cdlType) {
        return scribbleType == ProtocolModel.class && cdlType instanceof Package;
    }

    @Override
    public ModelObject parse(ParserContext context, Class<?> scribbleType, CDLType cdlType) {
        ProtocolModel ret = new ProtocolModel();
        Package cdlpack = (Package)cdlType;
        Annotation scannotation = new Annotation("SourceComponent");
        String uri = CDLTypeUtil.getURIFragment((CDLType)cdlpack);
        scannotation.getProperties().put("id", uri);
        ret.getAnnotations().add(scannotation);
        ret.getProperties().put("scribble.uri", uri);
        for (InformationType itype : cdlpack.getTypeDefinitions().getInformationTypes()) {
            this.setupTypeImport(itype, ret);
        }
        Iterator iter = cdlpack.getChoreographies().iterator();
        Choreography choreo = null;
        while (choreo == null && iter.hasNext()) {
            choreo = (Choreography)iter.next();
            if (choreo.getRoot() == Boolean.TRUE) continue;
            choreo = null;
        }
        ParserRule rule = ParserRuleFactory.getConverter(Protocol.class, choreo);
        if (rule != null) {
            ret.setProtocol((Protocol)rule.parse(context, Protocol.class, (CDLType)choreo));
            if (ret.getProtocol() != null) {
                Annotation prtannotation = new Annotation("Protocol");
                prtannotation.getProperties().put("namespace", cdlpack.getTargetNamespace());
                ret.getProtocol().getAnnotations().add(prtannotation);
                scannotation = new Annotation("SourceComponent");
                uri = CDLTypeUtil.getURIFragment((CDLType)choreo);
                scannotation.getProperties().put("id", uri);
                scannotation.getProperties().put("language", "cdm");
                ret.getProtocol().getAnnotations().add(scannotation);
                ret.getProperties().put("scribble.uri", uri);
                for (NameSpace ns : cdlpack.getTypeDefinitions().getNameSpaces()) {
                    Annotation type = new Annotation("Type");
                    type.getProperties().put("namespace", ns.getURI());
                    type.getProperties().put("prefix", ns.getPrefix());
                    if (ns.getSchemaLocation() != null && ns.getSchemaLocation().trim().length() > 0) {
                        type.getProperties().put("location", ns.getSchemaLocation());
                    }
                    ret.getProtocol().getAnnotations().add(type);
                }
                final Protocol top = ret.getProtocol();
                ret.getProtocol().visit((Visitor)new DefaultVisitor(){

                    public boolean start(Protocol elem) {
                        if (elem != top) {
                            AnnotationDefinitions.copyAnnotations((List)elem.getAnnotations(), (List)top.getAnnotations(), (String)"Interface");
                        }
                        return true;
                    }
                });
                ret.getProtocol().visit((Visitor)new DefaultVisitor(){

                    public boolean start(Choice elem) {
                        Role fromRole = null;
                        for (Block b : elem.getPaths()) {
                            if (fromRole == null) {
                                ModelObject mo;
                                List list = InteractionUtil.getInitialInteractions((ModelObject)b);
                                Iterator i$ = list.iterator();
                                while (i$.hasNext() && (!((mo = (ModelObject)i$.next()) instanceof Interaction) || (fromRole = ((Interaction)mo).getFromRole()) == null)) {
                                }
                            }
                            if (fromRole == null) continue;
                            break;
                        }
                        if (fromRole != null) {
                            elem.setRole(new Role(fromRole));
                        }
                        return true;
                    }
                });
            }
        } else {
            logger.severe("Failed to find conversation conversion rule");
        }
        return ret;
    }

    protected void setupTypeImport(InformationType infoType, ProtocolModel model) {
        XMLPrefixResolver resolver = CDLTypeUtil.getPrefixResolver((Package)infoType.getPackage());
        String typeName = null;
        Annotation xsdAnnotation = null;
        if (NamesUtil.isSet((String)infoType.getTypeName())) {
            typeName = infoType.getTypeName();
            xsdAnnotation = new Annotation("XSDType");
        } else if (NamesUtil.isSet((String)infoType.getElementName())) {
            typeName = infoType.getElementName();
            xsdAnnotation = new Annotation("XSDElement");
        }
        if (typeName != null) {
            String prefix = XMLUtils.getPrefix((String)typeName);
            String location = null;
            if (prefix != null) {
                for (NameSpace ns : infoType.getPackage().getTypeDefinitions().getNameSpaces()) {
                    if (!ns.getPrefix().equals(prefix)) continue;
                    location = ns.getURI();
                    break;
                }
            }
            TypeImportList til = null;
            for (ImportList il : model.getImports()) {
                TypeImportList tilist;
                if (!(il instanceof TypeImportList) || ((tilist = (TypeImportList)il).getLocation() != null || location != null) && (tilist.getLocation() == null || location == null || !tilist.getLocation().equals(location) || AnnotationDefinitions.getAnnotation((List)tilist.getAnnotations(), (String)xsdAnnotation.getName()) == null)) continue;
                til = tilist;
                break;
            }
            if (til == null) {
                til = new TypeImportList();
                til.setFormat("xsd");
                til.setLocation(location);
                til.getAnnotations().add(xsdAnnotation);
                model.getImports().add(til);
            }
            TypeImport ti = til.getTypeImport(infoType.getName());
            String dataType = new QName(XMLUtils.getNamespace((String)typeName, (XMLPrefixResolver)resolver, null), XMLUtils.getLocalname((String)typeName)).toString();
            if (ti == null) {
                ti = new TypeImport();
                ti.setName(infoType.getName());
                ti.setDataType(new DataType(dataType));
                til.getTypeImports().add(ti);
            }
        }
    }
}

