/*
 * Decompiled with CFR 0.152.
 */
package org.savara.pi4soa.cdm.parser.rules;

import java.util.Iterator;
import java.util.List;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.util.NamesUtil;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.pi4soa.cdm.parser.rules.CDMProtocolParserUtil;
import org.savara.pi4soa.cdm.parser.rules.ParserContext;
import org.savara.pi4soa.cdm.parser.rules.ParserRule;
import org.savara.pi4soa.cdm.parser.rules.ParserRuleFactory;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.RoleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolParserRule
implements ParserRule {
    @Override
    public boolean isSupported(Class<?> scribbleType, CDLType cdlType) {
        return scribbleType == Protocol.class && cdlType instanceof Choreography;
    }

    @Override
    public ModelObject parse(ParserContext context, Class<?> scribbleType, CDLType cdlType) {
        Protocol ret = new Protocol();
        Choreography choreo = (Choreography)cdlType;
        Annotation scannotation = new Annotation("SourceComponent");
        String uri = CDLTypeUtil.getURIFragment((CDLType)choreo);
        scannotation.getProperties().put("id", uri);
        ret.getAnnotations().add(scannotation);
        ret.getProperties().put("scribble.uri", uri);
        context.pushScope();
        ret.setName(choreo.getName());
        List<Role> roles = CDMProtocolParserUtil.getRoleParameters(choreo);
        for (Role r : roles) {
            Annotation annotation;
            ParameterDefinition pd = new ParameterDefinition();
            pd.setName(r.getName());
            ret.getParameterDefinitions().add(pd);
            context.setState(r.getName(), r);
            if (choreo.getRoot() != Boolean.TRUE || (annotation = AnnotationDefinitions.getAnnotation((List)r.getAnnotations(), (String)"Interface")) == null) continue;
            Annotation pa = new Annotation("Interface");
            pa.getProperties().putAll(annotation.getProperties());
            pa.getProperties().put("role", r.getName());
            ret.getAnnotations().add(pa);
        }
        List<Introduces> declared = CDMProtocolParserUtil.getRoleDeclarations(choreo);
        if (declared.size() > 0) {
            for (Introduces intro : declared) {
                for (Role r : intro.getIntroducedRoles()) {
                    context.setState(r.getName(), r);
                    Annotation annotation = AnnotationDefinitions.getAnnotation((List)r.getAnnotations(), (String)"Interface");
                    if (annotation == null) continue;
                    Annotation pa = new Annotation("Interface");
                    pa.getProperties().putAll(annotation.getProperties());
                    pa.getProperties().put("role", r.getName());
                    ret.getAnnotations().add(pa);
                }
                ret.getBlock().add((org.scribble.protocol.model.Activity)intro);
            }
        }
        if (choreo.getRoot() == Boolean.TRUE) {
            for (Choreography subchoreo : choreo.getPackage().getChoreographies()) {
                if (subchoreo != choreo) {
                    Protocol subconv = (Protocol)this.parse(context, Protocol.class, (CDLType)subchoreo);
                    ret.getNestedProtocols().add(subconv);
                    context.addProtocol(subconv);
                }
                for (int i = 0; i < subchoreo.getFinalizers().size(); ++i) {
                    FinalizerHandler finalizer = (FinalizerHandler)subchoreo.getFinalizers().get(i);
                    ParserRule rule = ParserRuleFactory.getConverter(Protocol.class, (CDLType)finalizer);
                    if (rule == null) continue;
                    Protocol subconv = (Protocol)rule.parse(context, Protocol.class, (CDLType)finalizer);
                    ret.getNestedProtocols().add(subconv);
                    context.addProtocol(subconv);
                }
            }
        }
        for (Choreography subchoreo : choreo.getEnclosedChoreographies()) {
            Protocol subconv = (Protocol)this.parse(context, Protocol.class, (CDLType)subchoreo);
            ret.getNestedProtocols().add(subconv);
            context.addProtocol(subconv);
            for (int i = 0; i < subchoreo.getFinalizers().size(); ++i) {
                FinalizerHandler finalizer = (FinalizerHandler)subchoreo.getFinalizers().get(i);
                ParserRule rule = ParserRuleFactory.getConverter(Protocol.class, (CDLType)finalizer);
                if (rule == null) continue;
                subconv = (Protocol)rule.parse(context, Protocol.class, (CDLType)finalizer);
                ret.getNestedProtocols().add(subconv);
                context.addProtocol(subconv);
            }
        }
        if (NamesUtil.isSet((String)choreo.getCompletionCondition()) || choreo.getExceptionHandler() != null && choreo.getExceptionHandler().getExceptionWorkUnits().size() > 0) {
            Do te = new Do();
            ret.getBlock().getContents().add(te);
            ProtocolParserRule.convertActivities(context, (List<Activity>)choreo.getActivities(), te.getBlock());
            for (int i = 0; choreo.getExceptionHandler() != null && i < choreo.getExceptionHandler().getExceptionWorkUnits().size(); ++i) {
                ExceptionWorkUnit ewu = (ExceptionWorkUnit)choreo.getExceptionHandler().getExceptionWorkUnits().get(i);
                Interrupt interruptPath = new Interrupt();
                te.getInterrupts().add(interruptPath);
                ProtocolParserRule.convertActivities(context, (List<Activity>)ewu.getActivities(), interruptPath.getBlock());
            }
        } else {
            ProtocolParserRule.convertActivities(context, (List<Activity>)choreo.getActivities(), ret.getBlock());
        }
        if (ret != null && ret.getBlock().size() > 0) {
            org.scribble.protocol.model.Activity act;
            Iterator i$ = ret.getBlock().getContents().iterator();
            while (i$.hasNext() && (act = (org.scribble.protocol.model.Activity)i$.next()) instanceof Introduces) {
                Introduces rl = (Introduces)act;
                for (int i = rl.getIntroducedRoles().size() - 1; i >= 0; --i) {
                    Role r = (Role)rl.getIntroducedRoles().get(i);
                    Block b = RoleUtil.getEnclosingBlock((Protocol)ret, (Role)r, (boolean)false);
                    if (b == null || b == ret.getBlock()) continue;
                    Introduces innerrl = null;
                    if (b.size() > 0 && b.get(0) instanceof Introduces && ((Introduces)b.get(0)).getIntroducer().equals((Object)rl.getIntroducer())) {
                        innerrl = (Introduces)b.get(0);
                    } else {
                        innerrl = new Introduces();
                        innerrl.setIntroducer(rl.getIntroducer());
                        b.getContents().add(0, innerrl);
                    }
                    rl.getIntroducedRoles().remove(r);
                    innerrl.getIntroducedRoles().add(r);
                }
                if (rl.getIntroducedRoles().size() != 0) continue;
                ret.getBlock().remove((org.scribble.protocol.model.Activity)rl);
            }
        }
        if (choreo.getRoot() == Boolean.TRUE && ret.getParameterDefinitions().size() == 0 && ret.getBlock().size() > 0 && ret.getBlock().get(0) instanceof Introduces) {
            Introduces intros = (Introduces)ret.getBlock().get(0);
            ParameterDefinition pd = new ParameterDefinition();
            pd.setName(intros.getIntroducer().getName());
            ret.getParameterDefinitions().add(pd);
        }
        context.popScope();
        return ret;
    }

    protected static void convertActivities(ParserContext context, List<Activity> acts, Block block) {
        for (Activity act : acts) {
            org.scribble.protocol.model.Activity activity;
            ParserRule rule = ParserRuleFactory.getConverter(org.scribble.protocol.model.Activity.class, (CDLType)act);
            if (rule == null || (activity = (org.scribble.protocol.model.Activity)rule.parse(context, org.scribble.protocol.model.Activity.class, (CDLType)act)) == null) continue;
            if (activity instanceof Block) {
                block.getContents().addAll(((Block)activity).getContents());
                continue;
            }
            block.getContents().add(activity);
        }
    }
}

