/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.internal.protocol;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.Group;
import org.savara.scenario.model.Import;
import org.savara.scenario.model.Link;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.Scenario;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.model.TimeElapsedEvent;
import org.savara.scenario.protocol.ProtocolModelGenerator;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.DataType;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.util.TypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolModelGeneratorImpl
implements ProtocolModelGenerator {
    private static final String NAMESPACE_PREFIX = "http://namespace/";
    private static final String INTERFACE_SUFFIX = "Interface";

    @Override
    public Set<ProtocolModel> generate(Scenario scenario, FeedbackHandler handler) {
        HashSet<ProtocolModel> ret = new HashSet<ProtocolModel>();
        for (Event event : scenario.getEvent()) {
            this.processEvent(event, ret, scenario, handler);
        }
        return ret;
    }

    protected void processEvent(Event event, Set<ProtocolModel> models, Scenario scenario, FeedbackHandler handler) {
        if (event instanceof Group) {
            for (Event evt : ((Group)event).getEvent()) {
                this.processEvent(evt, models, scenario, handler);
            }
        } else if (event instanceof SendEvent) {
            Annotation annotation;
            SendEvent se = (SendEvent)event;
            ProtocolModel pm = this.getProtocolModel(se, models, scenario);
            Interaction in = new Interaction();
            MessageSignature msig = new MessageSignature();
            msig.setOperation(se.getOperationName());
            if (se.getFaultName() != null && se.getFaultName().trim().length() > 0) {
                annotation = new Annotation("Fault");
                annotation.getProperties().put("name", se.getFaultName());
                in.getAnnotations().add(annotation);
            }
            if (ProtocolModelGeneratorImpl.isRequest(scenario, pm.getProtocol(), se)) {
                annotation = new Annotation("Correlation");
                annotation.getProperties().put("request", se.getOperationName());
                in.getAnnotations().add(annotation);
            } else {
                annotation = new Annotation("Correlation");
                annotation.getProperties().put("replyTo", se.getOperationName());
                in.getAnnotations().add(annotation);
            }
            for (Parameter p : se.getParameter()) {
                TypeReference tref = this.getTypeReference(p.getType(), pm);
                msig.getTypeReferences().add(tref);
            }
            in.setMessageSignature(msig);
            for (Link link : scenario.getLink()) {
                if (link.getSource() != event) continue;
                String otherRole = ((org.savara.scenario.model.Role)((MessageEvent)link.getTarget()).getRole()).getName();
                in.getToRoles().add(new Role(otherRole));
                break;
            }
            pm.getProtocol().getBlock().add((Activity)in);
        } else if (event instanceof ReceiveEvent) {
            Annotation annotation;
            ReceiveEvent re = (ReceiveEvent)event;
            ProtocolModel pm = this.getProtocolModel(re, models, scenario);
            Interaction in = new Interaction();
            MessageSignature msig = new MessageSignature();
            msig.setOperation(re.getOperationName());
            if (re.getFaultName() != null && re.getFaultName().trim().length() > 0) {
                annotation = new Annotation("Fault");
                annotation.getProperties().put("name", re.getFaultName());
                in.getAnnotations().add(annotation);
            }
            if (ProtocolModelGeneratorImpl.isRequest(scenario, pm.getProtocol(), re)) {
                annotation = new Annotation("Correlation");
                annotation.getProperties().put("request", re.getOperationName());
                in.getAnnotations().add(annotation);
            } else {
                annotation = new Annotation("Correlation");
                annotation.getProperties().put("replyTo", re.getOperationName());
                in.getAnnotations().add(annotation);
            }
            for (Parameter p : re.getParameter()) {
                TypeReference tref = this.getTypeReference(p.getType(), pm);
                msig.getTypeReferences().add(tref);
            }
            in.setMessageSignature(msig);
            for (Link link : scenario.getLink()) {
                if (link.getTarget() != event) continue;
                String otherRole = ((org.savara.scenario.model.Role)((MessageEvent)link.getSource()).getRole()).getName();
                in.setFromRole(new Role(otherRole));
                break;
            }
            pm.getProtocol().getBlock().add((Activity)in);
        } else if (event instanceof Import || event instanceof TimeElapsedEvent) {
            // empty if block
        }
    }

    protected TypeReference getTypeReference(String type, ProtocolModel model) {
        TypeReference ret = new TypeReference();
        QName qname = QName.valueOf(type);
        ret.setName(qname.getLocalPart());
        TypeImport ti = TypesUtil.getTypeImport((TypeReference)ret);
        if (ti == null) {
            ti = new TypeImport();
            ti.setName(qname.getLocalPart());
            DataType dt = new DataType();
            dt.setDetails(type);
            ti.setDataType(dt);
            TypeImportList il = new TypeImportList();
            il.setFormat("xsd");
            il.getTypeImports().add(ti);
            model.getImports().add(il);
            if (AnnotationDefinitions.getAnnotationWithProperty((List)model.getProtocol().getAnnotations(), (String)"Type", (String)"namespace", (Object)qname.getNamespaceURI()) == null) {
                int nsCount = AnnotationDefinitions.getAnnotations((List)model.getProtocol().getAnnotations(), (String)"Type").size();
                Annotation protocolAnn = new Annotation("Type");
                protocolAnn.getProperties().put("namespace", qname.getNamespaceURI());
                protocolAnn.getProperties().put("prefix", "ns" + nsCount);
                model.getProtocol().getAnnotations().add(protocolAnn);
            }
        }
        return ret;
    }

    protected ProtocolModel getProtocolModel(MessageEvent event, Set<ProtocolModel> models, Scenario scenario) {
        ProtocolModel ret = null;
        String role = ((org.savara.scenario.model.Role)event.getRole()).getName();
        for (ProtocolModel pm : models) {
            if (!pm.getProtocol().getLocatedRole().getName().equals(role)) continue;
            ret = pm;
            break;
        }
        if (ret == null) {
            ret = new ProtocolModel();
            ret.setProtocol(new Protocol());
            ret.getProtocol().setName(scenario.getName());
            ret.getProtocol().setLocatedRole(new Role(role));
            ret.getProtocol().setBlock(new Block());
            this.createInterface(ret.getProtocol(), role);
            if (event instanceof ReceiveEvent) {
                for (Link link : scenario.getLink()) {
                    if (link.getTarget() != event) continue;
                    ParameterDefinition pd = new ParameterDefinition();
                    pd.setName(((org.savara.scenario.model.Role)((MessageEvent)link.getSource()).getRole()).getName());
                    ret.getProtocol().getParameterDefinitions().add(pd);
                    break;
                }
            }
            models.add(ret);
        }
        if (ret != null && event instanceof SendEvent) {
            for (Link link : scenario.getLink()) {
                if (link.getSource() != event) continue;
                String otherRole = ((org.savara.scenario.model.Role)((MessageEvent)link.getTarget()).getRole()).getName();
                if (ret.getProtocol().getParameterDefinitions().size() != 0 && ((ParameterDefinition)ret.getProtocol().getParameterDefinitions().get(0)).getName().equals(otherRole)) break;
                Introduces intro = null;
                if (ret.getProtocol().getBlock().size() > 0 && ret.getProtocol().getBlock().get(0) instanceof Introduces) {
                    intro = (Introduces)ret.getProtocol().getBlock().get(0);
                } else {
                    intro = new Introduces();
                    intro.setIntroducer(new Role(ret.getProtocol().getLocatedRole().getName()));
                    ret.getProtocol().getBlock().getContents().add(0, intro);
                }
                if (intro.getIntroducedRole(otherRole) != null) break;
                intro.getIntroducedRoles().add(new Role(otherRole));
                this.createInterface(ret.getProtocol(), otherRole);
                break;
            }
        }
        return ret;
    }

    protected void createInterface(Protocol p, String role) {
        Annotation annotation = new Annotation(INTERFACE_SUFFIX);
        annotation.getProperties().put("namespace", NAMESPACE_PREFIX + role);
        annotation.getProperties().put("name", role + INTERFACE_SUFFIX);
        annotation.getProperties().put("role", role);
        p.getAnnotations().add(annotation);
    }

    protected static boolean isRequest(Scenario scenario, Protocol p, MessageEvent me) {
        boolean ret = false;
        String otherRole = null;
        for (Link link : scenario.getLink()) {
            if (me instanceof SendEvent && link.getSource() == me) {
                otherRole = ((org.savara.scenario.model.Role)((MessageEvent)link.getTarget()).getRole()).getName();
                break;
            }
            if (!(me instanceof ReceiveEvent) || link.getTarget() != me) continue;
            otherRole = ((org.savara.scenario.model.Role)((MessageEvent)link.getSource()).getRole()).getName();
            break;
        }
        if (otherRole != null) {
            if (p.getParameterDefinitions().size() > 0 && ((ParameterDefinition)p.getParameterDefinitions().get(0)).getName().equals(otherRole)) {
                ret = me instanceof ReceiveEvent;
            } else if (me instanceof SendEvent && p.getBlock().size() > 0 && p.getBlock().get(0) instanceof Introduces) {
                Introduces intro = (Introduces)p.getBlock().get(0);
                ret = intro.getIntroducedRole(otherRole) != null;
            }
        }
        return ret;
    }
}

