/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.saynotobugs.confidence.junit5.engine.Assertion;
import org.saynotobugs.confidence.junit5.engine.testengine.Testable;
import org.saynotobugs.confidence.junit5.engine.testengine.testdescriptor.FieldTestDescriptor;

public final class ClassTestDescriptor
extends AbstractTestDescriptor
implements Testable {
    public ClassTestDescriptor(UniqueId uniqueId, Class<?> javaClass) {
        super(uniqueId.append("class", javaClass.getName()), javaClass.getSimpleName(), (TestSource)ClassSource.from(javaClass));
        Arrays.stream(javaClass.getDeclaredFields()).filter(field -> Assertion.class.isAssignableFrom(field.getType())).map(field -> new FieldTestDescriptor(this.getUniqueId(), javaClass, (Field)field)).forEach(arg_0 -> ((ClassTestDescriptor)this).addChild(arg_0));
    }

    @Override
    public void test(EngineExecutionListener listener) {
        this.children.forEach(descriptor -> {
            listener.executionStarted(descriptor);
            try {
                ((Testable)descriptor).test(listener);
                listener.executionFinished(descriptor, TestExecutionResult.successful());
            }
            catch (Throwable e) {
                listener.executionFinished(descriptor, TestExecutionResult.failed((Throwable)e));
            }
        });
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }
}

