/*
 * Decompiled with CFR 0.152.
 */
package org.saynotobugs.confidence.junit5.engine.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.dmfs.jems2.Generator;
import org.saynotobugs.confidence.junit5.engine.ResourceComposition;
import org.saynotobugs.confidence.junit5.engine.resource.LazyResource;

public final class SystemOut
extends ResourceComposition<Generator<String>> {
    public SystemOut() {
        super(new LazyResource(() -> {
            PrintStream original = System.out;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream redirected = new PrintStream(new TeeStream(out, original));
            System.setOut(redirected);
            return new Context(original, redirected, out);
        }, context -> () -> {
            ((Context)context).mRedirected.flush();
            return ((Context)context).mRawByteStream.toString();
        }, (stringGenerator, context) -> {
            System.setOut(((Context)context).mOriginal);
            ((Context)context).mRedirected.close();
        }));
    }

    private static final class Context {
        private final PrintStream mOriginal;
        private final PrintStream mRedirected;
        private final ByteArrayOutputStream mRawByteStream;

        private Context(PrintStream original, PrintStream redirected, ByteArrayOutputStream rawByteStream) {
            this.mOriginal = original;
            this.mRedirected = redirected;
            this.mRawByteStream = rawByteStream;
        }
    }

    private static final class TeeStream
    extends OutputStream {
        private final OutputStream mDelegate;
        private final OutputStream mOriginal;

        private TeeStream(OutputStream delegate, OutputStream original) {
            this.mDelegate = delegate;
            this.mOriginal = original;
        }

        @Override
        public void write(int i) throws IOException {
            this.mDelegate.write(i);
            this.mOriginal.write(i);
        }

        @Override
        public void flush() throws IOException {
            this.mDelegate.flush();
            this.mOriginal.flush();
        }

        @Override
        public void close() throws IOException {
            this.mDelegate.close();
        }
    }
}

