/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.oboparser.obo.OBOStanza;
import org.oboparser.obo.OBOValue;

public class OBOOntology
extends OBOStanza {
    private Map<String, OBOStanza> stanzas = new TreeMap<String, OBOStanza>();

    public OBOOntology() {
        super("ontology");
    }

    public void addOBOStanza(OBOStanza s) {
        assert (s != null);
        String id = s.getId();
        if (id == null || this.stanzas.containsKey(id)) {
            throw new IllegalArgumentException(String.format("ID: \"%s\"", id));
        }
        this.stanzas.put(id, s);
    }

    public void add(OBOOntology ont) {
        super.add(ont);
        for (String key : ont.stanzas.keySet()) {
            if (!this.stanzas.containsKey(key)) {
                this.stanzas.put(key, (OBOStanza)ont.stanzas.get(key).clone());
                continue;
            }
            this.stanzas.get(key).add(ont.stanzas.get(key));
        }
    }

    @Override
    public void print(PrintWriter w) {
        for (String id : this.stanzas.keySet()) {
            this.stanzas.get(id).print(w);
        }
    }

    public Collection<OBOStanza> getStanzas() {
        return this.stanzas.values();
    }

    public OBOStanza getStanza(String id) {
        return this.stanzas.get(id);
    }

    public boolean isDescendantOf(OBOStanza child, OBOStanza terminateParent) {
        boolean result = false;
        if (child.hasValue("replaced_by")) {
            for (OBOValue newChildId : child.values("replaced_by")) {
                child = this.getStanza(newChildId.getValue().trim());
            }
        }
        if (!child.hasValue("is_a")) {
            return false;
        }
        for (OBOValue immediateParentInfo : child.values("is_a")) {
            String immediateParentId = immediateParentInfo.getValue().trim();
            if (immediateParentId.equals(terminateParent.getId().trim())) {
                return true;
            }
            OBOStanza immediateParent = this.getStanza(immediateParentId);
            if (!(result = result || this.isDescendantOf(immediateParent, terminateParent))) continue;
            break;
        }
        return result;
    }

    public Set<String> getDescendantsOf(OBOStanza terminateParent) {
        HashSet<String> result = new HashSet<String>();
        for (OBOStanza child : this.getStanzas()) {
            if (!child.hasValue("is_a")) continue;
            for (OBOValue immediateParentInfo : child.values("is_a")) {
                String immediateParentId = immediateParentInfo.getValue().trim();
                if (!immediateParentId.equals(terminateParent.getId().trim())) continue;
                result.add(child.getId());
                result.addAll(this.getDescendantsOf(child));
            }
        }
        return result;
    }
}

