/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.oboparser.obo.OBOIndividual;
import org.oboparser.obo.OBOOntology;
import org.oboparser.obo.OBOStanza;
import org.oboparser.obo.OBOTerm;
import org.oboparser.obo.OBOTypedef;
import org.oboparser.obo.OBOValue;

public class OBOParser {
    private OBOOntology currentOntology = null;
    private OBOStanza currentStanza = null;
    private static Pattern stanzaStart = Pattern.compile("^\\s*\\[([^\\]]+)\\]\\s*$");

    public static void main(String[] args) {
        File f = new File(args[0]);
        OBOParser parser = new OBOParser();
        try {
            parser.parse(f);
            OBOOntology ontology = parser.getOntology();
            System.out.println(String.format("Ontology: \n%s", ontology.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OBOOntology getOntology() {
        return this.currentOntology;
    }

    public void parse(Reader r) throws IOException {
        this.parse(new BufferedReader(r));
    }

    public void parse(BufferedReader br) throws IOException {
        String line = null;
        this.currentOntology = new OBOOntology();
        this.currentStanza = this.currentOntology;
        do {
            line = br.readLine();
            this.handleLine(line);
        } while (line != null);
    }

    public void parse(File f) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        this.parse(br);
        br.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleLine(String line) {
        Matcher m = null;
        if (line != null) {
            line = line.trim();
            m = stanzaStart.matcher(line);
        }
        assert (this.currentOntology != null);
        if (line == null) {
            if (this.currentStanza == null || this.currentStanza == this.currentOntology) return;
            this.currentOntology.addOBOStanza(this.currentStanza);
            return;
        } else if (m.matches()) {
            String uline;
            if (this.currentStanza != null && this.currentStanza != this.currentOntology) {
                this.currentOntology.addOBOStanza(this.currentStanza);
            }
            if ((uline = m.group(1).toLowerCase()).equals("term")) {
                this.currentStanza = new OBOTerm();
                return;
            } else if (uline.equals("typedef")) {
                this.currentStanza = new OBOTypedef();
                return;
            } else {
                if (!uline.equals("individual")) throw new IllegalArgumentException(line);
                this.currentStanza = new OBOIndividual();
            }
            return;
        } else {
            if (line.length() <= 0 || line.trim().startsWith("!")) return;
            int idx = line.indexOf(":");
            String key = line.substring(0, idx).trim();
            String valueString = line.substring(idx + 1, line.length());
            OBOValue value = new OBOValue(valueString);
            this.currentStanza.addValue(key, value);
        }
    }
}

