/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.oboparser.obo.OBOException;
import org.oboparser.obo.OBOValue;

public class OBOStanza {
    private LinkedHashMap<String, LinkedList<OBOValue>> keyValues;
    private String type;
    private String id;

    public OBOStanza(String t) {
        this.type = t;
        this.keyValues = new LinkedHashMap();
        this.id = null;
    }

    public Object clone() {
        return this.clone(OBOStanza.class);
    }

    public Object clone(Class<? extends OBOStanza> cls) {
        try {
            Constructor<? extends OBOStanza> constructor = cls.getConstructor(new Class[0]);
            OBOStanza s = constructor.newInstance(new Object[0]);
            s.id = this.id;
            for (String key : this.keyValues.keySet()) {
                s.keyValues.put(key, new LinkedList(this.keyValues.get(key)));
            }
            return s;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(cls.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(cls.getCanonicalName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(cls.getCanonicalName(), e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(cls.getCanonicalName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(cls.getCanonicalName(), e);
        }
    }

    public String getType() {
        return this.type;
    }

    public Set<String> keys() {
        return this.keyValues.keySet();
    }

    public List<OBOValue> values(String key) {
        return this.keyValues.get(key);
    }

    public boolean hasValue(String key) {
        return this.keyValues.containsKey(key);
    }

    public void add(OBOStanza s) {
        if (this.id != null && s.getId() != null && !s.getId().equals(this.id)) {
            throw new IllegalArgumentException(String.format("%s != %s", this.id, s.getId()));
        }
        for (String key : s.keyValues.keySet()) {
            if (!this.keyValues.containsKey(key)) {
                this.keyValues.put(key, new LinkedList());
            }
            List myValues = this.keyValues.get(key);
            for (OBOValue theirValue : s.keyValues.get(key)) {
                if (myValues.contains(theirValue)) continue;
                myValues.add(theirValue);
            }
        }
    }

    protected void addValue(String k, OBOValue v) {
        if (k.equals("id")) {
            if (this.keyValues.containsKey(k)) {
                throw new OBOException(String.format("Duplicate ID %s for Stanza %s (%s)", v.getValue(), this.id, this.keyValues));
            }
            this.id = v.getValue();
        }
        if (!this.keyValues.containsKey(k)) {
            this.keyValues.put(k, new LinkedList());
        }
        this.keyValues.get(k).addLast(v);
    }

    public void print(PrintWriter w) {
        w.println(String.format("[%s]", this.type));
        for (String k : this.keyValues.keySet()) {
            for (OBOValue v : this.keyValues.get(k)) {
                w.println(String.format("%s : %s", k, v.toFullString()));
            }
        }
        w.println();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        LinkedList<OBOValue> nameList = this.keyValues.get("name");
        OBOValue name = nameList.get(0);
        return name.toFullString();
    }

    public String toString() {
        return this.id != null ? this.id : String.format("%s OBOStanza", this.type);
    }
}

