/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.oboparser.obo.OBOException;
import org.oboparser.obo.OBOStanza;
import org.oboparser.obo.OBOValue;

public class OBOTerm
extends OBOStanza {
    private static Pattern relationshipPattern = Pattern.compile("^\\s*([^\\s]+)\\s+([^\\s]+)\\s*($|(?:!\\s+(.*)\\s*$))?");
    private static Pattern isAPattern = Pattern.compile("^\\s*([^\\s]+)\\s*($|(?:!\\s+(.*)\\s*$))?");
    private String name = null;

    public OBOTerm() {
        super("Term");
    }

    @Override
    public Object clone() {
        return super.clone(OBOTerm.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isObsolete() {
        return this.hasValue("is_obsolete") && this.values("is_obsolete").get(0).getRawString().trim().equals("true");
    }

    @Override
    public void addValue(String k, OBOValue v) {
        super.addValue(k, v);
        if (k.equals("name")) {
            if (this.name != null) {
                throw new OBOException(String.format("Term %s given duplicate name %s", this.name, v.getValue()));
            }
            this.name = v.getValue();
        }
    }

    public String tag() {
        return String.format("%s ! %s", this.getId(), this.name);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String[] relationships() {
        ArrayList<String> rels = new ArrayList<String>();
        if (this.hasValue("relationship")) {
            for (OBOValue value : this.values("relationship")) {
                Matcher m = relationshipPattern.matcher(value.getValue());
                if (!m.matches()) continue;
                rels.add(m.group(1));
            }
        }
        return rels.toArray(new String[0]);
    }

    public String[] relationship(String typedef) {
        ArrayList<String> rels = new ArrayList<String>();
        if (this.hasValue("relationship")) {
            for (OBOValue value : this.values("relationship")) {
                Matcher m = relationshipPattern.matcher(value.getValue());
                if (!m.matches() || !m.group(1).equals(typedef)) continue;
                rels.add(m.group(2));
            }
        }
        return rels.toArray(new String[0]);
    }

    public String[] isa() {
        ArrayList<String> isa = new ArrayList<String>();
        if (this.hasValue("is_a")) {
            for (OBOValue value : this.values("is_a")) {
                Matcher m = isAPattern.matcher(value.getValue());
                if (!m.matches()) continue;
                isa.add(m.group(1));
            }
        }
        return isa.toArray(new String[0]);
    }

    public String[] intersectionOf() {
        ArrayList<String> inters = new ArrayList<String>();
        if (this.hasValue("intersection_of")) {
            for (OBOValue value : this.values("intersection_of")) {
                Matcher relMatcher = relationshipPattern.matcher(value.getValue());
                Matcher isaMatcher = isAPattern.matcher(value.getValue());
                if (relMatcher.matches() || !isaMatcher.matches()) continue;
                inters.add(isaMatcher.group(1));
            }
        }
        return inters.toArray(new String[0]);
    }
}

