/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo;

import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OBOValue {
    private static Pattern commentPattern = Pattern.compile("^\\s*((?:\"[^\"]+\")?[^!]*)\\s*(?:!(.*))?\\s*$");
    private static Pattern modifierPattern = Pattern.compile("^([^\\{]+)\\s*(?:\\{(.*)\\})?\\s*$");
    private String rawString;
    private String comment;
    private String value;
    private String[] modifiers;

    public static void main(String[] args) {
        System.out.println(new OBOValue("foo").toFullString());
        System.out.println(new OBOValue("foo !bar").toFullString());
        System.out.println(new OBOValue("foo ! bar").toFullString());
        System.out.println(new OBOValue("foo {a=b}").toFullString());
        System.out.println(new OBOValue("foo { a=b, c=d}").toFullString());
        System.out.println(new OBOValue("foo { a=b, c=d} ! bar").toFullString());
        System.out.println(new OBOValue("\"foo\" { a=b, c=d} ! bar").toFullString());
        System.out.println(new OBOValue("\"foo { a=b, c=d}\" ! bar").toFullString());
    }

    public OBOValue(String raw) {
        Matcher mm;
        this.rawString = raw;
        Matcher m = commentPattern.matcher(raw);
        if (!m.matches()) {
            throw new IllegalArgumentException("\"" + raw + "\"");
        }
        this.value = m.group(1);
        if (m.groupCount() > 1 && m.group(2) != null) {
            this.comment = m.group(2);
        }
        if ((mm = modifierPattern.matcher(this.value)).matches() && mm.groupCount() > 1 && mm.group(2) != null) {
            this.value = mm.group(1);
            this.modifiers = OBOValue.parseModifiers(mm.group(2));
        } else {
            this.modifiers = new String[0];
        }
    }

    public OBOValue(String v, String c, String ... mds) {
        this.value = v;
        this.comment = c;
        this.modifiers = (String[])mds.clone();
        this.rawString = this.toFullString();
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(String.format("%s", this.value));
        sb.append(" {");
        int midx = 0;
        for (String m : this.modifiers) {
            if (midx > 0) {
                sb.append(",");
            }
            sb.append(String.format("%s", m));
            ++midx;
        }
        sb.append("}");
        sb.append(String.format(" ! %s", this.comment));
        return sb.toString();
    }

    public String getRawString() {
        return this.rawString;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String[] getModifiers() {
        return this.modifiers;
    }

    public int hashCode() {
        return this.rawString.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OBOValue)) {
            return false;
        }
        OBOValue v = (OBOValue)o;
        return v.rawString.equals(this.rawString);
    }

    public String toString() {
        return this.rawString;
    }

    private static String[] parseModifiers(String mod) {
        assert (mod != null);
        TreeSet<Integer> commaPoints = new TreeSet<Integer>();
        commaPoints.add(-1);
        for (int s = 0; s < mod.length() && (s = mod.indexOf(",", s)) != -1; ++s) {
            if (s <= 0 || mod.charAt(s - 1) == '\\') continue;
            commaPoints.add(s);
        }
        commaPoints.add(mod.length());
        Integer[] cpts = commaPoints.toArray(new Integer[0]);
        String[] modarray = new String[cpts.length - 1];
        for (int i = 0; i < cpts.length - 1; ++i) {
            modarray[i] = mod.substring(cpts[i] + 1, cpts[i + 1]);
        }
        return modarray;
    }
}

