/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo.annotations.parsers;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaWriter {
    private static String tabString = "\t";
    public static final Integer CLASS = 0;
    public static final Integer INTERFACE = 1;
    public static final Integer METHOD = 2;
    private Set<Class> usedClasses;
    private PrintWriter writer;
    private LinkedList<Integer> blockTypes;

    public JavaWriter(PrintWriter w) {
        this.writer = w;
        this.blockTypes = new LinkedList();
        this.usedClasses = new TreeSet<Class>(new ClassNameComparator());
    }

    private String annotationValueString(Object value) {
        if (value instanceof Class) {
            Class cls = (Class)value;
            this.useClasses(cls);
            return String.format("%s.class", cls.getSimpleName());
        }
        if (value instanceof String) {
            String str = (String)value;
            Pattern p = Pattern.compile("(?:^|[^\\\\])(\")");
            Matcher m = p.matcher(str);
            while (m.matches()) {
                int start = m.start(1);
                int end = m.end(1);
                str = str.substring(0, start) + "\\\"" + str.substring(end, str.length());
                m = p.matcher(str);
            }
            str = str.replaceAll("\\\\:", ":");
            return String.format("\"%s\"", str);
        }
        return String.valueOf(value);
    }

    public String renderAnnotation(Object ann) {
        if (ann instanceof Class) {
            Class annClass = (Class)ann;
            this.useClasses(annClass);
            return String.format("@" + annClass.getSimpleName(), new Object[0]);
        }
        if (ann instanceof Annotation) {
            Annotation annotation = (Annotation)ann;
            Class<? extends Annotation> annClass = annotation.annotationType();
            this.useClasses(annClass);
            StringBuilder sb = new StringBuilder();
            String base = String.format("@" + annClass.getSimpleName(), new Object[0]);
            String defaultValue = null;
            for (Method m : annClass.getDeclaredMethods()) {
                Class<?> type = m.getReturnType();
                String mName = m.getName();
                int mod = m.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isAbstract(mod) && m.getParameterTypes().length == 0) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    try {
                        String value = this.annotationValueString(m.invoke(ann, new Object[0]));
                        if (mName.equals("value")) {
                            defaultValue = value;
                        } else {
                            sb.append(String.format("%s=%s", mName, value));
                        }
                        this.useClasses(type);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException(String.valueOf(ann));
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(String.valueOf(ann));
                    }
                }
                System.err.println(String.format("Method %s has modifiers %d and param length %d", mName, mod, m.getParameterTypes().length));
            }
            if (defaultValue != null) {
                if (sb.length() == 0) {
                    sb.append(defaultValue);
                } else {
                    sb.append(String.format(", value=%s", defaultValue));
                }
            }
            if (sb.length() > 0) {
                return String.format("%s(%s)", base, sb.toString());
            }
            return base;
        }
        throw new IllegalArgumentException(String.format("Unsupported annotation class: %s", ann.getClass().getCanonicalName()));
    }

    public void useClasses(Class ... cs) {
        if (cs != null) {
            for (Class c : cs) {
                if (c == null || c.getCanonicalName().equals(String.format("java.lang.%s", c.getSimpleName()))) continue;
                this.usedClasses.add(c);
            }
        }
    }

    public String getImports() {
        StringBuilder sb = new StringBuilder();
        for (Class c : this.usedClasses) {
            sb.append(String.format("import %s;\n", c.getCanonicalName()));
        }
        return sb.toString();
    }

    private boolean printIfPublic(int mod) {
        boolean present = Modifier.isPublic(mod);
        if (present) {
            this.writer.print("public ");
        }
        return present;
    }

    private boolean printIfPrivate(int mod) {
        boolean present = Modifier.isPrivate(mod);
        if (present) {
            this.writer.print("private ");
        }
        return present;
    }

    private boolean printIfProtected(int mod) {
        boolean present = Modifier.isProtected(mod);
        if (present) {
            this.writer.print("protected ");
        }
        return present;
    }

    private boolean printIfAccess(int mod) {
        return this.printIfPublic(mod) || this.printIfPrivate(mod) || this.printIfProtected(mod);
    }

    public String indent() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            sb.append(tabString);
        }
        return sb.toString();
    }

    private boolean printIfStatic(int mod) {
        boolean present = Modifier.isStatic(mod);
        if (present) {
            this.writer.print("static ");
        }
        return present;
    }

    private void doIndent() {
        this.writer.print(this.indent());
    }

    public void beginInterface(int modifiers, String interfaceName, Class[] interfaces, Object ... annotations) {
        this.writer.println();
        if (annotations != null && annotations.length > 0) {
            for (Object annotation : annotations) {
                this.writer.println(String.format("%s%s", this.indent(), this.renderAnnotation(annotation)));
            }
        }
        this.doIndent();
        this.printIfAccess(modifiers);
        this.printIfStatic(modifiers);
        this.writer.print("interface " + interfaceName + " ");
        if (interfaces != null && interfaces.length != 0) {
            this.writer.print("extends ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(interfaces[i].getSimpleName());
            }
            this.writer.print(" ");
        }
        this.writer.println("{");
        this.blockTypes.addFirst(INTERFACE);
        this.useClasses(interfaces);
    }

    public void endInterface() {
        this.endWithType(INTERFACE);
    }

    public void beginClass(int modifiers, String className, Class superClass, Class[] interfaces, Object ... annotations) {
        this.writer.println();
        if (annotations != null && annotations.length > 0) {
            for (Object annotation : annotations) {
                this.writer.println(String.format("%s%s", this.indent(), this.renderAnnotation(annotation)));
            }
        }
        this.doIndent();
        this.printIfAccess(modifiers);
        this.printIfStatic(modifiers);
        this.writer.print("class " + className + " ");
        if (superClass != null) {
            this.writer.print(" extends " + superClass.getSimpleName() + " ");
        }
        if (interfaces != null && interfaces.length != 0) {
            this.writer.print("implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(interfaces[i].getSimpleName());
            }
            this.writer.print(" ");
        }
        this.writer.println("{");
        this.blockTypes.addFirst(CLASS);
        this.useClasses(superClass);
        this.useClasses(interfaces);
    }

    public void endClass() {
        this.endWithType(CLASS);
    }

    private static boolean isSubclass(Class c1, Class c2) {
        return c2.isAssignableFrom(c1);
    }

    public void field(int modifiers, Class type, String name, String init, Class ... annotations) {
        if (annotations != null && annotations.length > 0) {
            this.writer.println();
            for (Class annotation : annotations) {
                this.writer.println(String.format("%s@%s", this.indent(), annotation.getSimpleName()));
            }
            this.useClasses(annotations);
        }
        this.doIndent();
        this.printIfAccess(modifiers);
        this.printIfStatic(modifiers);
        this.writer.print(type.getSimpleName() + " ");
        this.writer.print(name);
        if (init != null) {
            if (JavaWriter.isSubclass(type, String.class)) {
                this.writer.print(String.format(" = \"%s\";", init.replace("\"", "\\\"")));
            } else {
                this.writer.print(String.format(" = %s;", init));
            }
        }
        this.writer.println();
        this.useClasses(type);
    }

    private void printMethodLine(int modifiers, Class returnType, String methodName, Class[] argTypes, String[] argNames, Class[] throwsList, Object ... annotations) {
        this.writer.println();
        for (Object annotation : annotations) {
            this.writer.println(String.format("%s%s", this.indent(), this.renderAnnotation(annotation)));
        }
        this.doIndent();
        this.printIfAccess(modifiers);
        this.printIfStatic(modifiers);
        this.writer.print(returnType.getSimpleName() + " " + methodName);
        this.writer.print("(");
        if (argTypes != null && argTypes.length > 0) {
            if (argNames == null || argNames.length != argTypes.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < argNames.length; ++i) {
                if (i > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(String.format("%s %s", argTypes[i].getSimpleName(), argNames[i]));
            }
        }
        this.writer.print(")");
        if (throwsList != null && throwsList.length > 0) {
            this.writer.print(" throws ");
            for (int i = 0; i < throwsList.length; ++i) {
                if (i > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(throwsList[i].getSimpleName());
            }
        }
        this.useClasses(returnType);
        this.useClasses(argTypes);
        this.useClasses(throwsList);
    }

    public void methodDeclaration(int modifiers, Class returnType, String methodName, Class[] argTypes, String[] argNames, Class[] throwsList, Object ... annotations) {
        this.printMethodLine(modifiers, returnType, methodName, argTypes, argNames, throwsList, annotations);
        this.writer.println(";");
    }

    public void beginMethod(int modifiers, Class returnType, String methodName, Class[] argTypes, String[] argNames, Class[] throwsList, Object ... annotations) {
        this.printMethodLine(modifiers, returnType, methodName, argTypes, argNames, throwsList, annotations);
        this.writer.println(" {");
        this.blockTypes.addFirst(METHOD);
    }

    private void endWithType(Integer type) {
        if (this.blockTypes.isEmpty() || !this.blockTypes.removeFirst().equals(type)) {
            throw new IllegalStateException();
        }
        this.doIndent();
        this.writer.println("}");
    }

    public void endMethod() {
        this.endWithType(METHOD);
    }

    private static class ClassNameComparator
    implements Comparator<Class> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class c1, Class c2) {
            return c1.getCanonicalName().compareTo(c2.getCanonicalName());
        }
    }
}

