/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo.annotations.parsers;

import java.lang.reflect.Method;
import org.oboparser.obo.annotations.parsers.OBOTermValueException;
import org.oboparser.obo.annotations.parsers.OntologyAnnotationParser;

public class OBOAnnotationParser
extends OntologyAnnotationParser {
    public String name(Class value) {
        try {
            return this.getClassValue(value, this.getTermField(value, "name"), String.class);
        }
        catch (OBOTermValueException e) {
            return OBOAnnotationParser.unCamelCase(value.getSimpleName());
        }
    }

    public String def(Class value) {
        return this.getClassValue(value, this.getTermField(value, "def"), String.class);
    }

    public String id(Class value) {
        return this.getClassValue(value, this.getTermField(value, "id"), String.class);
    }

    public String[] comments(Class value) {
        return this.getClassValueSet(value, this.getTermField(value, "comment"), String.class);
    }

    public String oboTag(Class cls) {
        return String.format("%s ! %s", this.id(cls), this.name(cls));
    }

    public String stanza(Class cls) {
        if (!this.isTerm(cls)) {
            throw new IllegalArgumentException(cls.getCanonicalName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[Term]\n");
        sb.append(String.format("id: %s\n", this.id(cls)));
        sb.append(String.format("name: %s\n", this.name(cls)));
        sb.append(String.format("def: \"%s\"\n", this.def(cls)));
        for (String comment : this.comments(cls)) {
            sb.append(String.format("comment: \"%s\"\n", comment));
        }
        for (Class superClass : this.findImmediateSuperClasses(cls)) {
            sb.append(String.format("is_a: %s\n", this.oboTag(superClass)));
        }
        for (Method m : this.findImmediateRelations(cls)) {
            sb.append(String.format("relationship: %s %s\n", this.relationProperty(m), this.oboTag(this.relationType(m))));
        }
        return sb.toString();
    }
}

