/*
 * Decompiled with CFR 0.152.
 */
package org.oboparser.obo.annotations.parsers;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.oboparser.obo.OBOOntology;
import org.oboparser.obo.OBOTerm;
import org.oboparser.obo.OBOValue;
import org.oboparser.obo.annotations.parsers.OBOAnnotationParser;
import org.oboparser.obo.annotations.parsers.OntologyAnnotationParser;

public class OBOTermCreator {
    private Map<String, Class> created = new TreeMap<String, Class>();
    private static Charset utf8 = Charset.forName("UTF-8");

    public Class<?> createTerm(OBOOntology ontology, OBOTerm termStanza) throws CannotCompileException {
        String id = termStanza.getId();
        if (this.created.containsKey(id)) {
            return this.created.get(id);
        }
        String name = termStanza.getName();
        String def = termStanza.hasValue("def") ? termStanza.values("def").get(0).getValue() : "";
        List<OBOValue> isaValues = termStanza.values("is_a");
        Class[] is_a = new Class[isaValues != null ? isaValues.size() : 0];
        for (int i = 0; i < is_a.length; ++i) {
            OBOValue value = isaValues.get(i);
            String valueStr = value.getValue();
            String isaID = valueStr.split("!")[0].trim();
            OBOTerm isaTerm = (OBOTerm)ontology.getStanza(isaID);
            is_a[i] = this.createTerm(ontology, isaTerm);
        }
        Pattern relPattern = Pattern.compile("^\\s*([^\\s]+)\\s+(.*)(?:\\s*!\\s*.*)?$");
        List<OBOValue> relValues = termStanza.values("relationship");
        ArrayList relTypes = new ArrayList();
        ArrayList<String> relTypedefs = new ArrayList<String>();
        for (int i = 0; relValues != null && i < relValues.size(); ++i) {
            OBOValue relValue = relValues.get(i);
            Matcher relMatcher = relPattern.matcher(relValue.getValue());
            if (relMatcher.matches()) {
                String relID = relMatcher.group(2).trim();
                OBOTerm relTerm = (OBOTerm)ontology.getStanza(relID);
                if (relTerm == null) {
                    throw new IllegalArgumentException(relID + " in " + id);
                }
                relTypes.add(this.createTerm(ontology, relTerm));
                relTypedefs.add(relMatcher.group(1));
                continue;
            }
            System.err.println(relValue.getValue() + " isn't a relationship");
        }
        Class cc = this.createTerm(id, name, def, null, is_a, relTypes.toArray(new Class[0]), relTypedefs.toArray(new String[0]));
        return cc;
    }

    public static String unmangleName(String ccClassName) {
        String original = new String(ccClassName.getBytes(utf8), utf8);
        ccClassName = ccClassName.replaceAll("/", " ");
        ccClassName = ccClassName.replaceAll("-", " ");
        ccClassName = ccClassName.replaceAll("\\(", " ");
        ccClassName = ccClassName.replaceAll("\\)", " ");
        ccClassName = ccClassName.replaceAll(",", " ");
        ccClassName = ccClassName.replaceAll("\\[", " ");
        ccClassName = ccClassName.replaceAll("\\]", " ");
        ccClassName = ccClassName.replaceAll("\\.", " ");
        ccClassName = ccClassName.replaceAll("'\\s", " prime ");
        ccClassName = ccClassName.replaceAll("'", "");
        ccClassName = ccClassName.replaceAll("\"", "");
        if ((ccClassName = OntologyAnnotationParser.camelCase(ccClassName, " ")).indexOf("(") != -1) {
            throw new IllegalArgumentException(ccClassName);
        }
        return ccClassName;
    }

    public static boolean isSubclass(Class c1, Class c2) {
        return c2.isAssignableFrom(c1);
    }

    public boolean isConflicting(Class returnType, String methodName, Method extant) {
        return methodName.equals(extant.getName()) && !OBOTermCreator.isSubclass(returnType, extant.getReturnType());
    }

    public Method findConflictingMethod(Class returnType, String methodName, Class cls) {
        for (Method m : cls.getMethods()) {
            if (!this.isConflicting(returnType, methodName, m)) continue;
            return m;
        }
        return null;
    }

    public String acronym(String camelCased) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < camelCased.length(); ++i) {
            char c = camelCased.charAt(i);
            if (!Character.isUpperCase(c) && (sb.length() <= 0 || !Character.isDigit(c))) continue;
            sb.append(c);
        }
        if (sb.length() == 0) {
            for (i = 0; i < camelCased.length() && Character.isDigit(camelCased.charAt(i)); ++i) {
            }
            if (i < camelCased.length()) {
                sb.append(Character.toUpperCase(camelCased.charAt(i)));
            }
        }
        return sb.toString();
    }

    public Method findAnyConflictingMethod(Class returnType, String methodName, Class superClass, Class[] interfaces) {
        Method conflict = superClass != null ? this.findConflictingMethod(returnType, methodName, superClass) : null;
        for (int i = 0; conflict == null && interfaces != null && i < interfaces.length; ++i) {
            conflict = this.findConflictingMethod(returnType, methodName, interfaces[i]);
        }
        return conflict;
    }

    private int countDuplicates(String[] array, int i) {
        int c = 0;
        for (int j = 0; j < i; ++j) {
            if (!array[j].equals(array[i])) continue;
            ++c;
        }
        return c;
    }

    private String[] renameDuplicates(String[] str) {
        int i;
        Integer[] append = new Integer[str.length];
        String[] unduped = new String[str.length];
        for (i = 0; i < str.length; ++i) {
            append[i] = this.countDuplicates(str, i);
        }
        for (i = 0; i < str.length; ++i) {
            unduped[i] = append[i] > 0 ? String.format("%s_%d", str[i], append[i]) : str[i];
        }
        return unduped;
    }

    private String findNonConflictingName(String className, Class returnType, String methodName, Class superClass, Class[] interfaces) {
        String acronym = this.acronym(returnType.getSimpleName());
        Method conflict = this.findAnyConflictingMethod(returnType, methodName = String.format("%s_%s", className, methodName), superClass, interfaces);
        if (conflict != null) {
            methodName = String.format("%s_%s", methodName, acronym);
            conflict = this.findAnyConflictingMethod(returnType, methodName, superClass, interfaces);
        }
        String countedName = methodName;
        int i = 2;
        while (conflict != null) {
            countedName = String.format("%s_%d", methodName, i++);
            conflict = this.findAnyConflictingMethod(returnType, countedName, superClass, interfaces);
        }
        return countedName;
    }

    private Class<? extends Object> getArrayType(Class type) {
        return Array.newInstance(type, 0).getClass();
    }

    private String removeSlashes(String str) {
        return str.replaceAll("\\\\", "\\\\\\\\");
    }

    public Class createTerm(String id, String name, String def, String[] comments, Class[] is_a, Class[] relTypes, String[] relTypedefs) throws CannotCompileException {
        String ccClassName = OBOTermCreator.unmangleName(name);
        if (this.created.containsKey(id)) {
            return this.created.get(id);
        }
        if (this.created.containsKey(ccClassName)) {
            return this.created.get(ccClassName);
        }
        OBOAnnotationParser obo = new OBOAnnotationParser();
        ClassPool cp = ClassPool.getDefault();
        CtClass stringClass = null;
        CtClass stringArrayClass = null;
        try {
            stringClass = cp.get("java.lang.String");
            stringArrayClass = cp.get("java.lang.String[]");
        }
        catch (NotFoundException e) {
            throw new IllegalStateException(e);
        }
        CtClass cc = cp.makeInterface(ccClassName);
        cc.setModifiers(513);
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        Annotation termAnnotation = new Annotation("org.sc.obo.annotations.Term", constpool);
        CtField idField = new CtField(stringClass, "id", cc);
        idField.setModifiers(25);
        CtField nameField = new CtField(stringClass, "name", cc);
        nameField.setModifiers(25);
        CtField defField = new CtField(stringClass, "def", cc);
        defField.setModifiers(25);
        cc.addField(idField, CtField.Initializer.constant((String)this.removeSlashes(id)));
        cc.addField(nameField, CtField.Initializer.constant((String)this.removeSlashes(name)));
        cc.addField(defField, CtField.Initializer.constant((String)this.removeSlashes(def)));
        if (is_a != null) {
            for (Class superClass : is_a) {
                if (!obo.isTerm(superClass)) {
                    throw new IllegalArgumentException(superClass.getCanonicalName());
                }
                try {
                    CtClass superCtClass = cp.get(superClass.getCanonicalName());
                    cc.addInterface(superCtClass);
                }
                catch (NotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if (relTypes != null && relTypedefs != null) {
            if (relTypes.length != relTypedefs.length) {
                throw new IllegalArgumentException();
            }
            String[] nonDups = this.renameDuplicates(relTypedefs);
            for (int i = 0; i < relTypes.length; ++i) {
                try {
                    if (relTypes[i] == null) {
                        throw new IllegalArgumentException(id + " " + Arrays.asList(relTypes));
                    }
                    Class<? extends Object> arrayType = relTypes[i].isArray() ? relTypes[i] : this.getArrayType(relTypes[i]);
                    String typeName = arrayType.getCanonicalName();
                    String methodName = this.findNonConflictingName(ccClassName, arrayType, nonDups[i], null, is_a);
                    CtClass relTypeClass = cp.get(typeName);
                    CtMethod relMethod = new CtMethod(relTypeClass, methodName, new CtClass[0], cc);
                    relMethod.setModifiers(1025);
                    Annotation relAnnotation = new Annotation("org.sc.obo.annotations.Relates", constpool);
                    relAnnotation.addMemberValue("value", (MemberValue)new StringMemberValue(relTypedefs[i], ccFile.getConstPool()));
                    AnnotationsAttribute annotations = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
                    annotations.addAnnotation(relAnnotation);
                    relMethod.getMethodInfo().addAttribute((AttributeInfo)annotations);
                    cc.addMethod(relMethod);
                    continue;
                }
                catch (NotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        attr.addAnnotation(termAnnotation);
        ccFile.addAttribute((AttributeInfo)attr);
        Class c = cc.toClass();
        this.created.put(id, c);
        this.created.put(ccClassName, c);
        return c;
    }
}

