/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum AccessType {
    PUBLIC("public"),
    PRIVATE("private");

    private final String accessType;
    private static final URI publicURI;
    private static final URI privateURI;

    private AccessType(String accessType) {
        this.accessType = accessType;
    }

    static AccessType convertToAccessType(URI access) throws SBOLValidationException {
        if (access != null) {
            if (access.equals(publicURI)) {
                return PUBLIC;
            }
            if (access.equals(privateURI)) {
                return PRIVATE;
            }
            throw new SBOLValidationException("sbol-10607", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-10607", new Identified[0]);
    }

    static URI convertToURI(AccessType access) {
        if (access != null) {
            if (access.equals((Object)PUBLIC)) {
                return publicURI;
            }
            if (access.equals((Object)PRIVATE)) {
                return privateURI;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.accessType;
    }

    static {
        publicURI = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "public");
        privateURI = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "private");
    }
}

