/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Sbol1Terms;
import org.sbolstandard.core2.Sbol2Terms;
import uk.ac.ncl.intbio.core.datatree.Datatree;
import uk.ac.ncl.intbio.core.datatree.Literal;
import uk.ac.ncl.intbio.core.datatree.NamedProperty;
import uk.ac.ncl.intbio.core.datatree.NestedDocument;

public class Annotation {
    private String namespaceURI = null;
    private String localPart = null;
    private String prefix = null;
    private String type = null;
    private Boolean boolValue = null;
    private Double doubleValue = null;
    private Integer intValue = null;
    private String stringValue = null;
    private URI URIValue = null;
    private String nestedNamespaceURI = null;
    private String nestedLocalPart = null;
    private String nestedPrefix = null;
    private URI nestedURI = null;
    private List<Annotation> nestedAnnotations = null;

    public Annotation(QName qName, String literal) {
        this.setQName(qName);
        this.setStringValue(literal);
    }

    public Annotation(QName qName, int literal) {
        this.setQName(qName);
        this.setIntegerValue(literal);
    }

    public Annotation(QName qName, double literal) {
        this.setQName(qName);
        this.setDoubleValue(literal);
    }

    public Annotation(QName qName, boolean literal) {
        this.setQName(qName);
        this.setBooleanValue(literal);
    }

    public Annotation(QName qName, URI literal) {
        this.setQName(qName);
        this.setURIValue(literal);
    }

    public Annotation(QName qName, QName nestedQName, URI nestedURI, List<Annotation> annotations) {
        this.setQName(qName);
        this.setNestedQName(nestedQName);
        this.setNestedIdentity(nestedURI);
        this.setAnnotations(annotations);
    }

    Annotation(NamedProperty<QName> value) {
        if ((((QName)value.getName()).getNamespaceURI().equals(Sbol2Terms.sbol2.getNamespaceURI()) || ((QName)value.getName()).getNamespaceURI().equals(Sbol1Terms.sbol1.getNamespaceURI())) && ((QName)value.getName()).equals(Sbol2Terms.Identified.timeStamp)) {
            System.out.println("Warning: sbol:timeStamp is deprecated");
        }
        this.setQName((QName)value.getName());
        if (value.getValue() instanceof Literal.BooleanLiteral) {
            this.setBooleanValue(((Literal.BooleanLiteral)value.getValue()).getValue());
        } else if (value.getValue() instanceof Literal.DoubleLiteral) {
            this.setDoubleValue(((Literal.DoubleLiteral)value.getValue()).getValue());
        } else if (value.getValue() instanceof Literal.IntegerLiteral) {
            this.setIntegerValue(((Literal.IntegerLiteral)value.getValue()).getValue());
        } else if (value.getValue() instanceof Literal.StringLiteral) {
            this.setStringValue(((Literal.StringLiteral)value.getValue()).getValue());
        } else if (value.getValue() instanceof Literal.UriLiteral) {
            this.setURIValue(((Literal.UriLiteral)value.getValue()).getValue());
        } else if (value.getValue() instanceof NestedDocument) {
            this.setNestedQName((QName)((NestedDocument)value.getValue()).getType());
            this.setNestedIdentity(((NestedDocument)value.getValue()).getIdentity());
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            for (NamedProperty namedProperty : ((NestedDocument)value.getValue()).getProperties()) {
                annotations.add(new Annotation((NamedProperty<QName>)namedProperty));
            }
            this.setAnnotations(annotations);
        }
    }

    private Annotation(Annotation annotation) {
        this.setQName(annotation.getQName());
        if (annotation.isBooleanValue()) {
            this.setBooleanValue(annotation.getBooleanValue());
        } else if (annotation.isDoubleValue()) {
            this.setDoubleValue(annotation.getDoubleValue());
        } else if (annotation.isIntegerValue()) {
            this.setIntegerValue(annotation.getIntegerValue());
        } else if (annotation.isStringValue()) {
            this.setStringValue(annotation.getStringValue());
        } else if (annotation.isURIValue()) {
            this.setURIValue(annotation.getURIValue());
        } else if (annotation.isNestedAnnotations()) {
            this.setNestedQName(annotation.getNestedQName());
            this.setNestedIdentity(annotation.getNestedIdentity());
            this.setAnnotations(annotation.getAnnotations());
        }
    }

    public QName getQName() {
        return new QName(this.namespaceURI, this.localPart, this.prefix);
    }

    public void setQName(QName qName) {
        this.namespaceURI = qName.getNamespaceURI();
        this.localPart = qName.getLocalPart();
        this.prefix = qName.getPrefix();
    }

    public void setBooleanValue(boolean literal) {
        this.type = "Boolean";
        this.boolValue = literal;
    }

    public boolean isBooleanValue() {
        return this.type.equals("Boolean");
    }

    public Boolean getBooleanValue() {
        if (this.isBooleanValue()) {
            return this.boolValue;
        }
        return null;
    }

    public void setDoubleValue(double literal) {
        this.type = "Double";
        this.doubleValue = literal;
    }

    public boolean isDoubleValue() {
        return this.type.equals("Double");
    }

    public Double getDoubleValue() {
        if (this.isDoubleValue()) {
            return this.doubleValue;
        }
        return null;
    }

    public void setIntegerValue(int literal) {
        this.type = "Integer";
        this.intValue = literal;
    }

    public boolean isIntegerValue() {
        return this.type.equals("Integer");
    }

    public Integer getIntegerValue() {
        if (this.isIntegerValue()) {
            return this.intValue;
        }
        return null;
    }

    public void setStringValue(String literal) {
        this.type = "String";
        this.stringValue = literal;
    }

    public boolean isStringValue() {
        return this.type.equals("String");
    }

    public String getStringValue() {
        if (this.isStringValue()) {
            return this.stringValue;
        }
        return null;
    }

    public void setURIValue(URI literal) {
        this.type = "URI";
        this.URIValue = literal;
    }

    public boolean isURIValue() {
        return this.type.equals("URI");
    }

    public URI getURIValue() {
        if (this.isURIValue()) {
            return this.URIValue;
        }
        return null;
    }

    public void setNestedQName(QName qName) {
        this.nestedNamespaceURI = qName.getNamespaceURI();
        this.nestedLocalPart = qName.getLocalPart();
        this.nestedPrefix = qName.getPrefix();
    }

    public QName getNestedQName() {
        if (this.isNestedAnnotations()) {
            return new QName(this.nestedNamespaceURI, this.nestedLocalPart, this.nestedPrefix);
        }
        return null;
    }

    public URI getNestedIdentity() {
        if (this.isNestedAnnotations()) {
            return this.nestedURI;
        }
        return null;
    }

    public void setNestedIdentity(URI uri) {
        this.nestedURI = uri;
    }

    public boolean isNestedAnnotations() {
        return this.type.equals("NestedAnnotation");
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.type = "NestedAnnotation";
        this.nestedAnnotations = new ArrayList<Annotation>();
        for (Annotation a : annotations) {
            this.nestedAnnotations.add(a);
        }
    }

    public List<Annotation> getAnnotations() {
        if (this.isNestedAnnotations()) {
            return this.nestedAnnotations;
        }
        return null;
    }

    NamedProperty<QName> getValue() {
        if (this.isBooleanValue()) {
            return Datatree.NamedProperty((Object)this.getQName(), (Boolean)this.getBooleanValue());
        }
        if (this.isDoubleValue()) {
            return Datatree.NamedProperty((Object)this.getQName(), (Double)this.getDoubleValue());
        }
        if (this.isIntegerValue()) {
            return Datatree.NamedProperty((Object)this.getQName(), (int)this.getIntegerValue());
        }
        if (this.isStringValue()) {
            return Datatree.NamedProperty((Object)this.getQName(), (String)this.getStringValue());
        }
        if (this.isURIValue()) {
            return Datatree.NamedProperty((Object)this.getQName(), (URI)this.getURIValue());
        }
        if (this.isNestedAnnotations()) {
            ArrayList<NamedProperty<QName>> list = new ArrayList<NamedProperty<QName>>();
            for (Annotation a : this.getAnnotations()) {
                list.add(a.getValue());
            }
            return Datatree.NamedProperty((Object)this.getQName(), (NestedDocument)Datatree.NestedDocument((Object)this.getNestedQName(), (URI)this.getNestedIdentity(), (Datatree.NamedProperties)Datatree.NamedProperties(list)));
        }
        return null;
    }

    private Annotation deepCopy() {
        return new Annotation(this);
    }

    Annotation copy() {
        return this.deepCopy();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.URIValue == null ? 0 : this.URIValue.hashCode());
        result = 31 * result + (this.boolValue == null ? 0 : this.boolValue.hashCode());
        result = 31 * result + (this.doubleValue == null ? 0 : this.doubleValue.hashCode());
        result = 31 * result + (this.intValue == null ? 0 : this.intValue.hashCode());
        result = 31 * result + (this.localPart == null ? 0 : this.localPart.hashCode());
        result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
        result = 31 * result + (this.nestedAnnotations == null ? 0 : this.nestedAnnotations.hashCode());
        result = 31 * result + (this.nestedLocalPart == null ? 0 : this.nestedLocalPart.hashCode());
        result = 31 * result + (this.nestedNamespaceURI == null ? 0 : this.nestedNamespaceURI.hashCode());
        result = 31 * result + (this.nestedPrefix == null ? 0 : this.nestedPrefix.hashCode());
        result = 31 * result + (this.nestedURI == null ? 0 : this.nestedURI.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (this.URIValue == null ? other.URIValue != null : !this.URIValue.equals(other.URIValue)) {
            return false;
        }
        if (this.boolValue == null ? other.boolValue != null : !this.boolValue.equals(other.boolValue)) {
            return false;
        }
        if (this.doubleValue == null ? other.doubleValue != null : !this.doubleValue.equals(other.doubleValue)) {
            return false;
        }
        if (this.intValue == null ? other.intValue != null : !this.intValue.equals(other.intValue)) {
            return false;
        }
        if (this.localPart == null ? other.localPart != null : !this.localPart.equals(other.localPart)) {
            return false;
        }
        if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
            return false;
        }
        if (this.nestedAnnotations == null ? other.nestedAnnotations != null : !this.nestedAnnotations.equals(other.nestedAnnotations)) {
            return false;
        }
        if (this.nestedLocalPart == null ? other.nestedLocalPart != null : !this.nestedLocalPart.equals(other.nestedLocalPart)) {
            return false;
        }
        if (this.nestedNamespaceURI == null ? other.nestedNamespaceURI != null : !this.nestedNamespaceURI.equals(other.nestedNamespaceURI)) {
            return false;
        }
        if (this.nestedPrefix == null ? other.nestedPrefix != null : !this.nestedPrefix.equals(other.nestedPrefix)) {
            return false;
        }
        if (this.nestedURI == null ? other.nestedURI != null : !this.nestedURI.equals(other.nestedURI)) {
            return false;
        }
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Annotation [(" + this.prefix + ":" + this.namespaceURI + ":" + this.localPart + "), type=" + this.type + ", value=" + (this.isBooleanValue() ? this.boolValue : "") + (this.isDoubleValue() ? this.doubleValue : "") + (this.isIntegerValue() ? this.intValue : "") + (this.isStringValue() ? this.stringValue : "") + (this.isURIValue() ? this.URIValue : "") + (this.isNestedAnnotations() ? "(" + this.nestedPrefix + ":" + this.nestedNamespaceURI + ":" + this.nestedLocalPart + ":" + this.nestedURI + ")" + this.nestedAnnotations.toString() : "") + "]";
    }
}

