/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class Collection
extends TopLevel {
    private Set<URI> members = new HashSet<URI>();

    Collection(URI identity) throws SBOLValidationException {
        super(identity);
    }

    private Collection(Collection collection) throws SBOLValidationException {
        super(collection);
        for (URI member : collection.getMemberURIs()) {
            this.addMember(member);
        }
    }

    void copy(Collection collection) throws SBOLValidationException {
        this.copy((TopLevel)collection);
        for (URI member : collection.getMemberURIs()) {
            this.addMember(member);
        }
    }

    public boolean addMember(URI memberURI) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getTopLevel(memberURI) == null) {
            throw new SBOLValidationException("sbol-12103", this);
        }
        return this.members.add(memberURI);
    }

    public boolean removeMember(URI memberURI) {
        return this.members.remove(memberURI);
    }

    public void setMembers(Set<URI> members) throws SBOLValidationException {
        this.clearMembers();
        for (URI member : members) {
            this.addMember(member);
        }
    }

    public Set<URI> getMemberURIs() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.members);
        return result;
    }

    public Set<TopLevel> getMembers() {
        HashSet<TopLevel> result = new HashSet<TopLevel>();
        for (URI memberURI : this.members) {
            TopLevel member = this.getDocument().getTopLevel(memberURI);
            result.add(member);
        }
        return result;
    }

    public boolean containsMember(URI memberURI) {
        return this.members.contains(memberURI);
    }

    public void clearMembers() {
        this.members.clear();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Collection other = (Collection)obj;
        return !(this.members == null ? other.members != null : !this.members.equals(other.members));
    }

    @Override
    Collection deepCopy() throws SBOLValidationException {
        return new Collection(this);
    }

    @Override
    Collection copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        Collection cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        return cloned;
    }

    @Override
    void checkDescendantsURIcompliance() {
    }

    @Override
    public String toString() {
        return "Collection [" + super.toString() + (this.members.size() > 0 ? ", members=" + this.members : "") + "]";
    }
}

