/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.ComponentInstance;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.RoleIntegrationType;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class Component
extends ComponentInstance {
    private HashMap<URI, MapsTo> mapsTos;
    private Set<URI> roles;
    private RoleIntegrationType roleIntegration;
    private ComponentDefinition componentDefinition = null;

    Component(URI identity, AccessType access, URI definition) throws SBOLValidationException {
        super(identity, access, definition);
        this.mapsTos = new HashMap();
        this.roles = new HashSet<URI>();
    }

    private Component(Component component) throws SBOLValidationException {
        super(component);
        this.roles = new HashSet<URI>();
        this.mapsTos = new HashMap();
        if (!component.getMapsTos().isEmpty()) {
            HashSet<MapsTo> mapsTos = new HashSet<MapsTo>();
            for (MapsTo mapsTo : component.getMapsTos()) {
                mapsTos.add(mapsTo.deepCopy());
            }
            this.setMapsTos(mapsTos);
        }
        this.roles = new HashSet<URI>();
        for (URI role : component.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
    }

    void copy(Component component) throws SBOLValidationException {
        this.copy((ComponentInstance)component);
        if (!component.getMapsTos().isEmpty()) {
            for (MapsTo mapsTo : component.getMapsTos()) {
                String displayId = mapsTo.getDisplayId();
                if (displayId == null) {
                    displayId = URIcompliance.extractDisplayId(mapsTo.getIdentity());
                }
                MapsTo newMapsTo = this.createMapsTo(displayId, mapsTo.getRefinement(), mapsTo.getLocal().getDisplayId(), mapsTo.getRemoteURI());
                newMapsTo.copy(mapsTo);
            }
        }
        for (URI role : component.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
    }

    @Override
    Component deepCopy() throws SBOLValidationException {
        return new Component(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        for (MapsTo mapsTo : this.getMapsTos()) {
            mapsTo.updateCompliantURI(this.getPersistentIdentity().toString(), mapsTo.getDisplayId(), version);
            this.removeChildSafely(mapsTo, this.mapsTos);
            this.addMapsTo(mapsTo);
            String localId = URIcompliance.extractDisplayId(mapsTo.getLocalURI());
            mapsTo.setLocal(URIcompliance.createCompliantURI(URIprefix, localId, version));
        }
    }

    public boolean addRole(URI roleURI) throws SBOLValidationException {
        if (!this.isSetRoleIntegration()) {
            throw new SBOLValidationException("sbol-10709", this);
        }
        return this.roles.add(roleURI);
    }

    public boolean removeRole(URI roleURI) {
        return this.roles.remove(roleURI);
    }

    public void setRoles(Set<URI> roles) throws SBOLValidationException {
        this.clearRoles();
        if (roles == null) {
            return;
        }
        for (URI role : roles) {
            this.addRole(role);
        }
    }

    public Set<URI> getRoles() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.roles);
        return result;
    }

    public boolean containsRole(URI roleURI) {
        return this.roles.contains(roleURI);
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public boolean isSetRoleIntegration() {
        return this.roleIntegration != null;
    }

    public RoleIntegrationType getRoleIntegration() {
        return this.roleIntegration;
    }

    public void setRoleIntegration(RoleIntegrationType roleIntegration) throws SBOLValidationException {
        if (roleIntegration == null && !this.roles.isEmpty()) {
            throw new SBOLValidationException("sbol-10709", this);
        }
        this.roleIntegration = roleIntegration;
    }

    public void unsetRoleIntegration() throws SBOLValidationException {
        if (!this.roles.isEmpty()) {
            throw new SBOLValidationException("sbol-10709", this);
        }
        this.roleIntegration = null;
    }

    private MapsTo createMapsTo(URI identity, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        MapsTo mapping = new MapsTo(identity, refinement, local, remote);
        this.addMapsTo(mapping);
        return mapping;
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, String remoteId) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.componentDefinition.getPersistentIdentity().toString(), localId, this.componentDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.componentDefinition != null && this.componentDefinition.getComponent(localURI) == null) {
            this.componentDefinition.createComponent(localId, AccessType.PUBLIC, localId, "");
        }
        URI remoteURI = URIcompliance.createCompliantURI(this.getDefinition().getPersistentIdentity().toString(), remoteId, this.getDefinition().getVersion());
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, URI remoteURI) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.componentDefinition.getPersistentIdentity().toString(), localId, this.componentDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.componentDefinition != null && this.componentDefinition.getComponent(localURI) == null) {
            this.componentDefinition.createComponent(localId, AccessType.PUBLIC, localId, "");
        }
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        String parentPersistentIdStr = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        MapsTo m = this.createMapsTo(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, version), refinement, local, remote);
        m.setPersistentIdentity(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, ""));
        m.setDisplayId(displayId);
        m.setVersion(version);
        return m;
    }

    private void addMapsTo(MapsTo mapsTo) throws SBOLValidationException {
        mapsTo.setSBOLDocument(this.getSBOLDocument());
        mapsTo.setComponentDefinition(this.componentDefinition);
        mapsTo.setComponentInstance(this);
        if (this.getSBOLDocument() != null && this.componentDefinition.getComponent(mapsTo.getLocalURI()) == null) {
            throw new SBOLValidationException("sbol-10803", mapsTo);
        }
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete()) {
            if (this.getDefinition().getComponent(mapsTo.getRemoteURI()) == null) {
                throw new SBOLValidationException("sbol-10808", mapsTo);
            }
            if (this.getDefinition().getComponent(mapsTo.getRemoteURI()).getAccess().equals((Object)AccessType.PRIVATE)) {
                throw new SBOLValidationException("sbol-10807", mapsTo);
            }
            if (mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) && !mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) {
                throw new SBOLValidationException("sbol-10811", mapsTo);
            }
        }
        if (this.componentDefinition != null) {
            SBOLValidate.checkComponentDefinitionMapsTos(this.componentDefinition, mapsTo);
        }
        this.addChildSafely(mapsTo, this.mapsTos, "mapsTo", new Map[0]);
    }

    public boolean removeMapsTo(MapsTo mapsTo) {
        return this.removeChildSafely(mapsTo, this.mapsTos);
    }

    public MapsTo getMapsTo(String displayId) {
        try {
            return this.mapsTos.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public MapsTo getMapsTo(URI mapsToURI) {
        return this.mapsTos.get(mapsToURI);
    }

    public Set<MapsTo> getMapsTos() {
        return new HashSet<MapsTo>(this.mapsTos.values());
    }

    public void clearMapsTos() {
        Object[] valueSetArray;
        for (Object mapsTo : valueSetArray = this.mapsTos.values().toArray()) {
            this.removeMapsTo((MapsTo)mapsTo);
        }
    }

    void setMapsTos(Set<MapsTo> mapsTos) throws SBOLValidationException {
        this.clearMapsTos();
        for (MapsTo reference : mapsTos) {
            this.addMapsTo(reference);
        }
    }

    void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    @Override
    public void setDefinition(URI definition) throws SBOLValidationException {
        if (this.getSBOLDocument() != null) {
            ComponentDefinition cd = this.getSBOLDocument().getComponentDefinition(definition);
            if (this.getSBOLDocument().isComplete() && cd == null) {
                throw new SBOLValidationException("sbol-10604", this);
            }
            if (this.componentDefinition != null) {
                if (cd != null && this.componentDefinition.getIdentity().equals(cd.getIdentity())) {
                    throw new SBOLValidationException("sbol-10605", this);
                }
                HashSet<URI> visited = new HashSet<URI>();
                visited.add(this.componentDefinition.getIdentity());
                try {
                    SBOLValidate.checkComponentDefinitionCycle(this.getSBOLDocument(), cd, visited);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException("sbol-10605", this);
                }
            }
        }
        super.setDefinition(definition);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.mapsTos == null ? 0 : this.mapsTos.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.mapsTos == null ? other.mapsTos != null : !this.mapsTos.equals(other.mapsTos));
    }

    @Override
    public String toString() {
        return "Component [" + super.toString() + (this.roles.size() > 0 ? ", roles=" + this.roles : "") + (this.getMapsTos().size() > 0 ? ", mapsTos=" + this.getMapsTos() : "") + "]";
    }
}

