/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.GenericLocation;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.RestrictionType;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class ComponentDefinition
extends TopLevel {
    private Set<URI> types = new HashSet<URI>();
    private Set<URI> roles = new HashSet<URI>();
    private Set<URI> sequences = new HashSet<URI>();
    private HashMap<URI, Component> components = new HashMap();
    private HashMap<URI, SequenceAnnotation> sequenceAnnotations = new HashMap();
    private HashMap<URI, SequenceConstraint> sequenceConstraints = new HashMap();
    public static final URI DNA = URI.create("http://www.biopax.org/release/biopax-level3.owl#DnaRegion");
    public static final URI RNA = URI.create("http://www.biopax.org/release/biopax-level3.owl#RnaRegion");
    public static final URI PROTEIN = URI.create("http://www.biopax.org/release/biopax-level3.owl#Protein");
    public static final URI SMALL_MOLECULE = URI.create("http://www.biopax.org/release/biopax-level3.owl#SmallMolecule");
    public static final URI COMPLEX = URI.create("http://www.biopax.org/release/biopax-level3.owl#Complex");
    public static final URI EFFECTOR = URI.create("http://identifiers.org/chebi/CHEBI:35224");

    ComponentDefinition(URI identity, Set<URI> types) throws SBOLValidationException {
        super(identity);
        this.setTypes(types);
    }

    private ComponentDefinition(ComponentDefinition componentDefinition) throws SBOLValidationException {
        super(componentDefinition);
        for (URI type : componentDefinition.getTypes()) {
            this.addType(URI.create(type.toString()));
        }
        for (URI role : componentDefinition.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
        for (Component subComponent : componentDefinition.getComponents()) {
            this.addComponent(subComponent.deepCopy());
        }
        for (SequenceConstraint sequenceConstraint : componentDefinition.getSequenceConstraints()) {
            this.addSequenceConstraint(sequenceConstraint.deepCopy());
        }
        for (SequenceAnnotation sequenceAnnotation : componentDefinition.getSequenceAnnotations()) {
            this.addSequenceAnnotation(sequenceAnnotation.deepCopy());
        }
        this.setSequences(componentDefinition.getSequenceURIs());
    }

    void copy(ComponentDefinition componentDefinition) throws SBOLValidationException {
        String displayId;
        this.copy((TopLevel)componentDefinition);
        for (URI role : componentDefinition.getRoles()) {
            this.addRole(URI.create(role.toString()));
        }
        for (Component component : componentDefinition.getComponents()) {
            displayId = component.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(component.getIdentity());
            }
            Component newComponent = this.createComponent(displayId, component.getAccess(), component.getDefinitionURI());
            newComponent.copy(component);
        }
        for (SequenceConstraint sequenceConstraint : componentDefinition.getSequenceConstraints()) {
            displayId = sequenceConstraint.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(sequenceConstraint.getIdentity());
            }
            SequenceConstraint newSequenceConstraint = this.createSequenceConstraint(displayId, sequenceConstraint.getRestriction(), sequenceConstraint.getSubject().getDisplayId(), sequenceConstraint.getObject().getDisplayId());
            newSequenceConstraint.copy(sequenceConstraint);
        }
        for (SequenceAnnotation sequenceAnnotation : componentDefinition.getSequenceAnnotations()) {
            displayId = sequenceAnnotation.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(sequenceAnnotation.getIdentity());
            }
            SequenceAnnotation newSequenceAnnotation = this.createSequenceAnnotation(displayId, "DUMMY__LOCATION");
            newSequenceAnnotation.copy(sequenceAnnotation);
        }
        this.setSequences(componentDefinition.getSequenceURIs());
    }

    public boolean addType(URI typeURI) throws SBOLValidationException {
        if ((typeURI.equals(DNA) || typeURI.equals(RNA) || typeURI.equals(PROTEIN) || typeURI.equals(SMALL_MOLECULE)) && (this.containsType(DNA) || this.containsType(RNA) || this.containsType(PROTEIN) || this.containsType(SMALL_MOLECULE))) {
            throw new SBOLValidationException("sbol-10503", this);
        }
        return this.types.add(typeURI);
    }

    public boolean removeType(URI typeURI) throws SBOLValidationException {
        if (this.types.size() == 1 && this.types.contains(typeURI)) {
            throw new SBOLValidationException("sbol-10502", this);
        }
        return this.types.remove(typeURI);
    }

    public void setTypes(Set<URI> types) throws SBOLValidationException {
        if (types == null || types.size() == 0) {
            throw new SBOLValidationException("sbol-10502", this);
        }
        this.clearTypes();
        for (URI type : types) {
            this.addType(type);
        }
    }

    public Set<URI> getTypes() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.types);
        return result;
    }

    public boolean containsType(URI typeURI) {
        return this.types.contains(typeURI);
    }

    private void clearTypes() {
        this.types.clear();
    }

    public boolean addRole(URI roleURI) {
        return this.roles.add(roleURI);
    }

    public boolean removeRole(URI roleURI) {
        return this.roles.remove(roleURI);
    }

    public void setRoles(Set<URI> roles) {
        this.clearRoles();
        if (roles == null) {
            return;
        }
        for (URI role : roles) {
            this.addRole(role);
        }
    }

    public Set<URI> getRoles() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.roles);
        return result;
    }

    public boolean containsRole(URI roleURI) {
        return this.roles.contains(roleURI);
    }

    public void clearRoles() {
        this.roles.clear();
    }

    public boolean addSequence(Sequence sequence) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getSequence(sequence.getIdentity()) == null) {
            throw new SBOLValidationException("sbol-10513", sequence);
        }
        return this.addSequence(sequence.getIdentity());
    }

    public boolean addSequence(URI sequenceURI) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getSequence(sequenceURI) == null) {
            throw new SBOLValidationException("sbol-10513", this);
        }
        return this.sequences.add(sequenceURI);
    }

    public boolean addSequence(String displayId, String version) throws SBOLValidationException {
        URI sequenceURI = URIcompliance.createCompliantURI(this.getSBOLDocument().getDefaultURIprefix(), "seq", displayId, version, this.getSBOLDocument().isTypesInURIs());
        return this.addSequence(sequenceURI);
    }

    public boolean addSequence(String displayId) throws SBOLValidationException {
        return this.addSequence(displayId, "");
    }

    public Set<URI> getSequenceURIs() {
        return this.sequences;
    }

    public Set<Sequence> getSequences() {
        if (this.getSBOLDocument() == null) {
            return null;
        }
        HashSet<Sequence> resolved = new HashSet<Sequence>();
        for (URI su : this.sequences) {
            Sequence seq = this.getSBOLDocument().getSequence(su);
            if (seq == null) continue;
            resolved.add(seq);
        }
        return resolved;
    }

    public Sequence getSequenceByEncoding(URI encoding) {
        if (this.getSBOLDocument() == null) {
            return null;
        }
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getEncoding().equals(encoding)) continue;
            return sequence;
        }
        return null;
    }

    public String getImpliedNucleicAcidSequence() {
        URI type = null;
        if (this.getTypes().contains(DNA)) {
            type = DNA;
        } else if (this.getTypes().contains(RNA)) {
            type = RNA;
        } else {
            return null;
        }
        String elements = "";
        int length = 0;
        if (this.getSequenceByEncoding(Sequence.IUPAC_DNA) != null) {
            length = this.getSequenceByEncoding(Sequence.IUPAC_DNA).getElements().length();
        }
        for (SequenceAnnotation sequenceAnnotation : this.getSequenceAnnotations()) {
            for (Location location : sequenceAnnotation.getLocations()) {
                Range range;
                if (!(location instanceof Range) || (range = (Range)location).getEnd() <= length) continue;
                length = range.getEnd();
            }
        }
        for (int i = 0; i < length; ++i) {
            elements = elements + "N";
        }
        char[] elementsArray = elements.toCharArray();
        for (SequenceAnnotation sequenceAnnotation : this.getSequenceAnnotations()) {
            String subElements = null;
            if (!sequenceAnnotation.isSetComponent() || sequenceAnnotation.getComponent().getDefinition() == null) continue;
            ComponentDefinition compDef = sequenceAnnotation.getComponent().getDefinition();
            subElements = compDef.getSequenceByEncoding(Sequence.IUPAC_DNA) != null ? compDef.getSequenceByEncoding(Sequence.IUPAC_DNA).getElements() : compDef.getImpliedNucleicAcidSequence();
            for (Location location : sequenceAnnotation.getLocations()) {
                if (!(location instanceof Range)) continue;
                Range range = (Range)location;
                if (range.isSetOrientation() && range.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT)) {
                    subElements = Sequence.reverseComplement(subElements, type);
                }
                for (int i = 0; i < subElements.length(); ++i) {
                    elementsArray[range.getStart() + i - 1] = subElements.charAt(i);
                }
            }
        }
        elements = String.valueOf(elementsArray);
        return elements;
    }

    public void setSequences(Set<URI> sequences) throws SBOLValidationException {
        this.clearSequences();
        if (sequences == null) {
            return;
        }
        for (URI sequence : sequences) {
            this.addSequence(sequence);
        }
    }

    public boolean removeSequence(URI sequenceURI) {
        return this.sequences.remove(sequenceURI);
    }

    public void clearSequences() {
        this.sequences.clear();
    }

    public boolean containsSequence(URI sequenceURI) {
        return this.sequences.contains(sequenceURI);
    }

    private SequenceAnnotation createSequenceAnnotation(URI identity, Set<Location> locations) throws SBOLValidationException {
        SequenceAnnotation sequenceAnnotation = new SequenceAnnotation(identity, locations);
        this.addSequenceAnnotation(sequenceAnnotation);
        return sequenceAnnotation;
    }

    private SequenceAnnotation createSequenceAnnotation(String displayId, Location location) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        URI newSequenceAnnotationURI = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        HashSet<Location> locations = new HashSet<Location>();
        locations.add(location);
        SequenceAnnotation sa = this.createSequenceAnnotation(newSequenceAnnotationURI, locations);
        sa.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        sa.setDisplayId(displayId);
        sa.setVersion(version);
        return sa;
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId) throws SBOLValidationException {
        return this.createSequenceAnnotation(displayId, locationId, null);
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId, OrientationType orientation) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString() + "/" + displayId;
        String version = this.getVersion();
        GenericLocation location = new GenericLocation(URIcompliance.createCompliantURI(URIprefix, locationId, version));
        if (orientation != null) {
            location.setOrientation(orientation);
        }
        location.setPersistentIdentity(URI.create(URIprefix + "/" + locationId));
        location.setDisplayId(locationId);
        location.setVersion(this.getVersion());
        return this.createSequenceAnnotation(displayId, location);
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId, int at) throws SBOLValidationException {
        return this.createSequenceAnnotation(displayId, locationId, at, null);
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId, int at, OrientationType orientation) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString() + "/" + displayId;
        String version = this.getVersion();
        Cut location = new Cut(URIcompliance.createCompliantURI(URIprefix, locationId, version), at);
        if (orientation != null) {
            location.setOrientation(orientation);
        }
        location.setPersistentIdentity(URI.create(URIprefix + "/" + locationId));
        location.setDisplayId(locationId);
        location.setVersion(this.getVersion());
        return this.createSequenceAnnotation(displayId, location);
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId, int start, int end) throws SBOLValidationException {
        return this.createSequenceAnnotation(displayId, locationId, start, end, null);
    }

    public SequenceAnnotation createSequenceAnnotation(String displayId, String locationId, int start, int end, OrientationType orientation) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString() + "/" + displayId;
        String version = this.getVersion();
        Range location = new Range(URIcompliance.createCompliantURI(URIprefix, locationId, version), start, end);
        if (orientation != null) {
            location.setOrientation(orientation);
        }
        location.setPersistentIdentity(URI.create(URIprefix + "/" + locationId));
        location.setDisplayId(locationId);
        location.setVersion(this.getVersion());
        return this.createSequenceAnnotation(displayId, location);
    }

    void addSequenceAnnotation(SequenceAnnotation sequenceAnnotation) throws SBOLValidationException {
        sequenceAnnotation.setSBOLDocument(this.getSBOLDocument());
        sequenceAnnotation.setComponentDefinition(this);
        if (sequenceAnnotation.isSetComponent()) {
            if (sequenceAnnotation.getComponent() == null) {
                throw new SBOLValidationException("sbol-10905", sequenceAnnotation);
            }
            for (SequenceAnnotation sa : this.getSequenceAnnotations()) {
                if (!sa.isSetComponent() || !sa.getComponentURI().equals(sequenceAnnotation.getComponentURI())) continue;
                throw new SBOLValidationException("sbol-10522", sa);
            }
        }
        for (Location location : sequenceAnnotation.getLocations()) {
            location.setSBOLDocument(this.getSBOLDocument());
        }
        this.addChildSafely(sequenceAnnotation, this.sequenceAnnotations, "sequenceAnnotation", this.components, this.sequenceConstraints);
    }

    public boolean removeSequenceAnnotation(SequenceAnnotation sequenceAnnotation) {
        return this.removeChildSafely(sequenceAnnotation, this.sequenceAnnotations);
    }

    public SequenceAnnotation getSequenceAnnotation(String displayId) {
        try {
            return this.sequenceAnnotations.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public SequenceAnnotation getSequenceAnnotation(URI sequenceAnnotationURI) {
        return this.sequenceAnnotations.get(sequenceAnnotationURI);
    }

    public SequenceAnnotation getSequenceAnnotation(Component component) {
        for (SequenceAnnotation sequenceAnnotation : this.getSequenceAnnotations()) {
            if (sequenceAnnotation.getComponent() == null || !sequenceAnnotation.getComponent().equals(component)) continue;
            return sequenceAnnotation;
        }
        return null;
    }

    public Set<SequenceAnnotation> getSequenceAnnotations() {
        HashSet<SequenceAnnotation> sequenceAnnotations = new HashSet<SequenceAnnotation>();
        sequenceAnnotations.addAll(this.sequenceAnnotations.values());
        return sequenceAnnotations;
    }

    private void getSuccessorComponents(HashMap<Component, Set<Component>> successorMap, Component component, Set<Component> visited) throws SBOLValidationException {
        if (visited.contains(component)) {
            throw new SBOLValidationException("Cycle in sequence constraints", new Identified[0]);
        }
        visited.add(component);
        for (SequenceConstraint sc : this.getSequenceConstraints()) {
            if (!sc.getSubject().equals(component)) continue;
            successorMap.get(component).add(sc.getObject());
            this.getSuccessorComponents(successorMap, sc.getObject(), visited);
            successorMap.get(component).addAll((Collection<Component>)successorMap.get(sc.getObject()));
        }
        visited.remove(component);
    }

    private boolean isGenericSequenceAnnotation(SequenceAnnotation sequenceAnnotation) {
        boolean generic = true;
        for (Location location : sequenceAnnotation.getLocations()) {
            if (!(location instanceof Range) && !(location instanceof Cut)) continue;
            generic = false;
            break;
        }
        return generic;
    }

    public List<Component> getSortedComponents() throws SBOLValidationException {
        boolean change;
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        ArrayList<SequenceAnnotation> sortedSAs = new ArrayList<SequenceAnnotation>();
        sortedSAs.addAll(this.getSequenceAnnotations());
        Collections.sort(sortedSAs);
        HashMap<Component, Set<Component>> successorMap = new HashMap<Component, Set<Component>>();
        for (Component component : this.getComponents()) {
            successorMap.put(component, new HashSet());
        }
        for (int i = 0; i < sortedSAs.size(); ++i) {
            SequenceAnnotation source = (SequenceAnnotation)sortedSAs.get(i);
            if (this.isGenericSequenceAnnotation(source) || !source.isSetComponent()) continue;
            Component sourceComponent = source.getComponent();
            for (int j = i + 1; j < sortedSAs.size(); ++j) {
                SequenceAnnotation target = (SequenceAnnotation)sortedSAs.get(j);
                if (this.isGenericSequenceAnnotation(target) || !target.isSetComponent()) continue;
                Component targetComponent = target.getComponent();
                successorMap.get(sourceComponent).add(targetComponent);
            }
        }
        for (Component component : this.getComponents()) {
            this.getSuccessorComponents(successorMap, component, new HashSet<Component>());
        }
        block4: do {
            change = false;
            for (Component component1 : this.getComponents()) {
                if (sortedComponents.contains(component1)) continue;
                boolean add = true;
                for (Component component2 : this.getComponents()) {
                    if (component1 == component2 || sortedComponents.contains(component2) || !successorMap.get(component2).contains(component1)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                sortedComponents.add(component1);
                change = true;
                continue block4;
            }
        } while (change);
        return sortedComponents;
    }

    public List<SequenceAnnotation> getSortedSequenceAnnotations() {
        ArrayList<SequenceAnnotation> sortedSAs = new ArrayList<SequenceAnnotation>();
        sortedSAs.addAll(this.getSequenceAnnotations());
        Collections.sort(sortedSAs);
        return sortedSAs;
    }

    List<SequenceAnnotation> getSortedSequenceAnnotationsByDisplayId() {
        ArrayList<SequenceAnnotation> sortedSAs = new ArrayList<SequenceAnnotation>();
        sortedSAs.addAll(this.getSequenceAnnotations());
        Collections.sort(sortedSAs, new SADisplayIdComparator());
        return sortedSAs;
    }

    public void clearSequenceAnnotations() {
        Object[] valueSetArray;
        for (Object sequenceAnnotation : valueSetArray = this.sequenceAnnotations.values().toArray()) {
            this.removeSequenceAnnotation((SequenceAnnotation)sequenceAnnotation);
        }
    }

    void setSequenceAnnotations(Set<SequenceAnnotation> sequenceAnnotations) throws SBOLValidationException {
        this.clearSequenceAnnotations();
        for (SequenceAnnotation sequenceAnnotation : sequenceAnnotations) {
            this.addSequenceAnnotation(sequenceAnnotation);
        }
    }

    private Component createComponent(URI identity, AccessType access, URI componentDefinitionURI) throws SBOLValidationException {
        Component component = new Component(identity, access, componentDefinitionURI);
        this.addComponent(component);
        return component;
    }

    public Component createComponent(String displayId, AccessType access, String definitionId, String version) throws SBOLValidationException {
        URI definitionURI = URIcompliance.createCompliantURI(this.getSBOLDocument().getDefaultURIprefix(), "cd", definitionId, version, this.getSBOLDocument().isTypesInURIs());
        return this.createComponent(displayId, access, definitionURI);
    }

    public Component createComponent(String displayId, AccessType access, String definitionId) throws SBOLValidationException {
        return this.createComponent(displayId, access, definitionId, "");
    }

    public Component createComponent(String displayId, AccessType access, URI definitionURI) throws SBOLValidationException {
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getComponentDefinition(definitionURI) == null) {
            throw new SBOLValidationException("sbol-10604", this);
        }
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        Component c = this.createComponent(URIcompliance.createCompliantURI(URIprefix, displayId, version), access, definitionURI);
        c.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        c.setDisplayId(displayId);
        c.setVersion(version);
        return c;
    }

    private void addComponent(Component component) throws SBOLValidationException {
        component.setSBOLDocument(this.getSBOLDocument());
        component.setComponentDefinition(this);
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && component.getDefinition() == null) {
            throw new SBOLValidationException("sbol-10604", component);
        }
        if (component.getDefinition() != null && this.getIdentity().equals(component.getDefinition().getIdentity())) {
            throw new SBOLValidationException("sbol-10605", component);
        }
        HashSet<URI> visited = new HashSet<URI>();
        visited.add(this.getIdentity());
        try {
            SBOLValidate.checkComponentDefinitionCycle(this.getSBOLDocument(), component.getDefinition(), visited);
        }
        catch (SBOLValidationException e) {
            throw new SBOLValidationException("sbol-10605", component);
        }
        this.addChildSafely(component, this.components, "component", this.sequenceAnnotations, this.sequenceConstraints);
        for (MapsTo mapsTo : component.getMapsTos()) {
            if (this.getComponent(mapsTo.getLocalURI()) == null) {
                throw new SBOLValidationException("sbol-10803", mapsTo);
            }
            mapsTo.setSBOLDocument(this.getSBOLDocument());
            mapsTo.setComponentDefinition(this);
            mapsTo.setComponentInstance(component);
        }
    }

    private void addComponentNoCheck(Component component) throws SBOLValidationException {
        component.setSBOLDocument(this.getSBOLDocument());
        component.setComponentDefinition(this);
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && component.getDefinition() == null) {
            throw new SBOLValidationException("sbol-10604", component);
        }
        if (this.getIdentity().equals(component.getDefinitionURI())) {
            throw new SBOLValidationException("sbol-10603", component);
        }
        HashSet<URI> visited = new HashSet<URI>();
        visited.add(this.getIdentity());
        SBOLValidate.checkComponentDefinitionCycle(this.getSBOLDocument(), component.getDefinition(), visited);
        this.addChildSafely(component, this.components, "component", this.sequenceAnnotations, this.sequenceConstraints);
    }

    private void checkMapsTosLocalURIs() throws SBOLValidationException {
        for (Component component : this.getComponents()) {
            for (MapsTo mapsTo : component.getMapsTos()) {
                if (this.getComponent(mapsTo.getLocalURI()) == null) {
                    throw new SBOLValidationException("sbol-10803", mapsTo);
                }
                mapsTo.setSBOLDocument(this.getSBOLDocument());
                mapsTo.setComponentDefinition(this);
                mapsTo.setComponentInstance(component);
            }
        }
    }

    public boolean removeComponent(Component component) throws SBOLValidationException {
        for (SequenceAnnotation sa : this.sequenceAnnotations.values()) {
            if (!sa.getComponentURI().equals(component.getIdentity())) continue;
            throw new SBOLValidationException("sbol-10905", sa);
        }
        for (SequenceConstraint sc : this.sequenceConstraints.values()) {
            if (sc.getSubjectURI().equals(component.getIdentity())) {
                throw new SBOLValidationException("sbol-11402", sc);
            }
            if (!sc.getObjectURI().equals(component.getIdentity())) continue;
            throw new SBOLValidationException("sbol-11404", sc);
        }
        for (Component c : this.components.values()) {
            for (MapsTo mt : c.getMapsTos()) {
                if (!mt.getLocalURI().equals(component.getIdentity())) continue;
                throw new SBOLValidationException("sbol-10803", mt);
            }
        }
        if (this.getSBOLDocument() != null) {
            for (ComponentDefinition cd : this.getSBOLDocument().getComponentDefinitions()) {
                for (Component c : cd.getComponents()) {
                    for (MapsTo mt : c.getMapsTos()) {
                        if (!mt.getRemoteURI().equals(component.getIdentity())) continue;
                        throw new SBOLValidationException("sbol-10808", mt);
                    }
                }
            }
        }
        return this.removeChildSafely(component, this.components);
    }

    public Component getComponent(String displayId) {
        try {
            return this.components.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Component getComponent(URI componentURI) {
        return this.components.get(componentURI);
    }

    public Set<Component> getComponents() {
        HashSet<Component> components = new HashSet<Component>();
        components.addAll(this.components.values());
        return components;
    }

    public void clearComponents() throws SBOLValidationException {
        Object[] valueSetArray;
        for (Object component : valueSetArray = this.components.values().toArray()) {
            this.removeComponent((Component)component);
        }
    }

    void setComponents(Set<Component> components) throws SBOLValidationException {
        this.clearComponents();
        for (Component component : components) {
            this.addComponentNoCheck(component);
        }
        this.checkMapsTosLocalURIs();
    }

    private SequenceConstraint createSequenceConstraint(URI identity, RestrictionType restriction, URI subject, URI object) throws SBOLValidationException {
        SequenceConstraint sequenceConstraint = new SequenceConstraint(identity, restriction, subject, object);
        this.addSequenceConstraint(sequenceConstraint);
        return sequenceConstraint;
    }

    public SequenceConstraint createSequenceConstraint(String displayId, RestrictionType restriction, String subjectId, String objectId) throws SBOLValidationException {
        URI subjectURI = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), subjectId, this.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.getComponent(subjectURI) == null) {
            this.createComponent(subjectId, AccessType.PUBLIC, subjectId, "");
        }
        URI objectURI = URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), objectId, this.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.getComponent(objectURI) == null) {
            this.createComponent(objectId, AccessType.PUBLIC, objectId, "");
        }
        return this.createSequenceConstraint(displayId, restriction, subjectURI, objectURI);
    }

    public SequenceConstraint createSequenceConstraint(String displayId, RestrictionType restriction, URI subjectURI, URI objectURI) throws SBOLValidationException {
        String URIprefix = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        SequenceConstraint sc = this.createSequenceConstraint(URIcompliance.createCompliantURI(URIprefix, displayId, version), restriction, subjectURI, objectURI);
        sc.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        sc.setDisplayId(displayId);
        sc.setVersion(version);
        return sc;
    }

    private void addSequenceConstraint(SequenceConstraint sequenceConstraint) throws SBOLValidationException {
        sequenceConstraint.setSBOLDocument(this.getSBOLDocument());
        sequenceConstraint.setComponentDefinition(this);
        if (sequenceConstraint.getSubject() == null) {
            throw new SBOLValidationException("sbol-11403", sequenceConstraint);
        }
        if (sequenceConstraint.getObject() == null) {
            throw new SBOLValidationException("sbol-11405", sequenceConstraint);
        }
        if (sequenceConstraint.getSubjectURI().equals(sequenceConstraint.getObjectURI())) {
            throw new SBOLValidationException("sbol-11406", sequenceConstraint);
        }
        SBOLValidate.checkSequenceConstraint(this, sequenceConstraint);
        this.addChildSafely(sequenceConstraint, this.sequenceConstraints, "sequenceConstraint", this.components, this.sequenceAnnotations);
    }

    public boolean removeSequenceConstraint(SequenceConstraint sequenceConstraint) {
        return this.removeChildSafely(sequenceConstraint, this.sequenceConstraints);
    }

    public SequenceConstraint getSequenceConstraint(String displayId) {
        try {
            return this.sequenceConstraints.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public SequenceConstraint getSequenceConstraint(URI sequenceConstraintURI) {
        return this.sequenceConstraints.get(sequenceConstraintURI);
    }

    public Set<SequenceConstraint> getSequenceConstraints() {
        HashSet<SequenceConstraint> sequenceConstraints = new HashSet<SequenceConstraint>();
        sequenceConstraints.addAll(this.sequenceConstraints.values());
        return sequenceConstraints;
    }

    public void clearSequenceConstraints() {
        Object[] valueSetArray;
        for (Object sequenceConstraint : valueSetArray = this.sequenceConstraints.values().toArray()) {
            this.removeSequenceConstraint((SequenceConstraint)sequenceConstraint);
        }
    }

    void setSequenceConstraints(Set<SequenceConstraint> sequenceConstraints) throws SBOLValidationException {
        this.clearSequenceConstraints();
        for (SequenceConstraint sequenceConstraint : sequenceConstraints) {
            this.addSequenceConstraint(sequenceConstraint);
        }
    }

    @Override
    void checkDescendantsURIcompliance() throws SBOLValidationException {
        if (!this.getSequenceConstraints().isEmpty()) {
            for (SequenceConstraint sequenceConstraint : this.getSequenceConstraints()) {
                try {
                    URIcompliance.isChildURIcompliant(this, sequenceConstraint);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), sequenceConstraint);
                }
            }
        }
        if (!this.getComponents().isEmpty()) {
            for (Component component : this.getComponents()) {
                try {
                    URIcompliance.isChildURIcompliant(this, component);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), component);
                }
                if (component.getMapsTos().isEmpty()) continue;
                for (MapsTo mapsTo : component.getMapsTos()) {
                    try {
                        URIcompliance.isChildURIcompliant(component, mapsTo);
                    }
                    catch (SBOLValidationException e) {
                        throw new SBOLValidationException(e.getRule(), mapsTo);
                    }
                }
            }
        }
        if (!this.getSequenceAnnotations().isEmpty()) {
            for (SequenceAnnotation sequenceAnnotation : this.getSequenceAnnotations()) {
                try {
                    URIcompliance.isChildURIcompliant(this, sequenceAnnotation);
                }
                catch (SBOLValidationException e) {
                    throw new SBOLValidationException(e.getRule(), sequenceAnnotation);
                }
                Set<Location> locations = sequenceAnnotation.getLocations();
                for (Location location : locations) {
                    if (location instanceof Range) {
                        try {
                            URIcompliance.isChildURIcompliant(sequenceAnnotation, location);
                        }
                        catch (SBOLValidationException e) {
                            throw new SBOLValidationException(e.getRule(), location);
                        }
                    }
                    if (location instanceof Cut) {
                        try {
                            URIcompliance.isChildURIcompliant(sequenceAnnotation, location);
                        }
                        catch (SBOLValidationException e) {
                            throw new SBOLValidationException(e.getRule(), location);
                        }
                    }
                    if (!(location instanceof GenericLocation)) continue;
                    try {
                        URIcompliance.isChildURIcompliant(sequenceAnnotation, location);
                    }
                    catch (SBOLValidationException e) {
                        throw new SBOLValidationException(e.getRule(), location);
                    }
                }
            }
        }
    }

    @Override
    ComponentDefinition deepCopy() throws SBOLValidationException {
        return new ComponentDefinition(this);
    }

    @Override
    ComponentDefinition copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        ComponentDefinition cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        int count = 0;
        for (Component component : cloned.getComponents()) {
            if (!component.isSetDisplayId()) {
                component.setDisplayId("component" + ++count);
            }
            component.updateCompliantURI(cloned.getPersistentIdentity().toString(), component.getDisplayId(), version);
            cloned.removeChildSafely(component, cloned.components);
            cloned.addComponent(component);
        }
        count = 0;
        for (SequenceConstraint sequenceConstraint : cloned.getSequenceConstraints()) {
            if (!sequenceConstraint.isSetDisplayId()) {
                sequenceConstraint.setDisplayId("sequenceConstraint" + ++count);
            }
            sequenceConstraint.updateCompliantURI(cloned.getPersistentIdentity().toString(), sequenceConstraint.getDisplayId(), version);
            cloned.removeChildSafely(sequenceConstraint, cloned.sequenceConstraints);
            cloned.addSequenceConstraint(sequenceConstraint);
        }
        count = 0;
        for (SequenceAnnotation sequenceAnnotation : cloned.getSequenceAnnotations()) {
            if (!sequenceAnnotation.isSetDisplayId()) {
                sequenceAnnotation.setDisplayId("sequenceAnnotation" + ++count);
            }
            sequenceAnnotation.updateCompliantURI(cloned.getPersistentIdentity().toString(), sequenceAnnotation.getDisplayId(), version);
            cloned.removeChildSafely(sequenceAnnotation, cloned.sequenceAnnotations);
            cloned.addSequenceAnnotation(sequenceAnnotation);
        }
        return cloned;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.sequences == null ? 0 : this.sequences.hashCode());
        result = 31 * result + (this.sequenceAnnotations == null ? 0 : this.sequenceAnnotations.hashCode());
        result = 31 * result + (this.sequenceConstraints == null ? 0 : this.sequenceConstraints.hashCode());
        result = 31 * result + (this.components == null ? 0 : this.components.hashCode());
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentDefinition other = (ComponentDefinition)obj;
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        if (this.sequences == null ? other.sequences != null : !this.sequences.equals(other.sequences)) {
            return false;
        }
        if (this.sequenceAnnotations == null ? other.sequenceAnnotations != null : !this.sequenceAnnotations.equals(other.sequenceAnnotations)) {
            return false;
        }
        if (this.sequenceConstraints == null ? other.sequenceConstraints != null : !this.sequenceConstraints.equals(other.sequenceConstraints)) {
            return false;
        }
        if (this.components == null ? other.components != null : !this.components.equals(other.components)) {
            return false;
        }
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    @Override
    public String toString() {
        return "ComponentDefinition [" + super.toString() + ", types=" + this.types + (this.roles.size() > 0 ? ", roles=" + this.roles : "") + (this.getSequenceURIs().size() > 0 ? ", sequences=" + this.getSequenceURIs() : "") + (this.getComponents().size() > 0 ? ", components=" + this.getComponents() : "") + (this.getSequenceAnnotations().size() > 0 ? ", sequenceAnnotations=" + this.getSequenceAnnotations() : "") + (this.getSequenceConstraints().size() > 0 ? ", sequenceConstraints=" + this.getSequenceConstraints() : "") + "]";
    }

    class SADisplayIdComparator
    implements Comparator<Object> {
        SADisplayIdComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            SequenceAnnotation myObj1 = (SequenceAnnotation)obj1;
            SequenceAnnotation myObj2 = (SequenceAnnotation)obj2;
            if (myObj1.getDisplayId().startsWith("annotation") && myObj2.getDisplayId().startsWith("annotation")) {
                int myObj1int = Integer.parseInt(myObj1.getDisplayId().replace("annotation", ""));
                int myObj2int = Integer.parseInt(myObj2.getDisplayId().replace("annotation", ""));
                return myObj1int - myObj2int;
            }
            return myObj1.getDisplayId().compareTo(myObj2.getDisplayId());
        }
    }
}

