/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;

public abstract class ComponentInstance
extends Identified {
    private AccessType access;
    private URI definition;

    ComponentInstance(URI identity, AccessType access, URI definition) throws SBOLValidationException {
        super(identity);
        this.setAccess(access);
        this.setDefinition(definition);
    }

    ComponentInstance(ComponentInstance component) throws SBOLValidationException {
        super(component);
        this.setAccess(component.getAccess());
        this.setDefinition(component.getDefinitionURI());
    }

    void copy(ComponentInstance component) throws SBOLValidationException {
        this.copy((Identified)component);
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType access) throws SBOLValidationException {
        if (access == null) {
            throw new SBOLValidationException("sbol-10607", this);
        }
        this.access = access;
    }

    public URI getDefinitionURI() {
        return this.definition;
    }

    public ComponentDefinition getDefinition() {
        if (this.getSBOLDocument() == null) {
            return null;
        }
        return this.getSBOLDocument().getComponentDefinition(this.definition);
    }

    public void setDefinition(URI definition) throws SBOLValidationException {
        if (definition == null) {
            throw new SBOLValidationException("sbol-10602", this);
        }
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete() && this.getSBOLDocument().getComponentDefinition(definition) == null) {
            throw new SBOLValidationException("sbol-10604", this);
        }
        this.definition = definition;
    }

    @Override
    abstract ComponentInstance deepCopy() throws SBOLValidationException;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.access == null ? 0 : this.access.hashCode());
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInstance other = (ComponentInstance)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return this.access == other.access;
    }

    @Override
    public String toString() {
        return super.toString() + ", access=" + (Object)((Object)this.access) + ", definition=" + this.definition;
    }
}

