/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.SBOLValidationException;

public class Cut
extends Location {
    private int at;

    Cut(URI identity, int at) throws SBOLValidationException {
        super(identity);
        this.setAt(at);
    }

    private Cut(Cut cut) throws SBOLValidationException {
        super(cut);
        this.setAt(cut.getAt());
    }

    void copy(Cut cut) throws SBOLValidationException {
        this.copy((Location)cut);
    }

    public int getAt() {
        return this.at;
    }

    public void setAt(int at) throws SBOLValidationException {
        if (at < 0) {
            throw new SBOLValidationException("sbol-11202", this);
        }
        this.at = at;
    }

    @Override
    Cut deepCopy() throws SBOLValidationException {
        return new Cut(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.at;
        result = 31 * result + (this.getOrientation() == null ? 0 : this.getOrientation().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cut other = (Cut)obj;
        if (this.at != other.at) {
            return false;
        }
        return this.getOrientation() == other.getOrientation();
    }

    @Override
    public String toString() {
        return "Cut [" + super.toString() + ", at=" + this.at + "]";
    }

    @Override
    public int compareTo(Location location) {
        int thisPos = -1;
        Annotation annotation = this.getAnnotation(new QName("http://www.ncbi.nlm.nih.gov/genbank#", "position", "genbank"));
        if (annotation != null) {
            thisPos = Integer.parseInt(annotation.getStringValue().replace("position", ""));
        }
        int otherPos = -1;
        annotation = location.getAnnotation(new QName("http://www.ncbi.nlm.nih.gov/genbank#", "position", "genbank"));
        if (annotation != null) {
            otherPos = Integer.parseInt(annotation.getStringValue().replace("position", ""));
        }
        if (thisPos != -1 && otherPos != -1) {
            int result = thisPos - otherPos;
            return result;
        }
        if (location instanceof Range) {
            int result = this.at - ((Range)location).getStart();
            if (result == 0) {
                result = this.at - ((Range)location).getEnd();
            }
            return result;
        }
        if (location instanceof Cut) {
            return this.at - ((Cut)location).getAt();
        }
        return -2147483647;
    }
}

