/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;

public enum DirectionType {
    IN("in"),
    OUT("out"),
    INOUT("inout"),
    NONE("none");

    private final String directionType;
    private static final URI in;
    private static final URI out;
    private static final URI inout;
    private static final URI none;

    private DirectionType(String directionType) {
        this.directionType = directionType;
    }

    public String toString() {
        return this.directionType;
    }

    static DirectionType convertToDirectionType(URI direction) throws SBOLValidationException {
        if (direction != null) {
            if (direction.equals(inout)) {
                return INOUT;
            }
            if (direction.equals(in)) {
                return IN;
            }
            if (direction.equals(none)) {
                return NONE;
            }
            if (direction.equals(out)) {
                return OUT;
            }
            throw new SBOLValidationException("sbol-11802", new Identified[0]);
        }
        throw new SBOLValidationException("sbol-11802", new Identified[0]);
    }

    static URI convertToURI(DirectionType direction) {
        if (direction != null) {
            if (direction.equals((Object)INOUT)) {
                return inout;
            }
            if (direction.equals((Object)IN)) {
                return in;
            }
            if (direction.equals((Object)OUT)) {
                return out;
            }
            if (direction.equals((Object)NONE)) {
                return none;
            }
            return null;
        }
        return null;
    }

    static {
        in = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "in");
        out = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "out");
        inout = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "inout");
        none = URI.create(Sbol2Terms.sbol2.getNamespaceURI() + "none");
    }
}

