/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.oboparser.obo.OBOOntology;
import org.oboparser.obo.OBOParser;
import org.oboparser.obo.OBOStanza;

public class EDAMOntology {
    private static final String URI_PREFIX = "http://identifiers.org/edam/";
    public static final URI NAMESPACE = URI.create("http://identifiers.org/edam/");
    private static OBOOntology EDAMOntology = null;
    public static final URI FORMAT = org.sbolstandard.core2.EDAMOntology.type("format_1915");
    public static final URI SBML = org.sbolstandard.core2.EDAMOntology.type("format_2585");
    public static final URI CELLML = org.sbolstandard.core2.EDAMOntology.type("format_3240");
    public static final URI BIOPAX = org.sbolstandard.core2.EDAMOntology.type("format_3156");

    public EDAMOntology() {
        if (EDAMOntology == null) {
            OBOParser oboParser = new OBOParser();
            InputStreamReader f = new InputStreamReader(this.getClass().getResourceAsStream("/ontologies/EDAMOntology/EDAM.obo"));
            try {
                oboParser.parse(f);
                EDAMOntology = oboParser.getOntology();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final String getId(URI stanzaURI) {
        String stanzaURIstr = stanzaURI.toString().trim();
        if (!stanzaURIstr.startsWith(URI_PREFIX)) {
            try {
                throw new IllegalArgumentException("Illegal " + stanzaURI.toString() + ". It does not begin with the URI prefix " + URI_PREFIX);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        int beginIndex = stanzaURIstr.lastIndexOf("/") + 1;
        return stanzaURIstr.substring(beginIndex, stanzaURIstr.length());
    }

    public final String getId(String stanzaName) {
        ArrayList<String> IdList = new ArrayList<String>();
        for (OBOStanza stanza : EDAMOntology.getStanzas()) {
            if (!stanzaName.trim().equals(stanza.getName().trim())) continue;
            IdList.add(stanza.getId());
        }
        if (IdList.isEmpty()) {
            try {
                throw new IllegalArgumentException("Illegal name " + stanzaName + ". It does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return (String)IdList.get(0);
    }

    public final String getName(URI stanzaURI) {
        String oboURIstr = stanzaURI.toString().trim();
        if (!oboURIstr.startsWith(URI_PREFIX)) {
            try {
                throw new IllegalArgumentException("Illegal " + stanzaURI.toString() + ". It does not contain URI prefix " + URI_PREFIX);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        int beginIndex = oboURIstr.lastIndexOf("/") + 1;
        String id = oboURIstr.substring(beginIndex, oboURIstr.length());
        OBOStanza oboStanza = EDAMOntology.getStanza(id);
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("ID " + id + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return oboStanza.getName();
    }

    public final String getName(String stanzaId) {
        OBOStanza oboStanza = EDAMOntology.getStanza(stanzaId);
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("Illegal ID " + stanzaId + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return oboStanza.getName();
    }

    public final URI getURIbyName(String stanzaName) {
        return this.getURIbyId(this.getId(stanzaName));
    }

    public final URI getURIbyId(String stanzaId) {
        if (stanzaId == null) {
            return null;
        }
        OBOStanza oboStanza = EDAMOntology.getStanza(stanzaId.trim());
        if (oboStanza == null) {
            try {
                throw new IllegalArgumentException("ID " + stanzaId + " does not exist.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return URI.create(URI_PREFIX + stanzaId);
    }

    public boolean isDescendantOf(String Id1, String Id2) {
        OBOStanza stanza1 = EDAMOntology.getStanza(Id1);
        OBOStanza stanza2 = EDAMOntology.getStanza(Id2);
        if (stanza1 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + Id1 + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if (stanza2 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + Id2 + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return EDAMOntology.isDescendantOf(stanza1, stanza2);
    }

    public final boolean isDescendantOf(URI childURI, URI parentURI) {
        String childId = this.getId(childURI);
        String parentId = this.getId(parentURI);
        if (childId == null || parentId == null) {
            return false;
        }
        return this.isDescendantOf(childId, parentId);
    }

    public Set<String> getDescendantsOf(String parentId) {
        OBOStanza stanza1 = EDAMOntology.getStanza(parentId);
        if (stanza1 == null) {
            try {
                throw new IllegalArgumentException("Illegal ID: " + parentId + ". No match was found.");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return EDAMOntology.getDescendantsOf(stanza1);
    }

    public final Set<String> getDescendantsOf(URI parentURI) {
        String parentId = this.getId(parentURI);
        if (parentId == null) {
            return new HashSet<String>();
        }
        return this.getDescendantsOf(parentId);
    }

    public final Set<URI> getDescendantURIsOf(String parentId) {
        Set<String> descendents = this.getDescendantsOf(parentId);
        HashSet<URI> descendentURIs = new HashSet<URI>();
        for (String child : descendents) {
            descendentURIs.add(this.getURIbyId(child));
        }
        return descendentURIs;
    }

    public final Set<URI> getDescendantURIsOf(URI parentURI) {
        Set<String> descendents = this.getDescendantsOf(parentURI);
        HashSet<URI> descendentURIs = new HashSet<URI>();
        for (String child : descendents) {
            descendentURIs.add(this.getURIbyId(child));
        }
        return descendentURIs;
    }

    public final Set<String> getDescendantNamesOf(String parentId) {
        Set<String> descendents = this.getDescendantsOf(parentId);
        HashSet<String> descendentNames = new HashSet<String>();
        for (String child : descendents) {
            descendentNames.add(this.getName(child));
        }
        return descendentNames;
    }

    public final Set<String> getDescendantNamesOf(URI parentURI) {
        Set<String> descendents = this.getDescendantsOf(parentURI);
        HashSet<String> descendentNames = new HashSet<String>();
        for (String child : descendents) {
            descendentNames.add(this.getName(child));
        }
        return descendentNames;
    }

    private static final URI type(String localName) {
        return URI.create(URI_PREFIX + localName);
    }
}

