/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.URIcompliance;

class FASTA {
    private static String nextLine = null;
    private static final int lineWidth = 80;

    FASTA() {
    }

    private static void writeFASTALine(Writer w, String line, int margin) throws IOException {
        if (line.length() < margin) {
            w.write(line + "\n");
        } else {
            String spaces = "";
            int breakPos = line.substring(0, margin - 1).lastIndexOf(" ") + 1;
            if (breakPos == 0 || (double)breakPos < 0.75 * (double)margin) {
                breakPos = margin - 1;
            }
            w.write(line.substring(0, breakPos) + "\n");
            for (int i = breakPos; i < line.length(); i += breakPos) {
                if (i + margin < line.length()) {
                    breakPos = line.substring(i, i + margin - 1).lastIndexOf(" ") + 1;
                    if (breakPos == 0 || (double)breakPos < 0.65 * (double)margin) {
                        breakPos = margin - 1;
                    }
                    w.write(spaces + line.substring(i, i + breakPos) + "\n");
                    continue;
                }
                w.write(spaces + line.substring(i) + "\n");
                breakPos = margin - 1;
            }
        }
    }

    static void write(SBOLDocument document, OutputStream out) throws IOException, SBOLConversionException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        for (Sequence sequence : document.getSequences()) {
            FASTA.write(w, sequence);
        }
        ((Writer)w).close();
    }

    private static void write(Writer w, Sequence sequence) throws IOException, SBOLConversionException {
        if (!(sequence.getEncoding().equals(Sequence.IUPAC_DNA) || sequence.getEncoding().equals(Sequence.IUPAC_RNA) || sequence.getEncoding().equals(Sequence.IUPAC_PROTEIN))) {
            throw new SBOLConversionException("Sequence encoding is not in IUPAC DNA, RNA, or Protein formats.");
        }
        if (sequence.isSetDescription()) {
            w.write("> " + sequence.getDisplayId() + " : " + sequence.getDescription() + "\n");
        } else {
            w.write("> " + sequence.getDisplayId() + "\n");
        }
        FASTA.writeFASTALine(w, sequence.getElements(), 80);
    }

    private static String readFASTALine(BufferedReader br) throws IOException {
        String newLine = "";
        if (nextLine == null) {
            newLine = br.readLine();
            if (newLine == null) {
                return null;
            }
            newLine = newLine.trim();
        } else {
            newLine = nextLine;
        }
        nextLine = br.readLine();
        if (nextLine == null) {
            return newLine;
        }
        nextLine = nextLine.trim();
        return newLine;
    }

    static boolean isFastaFile(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream stream = new FileInputStream(file);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        BufferedReader br = new BufferedReader(new InputStreamReader(buffer));
        String strLine = br.readLine();
        br.close();
        return FASTA.isFastaString(strLine);
    }

    static boolean isFastaString(String inputString) {
        return inputString != null && (inputString.startsWith(">") || inputString.startsWith(";"));
    }

    private static Sequence createSequence(SBOLDocument doc, String URIprefix, String displayId, String version, String elements, URI encoding) throws SBOLValidationException {
        try {
            Sequence sequence = doc.createSequence(URIprefix, displayId, version, elements, encoding);
            return sequence;
        }
        catch (SBOLValidationException e) {
            if (e.getMessage().contains("sbol-10405")) {
                if (encoding.equals(Sequence.IUPAC_DNA)) {
                    Sequence sequence = doc.createSequence(URIprefix, displayId, version, elements, Sequence.IUPAC_PROTEIN);
                    return sequence;
                }
                Sequence sequence = doc.createSequence(URIprefix, displayId, version, elements, Sequence.IUPAC_DNA);
                return sequence;
            }
            throw new SBOLValidationException(e.getMessage(), new Identified[0]);
        }
    }

    static void read(SBOLDocument doc, String stringBuffer, String URIprefix, String version, URI encoding) throws SBOLValidationException, IOException {
        Sequence sequence;
        String displayId;
        String strLine;
        nextLine = null;
        StringBuilder sbSequence = new StringBuilder();
        String elements = null;
        String description = "";
        boolean sequenceMode = false;
        BufferedReader br = new BufferedReader(new StringReader(stringBuffer));
        while ((strLine = FASTA.readFASTALine(br)) != null) {
            if ((strLine = strLine.trim()).startsWith(">")) {
                if (sequenceMode) {
                    sequenceMode = false;
                    if (description.contains(":")) {
                        displayId = description.substring(0, description.indexOf(":")).trim();
                        description = description.substring(description.indexOf(":") + 1).trim();
                    } else {
                        displayId = description;
                    }
                    displayId = URIcompliance.fixDisplayId(displayId);
                    sequence = FASTA.createSequence(doc, URIprefix, displayId, version, sbSequence.toString(), encoding);
                    sequence.setDescription(description);
                    description = "";
                    sbSequence = new StringBuilder();
                }
                description = description + strLine.replaceFirst(">", "").trim();
                continue;
            }
            if (strLine.startsWith(";")) {
                if (sequenceMode) {
                    sequenceMode = false;
                    if (description.contains(":")) {
                        displayId = description.substring(0, description.indexOf(":")).trim();
                        description = description.substring(description.indexOf(":") + 1).trim();
                    } else {
                        displayId = description;
                    }
                    displayId = URIcompliance.fixDisplayId(displayId);
                    sequence = FASTA.createSequence(doc, URIprefix, displayId, version, sbSequence.toString(), encoding);
                    sequence.setDescription(description);
                    description = "";
                    sbSequence = new StringBuilder();
                }
                description = description + strLine.replaceFirst(";", "").trim();
                continue;
            }
            sequenceMode = true;
            if (elements == null) {
                elements = new String("");
            }
            String[] strSplit = strLine.split(" ");
            for (int i = 0; i < strSplit.length; ++i) {
                sbSequence.append(strSplit[i]);
            }
        }
        if (description.contains(":")) {
            displayId = description.substring(0, description.indexOf(":")).trim();
            description = description.substring(description.indexOf(":") + 1).trim();
        } else {
            displayId = description;
        }
        displayId = URIcompliance.fixDisplayId(displayId);
        sequence = FASTA.createSequence(doc, URIprefix, displayId, version, sbSequence.toString(), encoding);
        sequence.setDescription(description);
        br.close();
    }
}

