/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.ComponentInstance;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class FunctionalComponent
extends ComponentInstance {
    private DirectionType direction;
    private HashMap<URI, MapsTo> mapsTos;
    private ModuleDefinition moduleDefinition = null;

    FunctionalComponent(URI identity, AccessType access, URI definitionURI, DirectionType direction) throws SBOLValidationException {
        super(identity, access, definitionURI);
        this.mapsTos = new HashMap();
        this.setDirection(direction);
    }

    private FunctionalComponent(FunctionalComponent functionalComponent) throws SBOLValidationException {
        super(functionalComponent);
        this.setDirection(functionalComponent.getDirection());
        this.mapsTos = new HashMap();
        if (!functionalComponent.getMapsTos().isEmpty()) {
            HashSet<MapsTo> mapsTos = new HashSet<MapsTo>();
            for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                mapsTos.add(mapsTo.deepCopy());
            }
            this.setMapsTos(mapsTos);
        }
    }

    void copy(FunctionalComponent functionalComponent) throws SBOLValidationException {
        this.copy((ComponentInstance)functionalComponent);
        this.mapsTos = new HashMap();
        if (!functionalComponent.getMapsTos().isEmpty()) {
            for (MapsTo mapsTo : functionalComponent.getMapsTos()) {
                String displayId = mapsTo.getDisplayId();
                if (displayId == null) {
                    displayId = URIcompliance.extractDisplayId(mapsTo.getIdentity());
                }
                MapsTo newMapsTo = this.createMapsTo(displayId, mapsTo.getRefinement(), mapsTo.getLocal().getDisplayId(), mapsTo.getRemoteURI());
                newMapsTo.copy(mapsTo);
            }
        }
    }

    public DirectionType getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionType direction) throws SBOLValidationException {
        if (direction == null) {
            throw new SBOLValidationException("sbol-11802", this);
        }
        this.direction = direction;
    }

    @Override
    public void setDefinition(URI definition) throws SBOLValidationException {
        if (this.getSBOLDocument() != null) {
            ComponentDefinition cd = this.getSBOLDocument().getComponentDefinition(definition);
            if (this.getSBOLDocument().isComplete() && cd == null) {
                throw new SBOLValidationException("sbol-10604", this);
            }
        }
        super.setDefinition(definition);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + (this.mapsTos == null ? 0 : this.mapsTos.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionalComponent other = (FunctionalComponent)obj;
        if (this.direction != other.direction) {
            return false;
        }
        return !(this.mapsTos == null ? other.mapsTos != null : !this.mapsTos.equals(other.mapsTos));
    }

    @Override
    FunctionalComponent deepCopy() throws SBOLValidationException {
        return new FunctionalComponent(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        for (MapsTo mapsTo : this.getMapsTos()) {
            mapsTo.updateCompliantURI(this.getPersistentIdentity().toString(), mapsTo.getDisplayId(), version);
            this.removeChildSafely(mapsTo, this.mapsTos);
            this.addMapsTo(mapsTo);
            String localId = URIcompliance.extractDisplayId(mapsTo.getLocalURI());
            mapsTo.setLocal(URIcompliance.createCompliantURI(URIprefix, localId, version));
        }
    }

    private MapsTo createMapsTo(URI identity, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        MapsTo mapping = new MapsTo(identity, refinement, local, remote);
        this.addMapsTo(mapping);
        return mapping;
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, String remoteId) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.moduleDefinition.getPersistentIdentity().toString(), localId, this.moduleDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(localURI) == null) {
            this.moduleDefinition.createFunctionalComponent(localId, AccessType.PUBLIC, localId, "", DirectionType.INOUT);
        }
        URI remoteURI = URIcompliance.createCompliantURI(this.getDefinition().getPersistentIdentity().toString(), remoteId, this.getDefinition().getVersion());
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    MapsTo createMapsTo(String displayId, RefinementType refinement, String localId, URI remoteURI) throws SBOLValidationException {
        URI localURI = URIcompliance.createCompliantURI(this.moduleDefinition.getPersistentIdentity().toString(), localId, this.moduleDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(localURI) == null) {
            this.moduleDefinition.createFunctionalComponent(localId, AccessType.PUBLIC, localId, "", DirectionType.INOUT);
        }
        return this.createMapsTo(displayId, refinement, localURI, remoteURI);
    }

    public MapsTo createMapsTo(String displayId, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        String parentPersistentIdStr = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        MapsTo m = this.createMapsTo(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, version), refinement, local, remote);
        m.setPersistentIdentity(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, ""));
        m.setDisplayId(displayId);
        m.setVersion(version);
        return m;
    }

    private void addMapsTo(MapsTo mapsTo) throws SBOLValidationException {
        mapsTo.setSBOLDocument(this.getSBOLDocument());
        mapsTo.setModuleDefinition(this.moduleDefinition);
        mapsTo.setComponentInstance(this);
        if (this.getSBOLDocument() != null && this.moduleDefinition.getFunctionalComponent(mapsTo.getLocalURI()) == null) {
            throw new SBOLValidationException("sbol-10804", mapsTo);
        }
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isComplete()) {
            if (this.getDefinition().getComponent(mapsTo.getRemoteURI()) == null) {
                throw new SBOLValidationException("sbol-10808", mapsTo);
            }
            if (this.getDefinition().getComponent(mapsTo.getRemoteURI()).getAccess().equals((Object)AccessType.PRIVATE)) {
                throw new SBOLValidationException("sbol-10807", mapsTo);
            }
            if (mapsTo.getRefinement().equals((Object)RefinementType.VERIFYIDENTICAL) && !mapsTo.getLocal().getDefinitionURI().equals(mapsTo.getRemote().getDefinitionURI())) {
                throw new SBOLValidationException("sbol-10811", mapsTo);
            }
        }
        this.addChildSafely(mapsTo, this.mapsTos, "mapsTo", new Map[0]);
    }

    public boolean removeMapsTo(MapsTo mapsTo) {
        return this.removeChildSafely(mapsTo, this.mapsTos);
    }

    public MapsTo getMapsTo(String displayId) {
        try {
            return this.mapsTos.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public MapsTo getMapsTo(URI mapsToURI) {
        return this.mapsTos.get(mapsToURI);
    }

    public Set<MapsTo> getMapsTos() {
        return new HashSet<MapsTo>(this.mapsTos.values());
    }

    public void clearMapsTos() {
        Object[] valueSetArray;
        for (Object mapsTo : valueSetArray = this.mapsTos.values().toArray()) {
            this.removeMapsTo((MapsTo)mapsTo);
        }
    }

    void setMapsTos(Set<MapsTo> mapsTos) throws SBOLValidationException {
        this.clearMapsTos();
        for (MapsTo reference : mapsTos) {
            this.addMapsTo(reference);
        }
    }

    void setModuleDefinition(ModuleDefinition moduleDefinition) {
        this.moduleDefinition = moduleDefinition;
    }

    @Override
    public String toString() {
        return "FunctionalComponent [" + super.toString() + ", direction=" + (Object)((Object)this.direction) + "]";
    }
}

