/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.Location;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.SBOLConversionException;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceOntology;
import org.sbolstandard.core2.URIcompliance;

class GenBank {
    private static SequenceOntology so = null;
    public static final String GBPREFIX = "genbank";
    public static final String GBNAMESPACE = "http://www.ncbi.nlm.nih.gov/genbank#";
    public static final String LOCUS = "locus";
    public static final String MOLECULE = "molecule";
    public static final String TOPOLOGY = "topology";
    public static final String DIVISION = "division";
    public static final String DATE = "date";
    public static final String GINUMBER = "GInumber";
    public static final String KEYWORDS = "keywords";
    public static final String SOURCE = "source";
    public static final String ORGANISM = "organism";
    public static final String REFERENCE = "reference";
    public static final String NESTEDREFERENCE = "Reference";
    public static final String LABEL = "label";
    public static final String AUTHORS = "authors";
    public static final String TITLE = "title";
    public static final String JOURNAL = "journal";
    public static final String MEDLINE = "medline";
    public static final String PUBMED = "pubmed";
    public static final String COMMENT = "comment";
    public static final String BASECOUNT = "baseCount";
    public static final String GBCONVPREFIX = "gbConv";
    public static final String GBCONVNAMESPACE = "http://sbols.org/genBankConversion#";
    public static final String POSITION = "position";
    public static final String STRADLESORIGIN = "stradlesOrigin";
    public static final String STARTLESSTHAN = "startLessThan";
    public static final String ENDGREATERTHAN = "endGreaterThan";
    public static final String SINGLEBASERANGE = "singleBaseRange";
    public static final String MULTIRANGETYPE = "multiRangeType";
    private static String nextLine = null;
    private static boolean featureMode = false;
    private static boolean originMode = false;

    GenBank() {
    }

    static boolean isGenBankFile(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream stream = new FileInputStream(file);
        BufferedInputStream buffer = new BufferedInputStream(stream);
        BufferedReader br = new BufferedReader(new InputStreamReader(buffer));
        String strLine = br.readLine();
        br.close();
        return GenBank.isGenBankString(strLine);
    }

    static boolean isGenBankString(String inputString) {
        return inputString != null && inputString.startsWith("LOCUS");
    }

    private static void writeGenBankLine(Writer w, String line, int margin, int indent) throws IOException {
        if (line.length() < margin) {
            w.write(line + "\n");
        } else {
            String spaces = "";
            for (int i = 0; i < indent; ++i) {
                spaces = spaces + " ";
            }
            int breakPos = line.substring(0, margin - 1).lastIndexOf(" ") + 1;
            if (breakPos == 0 || (double)breakPos < 0.75 * (double)margin) {
                breakPos = margin - 1;
            }
            w.write(line.substring(0, breakPos) + "\n");
            for (int i = breakPos; i < line.length(); i += breakPos) {
                if (i + (margin - indent) < line.length()) {
                    breakPos = line.substring(i, i + (margin - indent) - 1).lastIndexOf(" ") + 1;
                    if (breakPos == 0 || (double)breakPos < 0.65 * (double)margin) {
                        breakPos = margin - indent - 1;
                    }
                    w.write(spaces + line.substring(i, i + breakPos) + "\n");
                    continue;
                }
                w.write(spaces + line.substring(i) + "\n");
                breakPos = margin - indent - 1;
            }
        }
    }

    private static void writeComponentDefinition(ComponentDefinition componentDefinition, Writer w) throws IOException, SBOLConversionException {
        so = new SequenceOntology();
        Sequence seq = null;
        for (Sequence sequence : componentDefinition.getSequences()) {
            if (!sequence.getEncoding().equals(Sequence.IUPAC_DNA) && !sequence.getEncoding().equals(Sequence.IUPAC_RNA)) continue;
            seq = sequence;
            break;
        }
        if (seq == null) {
            throw new SBOLConversionException("ComponentDefintion " + componentDefinition.getIdentity() + " does not have an IUPAC sequence.");
        }
        int size = seq.getElements().length();
        GenBank.writeHeader(w, componentDefinition, size);
        GenBank.writeReferences(w, componentDefinition);
        GenBank.writeComment(w, componentDefinition);
        w.write("FEATURES             Location/Qualifiers\n");
        GenBank.recurseComponentDefinition(componentDefinition, w, 0, true, 0);
        w.write("ORIGIN\n");
        GenBank.writeSequence(w, seq, size);
        w.write("//\n");
    }

    private static void write(ComponentDefinition componentDefinition, Writer w) throws IOException, SBOLConversionException {
        GenBank.writeComponentDefinition(componentDefinition, w);
    }

    static void write(SBOLDocument sbolDocument, OutputStream out) throws IOException, SBOLConversionException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
        for (ComponentDefinition componentDefinition : sbolDocument.getRootComponentDefinitions()) {
            GenBank.write(componentDefinition, w);
        }
        ((Writer)w).close();
    }

    private static String convertSOtoGenBank(String soTerm) {
        if (soTerm.equals("SO:0001023")) {
            return String.format("%-15s", "allele");
        }
        if (soTerm.equals("SO:0000140")) {
            return String.format("%-15s", "attenuator");
        }
        if (soTerm.equals("SO:0001834")) {
            return String.format("%-15s", "C_region");
        }
        if (soTerm.equals("SO:0000172")) {
            return String.format("%-15s", "CAAT_signal");
        }
        if (soTerm.equals("SO:0000316")) {
            return String.format("%-15s", "CDS");
        }
        if (soTerm.equals("SO:0000297")) {
            return String.format("%-15s", "D-loop");
        }
        if (soTerm.equals("SO:0000458")) {
            return String.format("%-15s", "D_segment");
        }
        if (soTerm.equals("SO:0000165")) {
            return String.format("%-15s", "enhancer");
        }
        if (soTerm.equals("SO:0000147")) {
            return String.format("%-15s", "exon");
        }
        if (soTerm.equals("SO:0000704")) {
            return String.format("%-15s", "gene");
        }
        if (soTerm.equals("SO:0000173")) {
            return String.format("%-15s", "GC_signal");
        }
        if (soTerm.equals("SO:0000723")) {
            return String.format("%-15s", "iDNA");
        }
        if (soTerm.equals("SO:0000188")) {
            return String.format("%-15s", "intron");
        }
        if (soTerm.equals("SO:0000470")) {
            return String.format("%-15s", "J_region");
        }
        if (soTerm.equals("SO:0000286")) {
            return String.format("%-15s", "LTR");
        }
        if (soTerm.equals("SO:0000419")) {
            return String.format("%-15s", "mat_peptide");
        }
        if (soTerm.equals("SO:0000409")) {
            return String.format("%-15s", "misc_binding");
        }
        if (soTerm.equals("SO:0000413")) {
            return String.format("%-15s", "misc_difference");
        }
        if (soTerm.equals("SO:0000001")) {
            return String.format("%-15s", "misc_feature");
        }
        if (soTerm.equals("SO:0001645")) {
            return String.format("%-15s", "misc_marker");
        }
        if (soTerm.equals("SO:0000298")) {
            return String.format("%-15s", "misc_recomb");
        }
        if (soTerm.equals("SO:0000233")) {
            return String.format("%-15s", "misc_RNA");
        }
        if (soTerm.equals("SO:0001411")) {
            return String.format("%-15s", "misc_signal");
        }
        if (soTerm.equals("SO:0005836")) {
            return String.format("%-15s", "regulatory");
        }
        if (soTerm.equals("SO:0000002")) {
            return String.format("%-15s", "misc_structure");
        }
        if (soTerm.equals("SO:0000305")) {
            return String.format("%-15s", "modified_base");
        }
        if (soTerm.equals("SO:0000234")) {
            return String.format("%-15s", "mRNA");
        }
        if (soTerm.equals("SO:0001835")) {
            return String.format("%-15s", "N_region");
        }
        if (soTerm.equals("SO:0000551")) {
            return String.format("%-15s", "polyA_signal");
        }
        if (soTerm.equals("SO:0000553")) {
            return String.format("%-15s", "polyA_site");
        }
        if (soTerm.equals("SO:0000185")) {
            return String.format("%-15s", "precursor_RNA");
        }
        if (soTerm.equals("SO:0000185")) {
            return String.format("%-15s", "prim_transcript");
        }
        if (soTerm.equals("SO:0000112")) {
            return String.format("%-15s", "primer");
        }
        if (soTerm.equals("SO:0005850")) {
            return String.format("%-15s", "primer_bind");
        }
        if (soTerm.equals("SO:0000167")) {
            return String.format("%-15s", "promoter");
        }
        if (soTerm.equals("SO:0000410")) {
            return String.format("%-15s", "protein_bind");
        }
        if (soTerm.equals("SO:0000139") || soTerm.equals("SO:0000552")) {
            return String.format("%-15s", "RBS");
        }
        if (soTerm.equals("SO:0000296")) {
            return String.format("%-15s", "rep_origin");
        }
        if (soTerm.equals("SO:0000657")) {
            return String.format("%-15s", "repeat_region");
        }
        if (soTerm.equals("SO:0000726")) {
            return String.format("%-15s", "repeat_unit");
        }
        if (soTerm.equals("SO:0000252")) {
            return String.format("%-15s", "rRNA");
        }
        if (soTerm.equals("SO:0001836")) {
            return String.format("%-15s", "S_region");
        }
        if (soTerm.equals("SO:0000005")) {
            return String.format("%-15s", "satellite");
        }
        if (soTerm.equals("SO:0000013")) {
            return String.format("%-15s", "scRNA");
        }
        if (soTerm.equals("SO:0000418")) {
            return String.format("%-15s", "sig_peptide");
        }
        if (soTerm.equals("SO:0000274")) {
            return String.format("%-15s", "snRNA");
        }
        if (soTerm.equals("SO:0000149")) {
            return String.format("%-15s", SOURCE);
        }
        if (soTerm.equals("SO:0000019")) {
            return String.format("%-15s", "stem_loop");
        }
        if (soTerm.equals("SO:0000331")) {
            return String.format("%-15s", "STS");
        }
        if (soTerm.equals("SO:0000174")) {
            return String.format("%-15s", "TATA_signal");
        }
        if (soTerm.equals("SO:0000141")) {
            return String.format("%-15s", "terminator");
        }
        if (soTerm.equals("SO:0000725")) {
            return String.format("%-15s", "transit_peptide");
        }
        if (soTerm.equals("SO:0001054")) {
            return String.format("%-15s", "transposon");
        }
        if (soTerm.equals("SO:0000253")) {
            return String.format("%-15s", "tRNA");
        }
        if (soTerm.equals("SO:0001833")) {
            return String.format("%-15s", "V_region");
        }
        if (soTerm.equals("SO:0001060")) {
            return String.format("%-15s", "variation");
        }
        if (soTerm.equals("SO:0000175")) {
            return String.format("%-15s", "-10_signal");
        }
        if (soTerm.equals("SO:0000176")) {
            return String.format("%-15s", "-35_signal");
        }
        if (soTerm.equals("SO:0000557")) {
            return String.format("%-15s", "3'clip");
        }
        if (soTerm.equals("SO:0000205")) {
            return String.format("%-15s", "3'UTR");
        }
        if (soTerm.equals("SO:0000555")) {
            return String.format("%-15s", "5'clip");
        }
        if (soTerm.equals("SO:0000204")) {
            return String.format("%-15s", "5'UTR");
        }
        return "misc_feature   ";
    }

    private static URI convertGenBanktoSO(String genBankTerm) {
        if (genBankTerm.equals("allele")) {
            return so.getURIbyId("SO:0001023");
        }
        if (genBankTerm.equals("attenuator")) {
            return so.getURIbyId("SO:0000140");
        }
        if (genBankTerm.equals("C_region")) {
            return so.getURIbyId("SO:0001834");
        }
        if (genBankTerm.equals("CAAT_signal")) {
            return so.getURIbyId("SO:0000172");
        }
        if (genBankTerm.equals("CDS")) {
            return so.getURIbyId("SO:0000316");
        }
        if (genBankTerm.equals("D-loop")) {
            return so.getURIbyId("SO:0000297");
        }
        if (genBankTerm.equals("D_segment")) {
            return so.getURIbyId("SO:0000458");
        }
        if (genBankTerm.equals("enhancer")) {
            return so.getURIbyId("SO:0000165");
        }
        if (genBankTerm.equals("exon")) {
            return so.getURIbyId("SO:0000147");
        }
        if (genBankTerm.equals("gene")) {
            return so.getURIbyId("SO:0000704");
        }
        if (genBankTerm.equals("GC_signal")) {
            return so.getURIbyId("SO:0000173");
        }
        if (genBankTerm.equals("iDNA")) {
            return so.getURIbyId("SO:0000723");
        }
        if (genBankTerm.equals("intron")) {
            return so.getURIbyId("SO:0000188");
        }
        if (genBankTerm.equals("J_region")) {
            return so.getURIbyId("SO:0000470");
        }
        if (genBankTerm.equals("LTR")) {
            return so.getURIbyId("SO:0000286");
        }
        if (genBankTerm.equals("mat_peptide")) {
            return so.getURIbyId("SO:0000419");
        }
        if (genBankTerm.equals("misc_binding")) {
            return so.getURIbyId("SO:0000409");
        }
        if (genBankTerm.equals("misc_difference")) {
            return so.getURIbyId("SO:0000413");
        }
        if (genBankTerm.equals("misc_feature")) {
            return so.getURIbyId("SO:0000001");
        }
        if (genBankTerm.equals("misc_marker")) {
            return so.getURIbyId("SO:0001645");
        }
        if (genBankTerm.equals("misc_recomb")) {
            return so.getURIbyId("SO:0000298");
        }
        if (genBankTerm.equals("misc_RNA")) {
            return so.getURIbyId("SO:0000233");
        }
        if (genBankTerm.equals("misc_signal")) {
            return so.getURIbyId("SO:0001411");
        }
        if (genBankTerm.equals("misc_structure")) {
            return so.getURIbyId("SO:0000002");
        }
        if (genBankTerm.equals("modified_base")) {
            return so.getURIbyId("SO:0000305");
        }
        if (genBankTerm.equals("mRNA")) {
            return so.getURIbyId("SO:0000234");
        }
        if (genBankTerm.equals("N_region")) {
            return so.getURIbyId("SO:0001835");
        }
        if (genBankTerm.equals("polyA_signal")) {
            return so.getURIbyId("SO:0000551");
        }
        if (genBankTerm.equals("polyA_site")) {
            return so.getURIbyId("SO:0000553");
        }
        if (genBankTerm.equals("precursor_RNA")) {
            return so.getURIbyId("SO:0000185");
        }
        if (genBankTerm.equals("prim_transcript")) {
            return so.getURIbyId("SO:0000185");
        }
        if (genBankTerm.equals("primer")) {
            return so.getURIbyId("SO:0000112");
        }
        if (genBankTerm.equals("primer_bind")) {
            return so.getURIbyId("SO:0005850");
        }
        if (genBankTerm.equals("promoter")) {
            return so.getURIbyId("SO:0000167");
        }
        if (genBankTerm.equals("protein_bind")) {
            return so.getURIbyId("SO:0000410");
        }
        if (genBankTerm.equals("RBS")) {
            return so.getURIbyId("SO:0000139");
        }
        if (genBankTerm.equals("rep_origin")) {
            return so.getURIbyId("SO:0000296");
        }
        if (genBankTerm.equals("repeat_region")) {
            return so.getURIbyId("SO:0000657");
        }
        if (genBankTerm.equals("repeat_unit")) {
            return so.getURIbyId("SO:0000726");
        }
        if (genBankTerm.equals("rRNA")) {
            return so.getURIbyId("SO:0000252");
        }
        if (genBankTerm.equals("S_region")) {
            return so.getURIbyId("SO:0001836");
        }
        if (genBankTerm.equals("satellite")) {
            return so.getURIbyId("SO:0000005");
        }
        if (genBankTerm.equals("scRNA")) {
            return so.getURIbyId("SO:0000013");
        }
        if (genBankTerm.equals("sig_peptide")) {
            return so.getURIbyId("SO:0000418");
        }
        if (genBankTerm.equals("snRNA")) {
            return so.getURIbyId("SO:0000274");
        }
        if (genBankTerm.equals(SOURCE)) {
            return so.getURIbyId("SO:0000149");
        }
        if (genBankTerm.equals("stem_loop")) {
            return so.getURIbyId("SO:0000019");
        }
        if (genBankTerm.equals("STS")) {
            return so.getURIbyId("SO:0000331");
        }
        if (genBankTerm.equals("TATA_signal")) {
            return so.getURIbyId("SO:0000174");
        }
        if (genBankTerm.equals("terminator")) {
            return so.getURIbyId("SO:0000141");
        }
        if (genBankTerm.equals("transit_peptide")) {
            return so.getURIbyId("SO:0000725");
        }
        if (genBankTerm.equals("transposon")) {
            return so.getURIbyId("SO:0001054");
        }
        if (genBankTerm.equals("tRNA")) {
            return so.getURIbyId("SO:0000253");
        }
        if (genBankTerm.equals("V_region")) {
            return so.getURIbyId("SO:0001833");
        }
        if (genBankTerm.equals("variation")) {
            return so.getURIbyId("SO:0001060");
        }
        if (genBankTerm.equals("-10_signal")) {
            return so.getURIbyId("SO:0000175");
        }
        if (genBankTerm.equals("-35_signal")) {
            return so.getURIbyId("SO:0000176");
        }
        if (genBankTerm.equals("3'clip")) {
            return so.getURIbyId("SO:0000557");
        }
        if (genBankTerm.equals("3'UTR")) {
            return so.getURIbyId("SO:0000205");
        }
        if (genBankTerm.equals("5'clip")) {
            return so.getURIbyId("SO:0000555");
        }
        if (genBankTerm.equals("5'UTR")) {
            return so.getURIbyId("SO:0000204");
        }
        if (genBankTerm.equals("regulatory")) {
            return so.getURIbyId("SO:0005836");
        }
        if (genBankTerm.equals("snoRNA")) {
            return so.getURIbyId("SO:0000275");
        }
        return null;
    }

    private static void writeHeader(Writer w, ComponentDefinition componentDefinition, int size) throws SBOLConversionException, IOException {
        String locus = componentDefinition.getDisplayId().substring(0, componentDefinition.getDisplayId().length() > 15 ? 15 : componentDefinition.getDisplayId().length());
        Annotation annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, LOCUS, GBPREFIX));
        if (annotation != null) {
            locus = annotation.getStringValue();
        }
        String type = null;
        for (URI typeURI : componentDefinition.getTypes()) {
            if (typeURI.equals(ComponentDefinition.RNA)) {
                type = "RNA";
                break;
            }
            if (!typeURI.equals(ComponentDefinition.DNA)) continue;
            type = "DNA";
        }
        if (type == null) {
            throw new SBOLConversionException("ComponentDefintion " + componentDefinition.getIdentity() + " is not DNA or RNA type.");
        }
        annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, MOLECULE, GBPREFIX));
        if (annotation != null) {
            type = annotation.getStringValue();
        }
        String linCirc = "linear";
        annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, TOPOLOGY, GBPREFIX));
        if (annotation != null) {
            linCirc = annotation.getStringValue();
        }
        if (componentDefinition.containsType(SequenceOntology.CIRCULAR)) {
            linCirc = "circular";
        }
        if (componentDefinition.containsType(SequenceOntology.LINEAR)) {
            linCirc = "linear";
        }
        String division = "UNK";
        annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, DIVISION, GBPREFIX));
        if (annotation != null) {
            division = annotation.getStringValue();
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date dateobj = new Date();
        String date = df.format(dateobj);
        annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, DATE, GBPREFIX));
        if (annotation != null) {
            date = annotation.getStringValue();
        }
        String locusLine = "LOCUS       " + String.format("%-16s", locus) + " " + String.format("%11s", "" + size) + " bp    " + String.format("%-6s", type) + "  " + String.format("%-8s", linCirc) + " " + division + " " + date + "\n";
        w.write(locusLine);
        if (componentDefinition.isSetDescription()) {
            GenBank.writeGenBankLine(w, "DEFINITION  " + componentDefinition.getDescription(), 80, 12);
        }
        w.write("ACCESSION   " + componentDefinition.getDisplayId() + "\n");
        if (componentDefinition.isSetVersion()) {
            String giNumber = "";
            annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, GINUMBER, GBPREFIX));
            if (annotation != null) {
                giNumber = annotation.getStringValue();
            }
            w.write("VERSION     " + componentDefinition.getDisplayId() + "." + componentDefinition.getVersion() + "  " + giNumber + "\n");
        }
        if ((annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, KEYWORDS, GBPREFIX))) != null) {
            w.write("KEYWORDS    " + annotation.getStringValue() + "\n");
        }
        if ((annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, SOURCE, GBPREFIX))) != null) {
            w.write("SOURCE      " + annotation.getStringValue() + "\n");
        }
        if ((annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, ORGANISM, GBPREFIX))) != null) {
            GenBank.writeGenBankLine(w, "  ORGANISM  " + annotation.getStringValue(), 80, 12);
        }
    }

    private static void writeReferences(Writer w, ComponentDefinition componentDefinition) throws IOException {
        for (Annotation a : componentDefinition.getAnnotations()) {
            if (!a.getQName().equals(new QName(GBNAMESPACE, REFERENCE, GBPREFIX))) continue;
            String label = null;
            String authors = null;
            String title = null;
            String journal = null;
            String medline = null;
            String pubmed = null;
            for (Annotation ref : a.getAnnotations()) {
                if (ref.getQName().equals(new QName(GBNAMESPACE, LABEL, GBPREFIX))) {
                    label = ref.getStringValue();
                    continue;
                }
                if (ref.getQName().equals(new QName(GBNAMESPACE, AUTHORS, GBPREFIX))) {
                    authors = ref.getStringValue();
                    continue;
                }
                if (ref.getQName().equals(new QName(GBNAMESPACE, TITLE, GBPREFIX))) {
                    title = ref.getStringValue();
                    continue;
                }
                if (ref.getQName().equals(new QName(GBNAMESPACE, JOURNAL, GBPREFIX))) {
                    journal = ref.getStringValue();
                    continue;
                }
                if (ref.getQName().equals(new QName(GBNAMESPACE, MEDLINE, GBPREFIX))) {
                    medline = ref.getStringValue();
                    continue;
                }
                if (!ref.getQName().equals(new QName(GBNAMESPACE, PUBMED, GBPREFIX))) continue;
                pubmed = ref.getStringValue();
            }
            if (label == null) continue;
            GenBank.writeGenBankLine(w, "REFERENCE   " + label, 80, 12);
            if (authors != null) {
                GenBank.writeGenBankLine(w, "  AUTHORS   " + authors, 80, 12);
            }
            if (title != null) {
                GenBank.writeGenBankLine(w, "  TITLE     " + title, 80, 12);
            }
            if (journal != null) {
                GenBank.writeGenBankLine(w, "  JOURNAL   " + journal, 80, 12);
            }
            if (medline != null) {
                GenBank.writeGenBankLine(w, "   MEDLINE  " + medline, 80, 12);
            }
            if (pubmed == null) continue;
            GenBank.writeGenBankLine(w, "   PUBMED   " + pubmed, 80, 12);
        }
    }

    private static void writeComment(Writer w, ComponentDefinition componentDefinition) throws IOException {
        Annotation annotation = componentDefinition.getAnnotation(new QName(GBNAMESPACE, COMMENT, GBPREFIX));
        if (annotation != null) {
            GenBank.writeGenBankLine(w, "COMMENT     " + annotation.getStringValue(), 80, 12);
        }
    }

    private static String locationStr(Location location, int offset, boolean complement, Location location2) throws SBOLConversionException {
        Cut cut;
        int end;
        int start;
        Range range;
        String locationStr = "";
        boolean isCut = false;
        if (location instanceof Range) {
            range = (Range)location;
            start = offset + range.getStart();
            end = offset + range.getEnd();
        } else if (location instanceof Cut) {
            cut = (Cut)location;
            start = offset + cut.getAt();
            end = offset + cut.getAt() + 1;
            isCut = true;
        } else {
            throw new SBOLConversionException("Location " + location.getIdentity() + " is not range or cut.");
        }
        if (location2 != null) {
            if (location2 instanceof Range) {
                range = (Range)location2;
                end = offset + range.getEnd();
            } else if (location2 instanceof Cut) {
                cut = (Cut)location2;
                end = offset + cut.getAt() + 1;
            }
        }
        if (complement) {
            locationStr = locationStr + "complement(";
        }
        if (location.getAnnotation(new QName(GBCONVNAMESPACE, STARTLESSTHAN, GBCONVPREFIX)) != null) {
            locationStr = locationStr + "<";
        }
        locationStr = locationStr + start;
        locationStr = isCut ? locationStr + "^" : (location.getAnnotation(new QName(GBCONVNAMESPACE, SINGLEBASERANGE, GBCONVPREFIX)) != null ? locationStr + "." : locationStr + "..");
        if (location.getAnnotation(new QName(GBCONVNAMESPACE, ENDGREATERTHAN, GBCONVPREFIX)) != null) {
            locationStr = locationStr + ">";
        }
        locationStr = locationStr + end;
        if (complement) {
            locationStr = locationStr + ")";
        }
        return locationStr;
    }

    private static boolean stradlesOrigin(SequenceAnnotation sa) {
        Annotation annotation = sa.getAnnotation(new QName(GBCONVNAMESPACE, STRADLESORIGIN, GBCONVPREFIX));
        return annotation != null;
    }

    private static void writeFeature(Writer w, SequenceAnnotation sa, String role, int offset, boolean inline) throws IOException, SBOLConversionException {
        Location loc;
        if (sa.getPreciseLocations().size() == 0) {
            throw new SBOLConversionException("SequenceAnnotation " + sa.getIdentity() + " has no range/cut locations.");
        }
        if (sa.getPreciseLocations().size() == 1) {
            loc = sa.getPreciseLocations().iterator().next();
            boolean locReverse = false;
            if (loc.isSetOrientation()) {
                locReverse = loc.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT);
            }
            w.write("     " + role + " " + GenBank.locationStr(loc, offset, inline && locReverse || !inline && !locReverse, null) + "\n");
        } else if (GenBank.stradlesOrigin(sa)) {
            loc = sa.getLocation("range0");
            Location loc2 = sa.getLocation("range1");
            boolean locReverse = false;
            if (loc.isSetOrientation()) {
                locReverse = loc.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT);
            }
            w.write("     " + role + " " + GenBank.locationStr(loc, offset, inline && locReverse || !inline && !locReverse, loc2) + "\n");
        } else {
            String multiType = "join";
            Annotation annotation = sa.getAnnotation(new QName(GBNAMESPACE, MULTIRANGETYPE, GBCONVPREFIX));
            if (annotation != null) {
                multiType = annotation.getStringValue();
            }
            String rangeStr = "     " + role + " " + multiType + "(";
            boolean first = true;
            for (Location loc2 : sa.getSortedLocations()) {
                if (!first) {
                    rangeStr = rangeStr + ",";
                } else {
                    first = false;
                }
                boolean locReverse = false;
                if (loc2.isSetOrientation()) {
                    locReverse = loc2.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT);
                }
                rangeStr = rangeStr + GenBank.locationStr(loc2, offset, inline && locReverse || !inline && !locReverse, null);
            }
            rangeStr = rangeStr + ")";
            GenBank.writeGenBankLine(w, rangeStr, 80, 21);
        }
        for (Annotation a : sa.getAnnotations()) {
            if (a.getQName().getLocalPart().equals(MULTIRANGETYPE)) continue;
            if (a.isStringValue()) {
                try {
                    int aInt = Integer.parseInt(a.getStringValue());
                    GenBank.writeGenBankLine(w, "                     /" + a.getQName().getLocalPart() + "=" + aInt, 80, 21);
                }
                catch (NumberFormatException e) {
                    GenBank.writeGenBankLine(w, "                     /" + a.getQName().getLocalPart() + "=\"" + a.getStringValue() + "\"", 80, 21);
                }
                continue;
            }
            if (!a.isIntegerValue()) continue;
            GenBank.writeGenBankLine(w, "                     /" + a.getQName().getLocalPart() + "=" + a.getIntegerValue(), 80, 21);
        }
    }

    private static void writeSequence(Writer w, Sequence sequence, int size) throws IOException {
        for (int i = 0; i < size; i += 60) {
            String padded = String.format("%9s", "" + (i + 1));
            w.write(padded);
            for (int j = i; j < size && j < i + 60; j += 10) {
                if (j + 10 < size) {
                    w.write(" " + sequence.getElements().substring(j, j + 10));
                    continue;
                }
                w.write(" " + sequence.getElements().substring(j));
            }
            w.write("\n");
        }
    }

    private static int getFeatureStart(SequenceAnnotation sa) {
        int featureStart = Integer.MAX_VALUE;
        for (Location location : sa.getPreciseLocations()) {
            Cut cut;
            if (location instanceof Range) {
                Range range = (Range)location;
                if (range.getStart() >= featureStart) continue;
                featureStart = range.getStart();
                continue;
            }
            if (!(location instanceof Cut) || (cut = (Cut)location).getAt() >= featureStart) continue;
            featureStart = cut.getAt();
        }
        if (featureStart == Integer.MAX_VALUE) {
            return 1;
        }
        return featureStart;
    }

    private static int getFeatureEnd(SequenceAnnotation sa) {
        int featureEnd = 0;
        for (Location location : sa.getPreciseLocations()) {
            Cut cut;
            if (location instanceof Range) {
                Range range = (Range)location;
                if (range.getEnd() <= featureEnd) continue;
                featureEnd = range.getEnd();
                continue;
            }
            if (!(location instanceof Cut) || (cut = (Cut)location).getAt() >= featureEnd) continue;
            featureEnd = cut.getAt();
        }
        return featureEnd;
    }

    private static boolean isInlineFeature(SequenceAnnotation sa) {
        boolean inlineFeature = true;
        for (Location location : sa.getPreciseLocations()) {
            if (!location.isSetOrientation() || !location.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT)) continue;
            inlineFeature = false;
        }
        return inlineFeature;
    }

    private static void recurseComponentDefinition(ComponentDefinition componentDefinition, Writer w, int offset, boolean inline, int featureEnd) throws IOException, SBOLConversionException {
        for (SequenceAnnotation sa : componentDefinition.getSortedSequenceAnnotationsByDisplayId()) {
            String role;
            block6: {
                block5: {
                    role = "misc_feature   ";
                    Component comp = sa.getComponent();
                    if (comp == null) break block5;
                    ComponentDefinition compDef = comp.getDefinition();
                    if (compDef == null) break block6;
                    for (URI roleURI : compDef.getRoles()) {
                        String soRole = so.getId(roleURI);
                        if (soRole == null) continue;
                        role = GenBank.convertSOtoGenBank(so.getId(roleURI));
                        break;
                    }
                    int newFeatureEnd = featureEnd;
                    if (!GenBank.isInlineFeature(sa)) {
                        newFeatureEnd = GenBank.getFeatureEnd(sa);
                    }
                    GenBank.recurseComponentDefinition(compDef, w, offset + GenBank.getFeatureStart(sa) - 1, !(inline ^ GenBank.isInlineFeature(sa)), newFeatureEnd);
                    break block6;
                }
                for (URI roleURI : sa.getRoles()) {
                    String soRole = so.getId(roleURI);
                    if (soRole == null) continue;
                    role = GenBank.convertSOtoGenBank(so.getId(roleURI));
                    break;
                }
            }
            if (!inline) {
                GenBank.writeFeature(w, sa, role, featureEnd - (GenBank.getFeatureEnd(sa) + GenBank.getFeatureStart(sa) - 1) - offset, inline);
                continue;
            }
            GenBank.writeFeature(w, sa, role, offset, inline);
        }
    }

    private static String readGenBankLine(BufferedReader br) throws IOException {
        String newLine = "";
        if (nextLine == null) {
            newLine = br.readLine();
            if (newLine == null) {
                return null;
            }
            newLine = newLine.trim();
        } else {
            newLine = nextLine;
        }
        while ((nextLine = br.readLine()) != null) {
            nextLine = nextLine.trim();
            if (featureMode) {
                if (nextLine.startsWith("/")) {
                    return newLine;
                }
                String[] strSplit = nextLine.split("\\s+");
                URI role = GenBank.convertGenBanktoSO(strSplit[0]);
                if (role != null) {
                    return newLine;
                }
            }
            if (originMode) {
                return newLine;
            }
            if (nextLine.startsWith("DEFINITION")) {
                return newLine;
            }
            if (nextLine.startsWith("ACCESSION")) {
                return newLine;
            }
            if (nextLine.startsWith("VERSION")) {
                return newLine;
            }
            if (nextLine.startsWith("KEYWORDS")) {
                return newLine;
            }
            if (nextLine.startsWith("SOURCE")) {
                return newLine;
            }
            if (nextLine.startsWith("ORGANISM")) {
                return newLine;
            }
            if (nextLine.startsWith("REFERENCE")) {
                return newLine;
            }
            if (nextLine.startsWith("COMMENT")) {
                return newLine;
            }
            if (nextLine.startsWith("AUTHORS")) {
                return newLine;
            }
            if (nextLine.startsWith("TITLE")) {
                return newLine;
            }
            if (nextLine.startsWith("JOURNAL")) {
                return newLine;
            }
            if (nextLine.startsWith("MEDLINE")) {
                return newLine;
            }
            if (nextLine.startsWith("PUBMED")) {
                return newLine;
            }
            if (nextLine.startsWith("BASE COUNT")) {
                return newLine;
            }
            if (nextLine.startsWith("FEATURES")) {
                featureMode = true;
                return newLine;
            }
            if (nextLine.startsWith("ORIGIN")) {
                originMode = true;
                return newLine;
            }
            if (featureMode) {
                if (newLine.contains(" ") || nextLine.contains(" ")) {
                    newLine = newLine + " " + nextLine;
                    continue;
                }
                newLine = newLine + nextLine;
                continue;
            }
            newLine = newLine + " " + nextLine;
        }
        return newLine;
    }

    private static void createSubComponentDefinitions(SBOLDocument doc, ComponentDefinition topCD, URI type, String elements, String version) throws SBOLValidationException {
        for (SequenceAnnotation sa : topCD.getSequenceAnnotations()) {
            Range range;
            if (!sa.isSetComponent() || (range = (Range)sa.getLocation("range")) == null) continue;
            String subElements = elements.substring(range.getStart() - 1, range.getEnd()).toLowerCase();
            if (range.getOrientation().equals((Object)OrientationType.REVERSECOMPLEMENT)) {
                subElements = Sequence.reverseComplement(subElements, type);
            }
            ComponentDefinition subCompDef = sa.getComponent().getDefinition();
            String compDefId = subCompDef.getDisplayId();
            Sequence subSequence = doc.createSequence(compDefId + "_seq", version, subElements, Sequence.IUPAC_DNA);
            subCompDef.addSequence(subSequence);
        }
    }

    static void read(SBOLDocument doc, String stringBuffer, String URIPrefix) throws IOException, SBOLConversionException, SBOLValidationException {
        boolean cont;
        so = new SequenceOntology();
        doc.addNamespace(URI.create(GBNAMESPACE), GBPREFIX);
        doc.addNamespace(URI.create(GBCONVNAMESPACE), GBCONVPREFIX);
        BufferedReader br = new BufferedReader(new StringReader(stringBuffer));
        int featureCnt = 0;
        int refCnt = 0;
        nextLine = null;
        do {
            String strLine;
            cont = false;
            String id = "";
            String version = "";
            featureMode = false;
            originMode = false;
            StringBuilder sbSequence = new StringBuilder();
            String elements = null;
            String description = "";
            URI type = ComponentDefinition.DNA;
            ComponentDefinition topCD = null;
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            ArrayList<Annotation> nestedAnnotations = null;
            Annotation annotation = null;
            boolean circular = false;
            int baseCount = 0;
            while ((strLine = GenBank.readGenBankLine(br)) != null) {
                String annotationStr;
                int i;
                String[] strSplit;
                if ((strLine = strLine.trim()).startsWith("LOCUS")) {
                    strSplit = strLine.split("\\s+");
                    id = strSplit[1];
                    annotation = new Annotation(new QName(GBNAMESPACE, LOCUS, GBPREFIX), strSplit[1]);
                    annotations.add(annotation);
                    baseCount = Integer.parseInt(strSplit[2]);
                    if (strSplit[4].toUpperCase().contains("RNA")) {
                        type = ComponentDefinition.RNA;
                    }
                    annotation = new Annotation(new QName(GBNAMESPACE, MOLECULE, GBPREFIX), strSplit[4]);
                    annotations.add(annotation);
                    for (i = 5; i < strSplit.length; ++i) {
                        if (strSplit[i].startsWith("linear") || strSplit[i].startsWith("circular")) {
                            if (strSplit[i].startsWith("circular")) {
                                circular = true;
                            }
                        } else {
                            annotation = strSplit[i].length() == 3 ? new Annotation(new QName(GBNAMESPACE, DIVISION, GBPREFIX), strSplit[i]) : new Annotation(new QName(GBNAMESPACE, DATE, GBPREFIX), strSplit[i]);
                        }
                        annotations.add(annotation);
                    }
                    continue;
                }
                if (strLine.startsWith("DEFINITION")) {
                    description = strLine.replaceFirst("DEFINITION  ", "");
                    continue;
                }
                if (strLine.startsWith("ACCESSION")) {
                    String accession;
                    strSplit = strLine.split("\\s+");
                    id = accession = strSplit[1];
                    continue;
                }
                if (strLine.startsWith("VERSION")) {
                    strSplit = strLine.split("\\s+");
                    if (!(id = URIcompliance.fixDisplayId(id)).equals(URIcompliance.fixDisplayId(strSplit[1]))) {
                        String vId;
                        if (strSplit[1].split("\\.").length > 1) {
                            version = strSplit[1].split("\\.")[strSplit[1].split("\\.").length - 1];
                        }
                        if (!id.equals(vId = URIcompliance.fixDisplayId(strSplit[1].split("\\.")[0]))) {
                            throw new SBOLConversionException("Warning: id in version does not match id in accession");
                        }
                    }
                    if (strSplit.length <= 2) continue;
                    annotation = new Annotation(new QName(GBNAMESPACE, GINUMBER, GBPREFIX), strSplit[2]);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("KEYWORDS")) {
                    annotationStr = strLine.replace("KEYWORDS", "").trim();
                    annotation = new Annotation(new QName(GBNAMESPACE, KEYWORDS, GBPREFIX), annotationStr);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("SOURCE")) {
                    annotationStr = strLine.replace("SOURCE", "").trim();
                    annotation = new Annotation(new QName(GBNAMESPACE, SOURCE, GBPREFIX), annotationStr);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("ORGANISM")) {
                    annotationStr = strLine.replace("ORGANISM", "").trim();
                    annotation = new Annotation(new QName(GBNAMESPACE, ORGANISM, GBPREFIX), annotationStr);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("REFERENCE")) {
                    annotationStr = strLine.replace("REFERENCE", "").trim();
                    nestedAnnotations = new ArrayList<Annotation>();
                    Annotation labelAnnotation = new Annotation(new QName(GBNAMESPACE, LABEL, GBPREFIX), annotationStr);
                    nestedAnnotations.add(labelAnnotation);
                    URI nestedURI = URI.create(URIPrefix + id + "/reference" + refCnt);
                    ++refCnt;
                    annotation = new Annotation(new QName(GBNAMESPACE, REFERENCE, GBPREFIX), new QName(GBNAMESPACE, NESTEDREFERENCE, GBPREFIX), nestedURI, nestedAnnotations);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("AUTHORS")) {
                    annotationStr = strLine.replace("AUTHORS", "").trim();
                    Annotation nestedAnnotation = new Annotation(new QName(GBNAMESPACE, AUTHORS, GBPREFIX), annotationStr);
                    nestedAnnotations.add(nestedAnnotation);
                    annotation.setAnnotations(nestedAnnotations);
                    continue;
                }
                if (strLine.startsWith("TITLE")) {
                    annotationStr = strLine.replace("TITLE", "").trim();
                    Annotation nestedAnnotation = new Annotation(new QName(GBNAMESPACE, TITLE, GBPREFIX), annotationStr);
                    nestedAnnotations.add(nestedAnnotation);
                    annotation.setAnnotations(nestedAnnotations);
                    continue;
                }
                if (strLine.startsWith("JOURNAL")) {
                    annotationStr = strLine.replace("JOURNAL", "").trim();
                    Annotation nestedAnnotation = new Annotation(new QName(GBNAMESPACE, JOURNAL, GBPREFIX), annotationStr);
                    nestedAnnotations.add(nestedAnnotation);
                    annotation.setAnnotations(nestedAnnotations);
                    continue;
                }
                if (strLine.startsWith("MEDLINE")) {
                    annotationStr = strLine.replace("MEDLINE", "").trim();
                    Annotation nestedAnnotation = new Annotation(new QName(GBNAMESPACE, MEDLINE, GBPREFIX), annotationStr);
                    nestedAnnotations.add(nestedAnnotation);
                    annotation.setAnnotations(nestedAnnotations);
                    continue;
                }
                if (strLine.startsWith("PUBMED")) {
                    annotationStr = strLine.replace("PUBMED", "").trim();
                    Annotation nestedAnnotation = new Annotation(new QName(GBNAMESPACE, PUBMED, GBPREFIX), annotationStr);
                    nestedAnnotations.add(nestedAnnotation);
                    annotation.setAnnotations(nestedAnnotations);
                    Annotation pubMedAnnotation = new Annotation(new QName("http://purl.obolibrary.org/obo/", "OBI_0001617", "obo"), annotationStr);
                    annotations.add(pubMedAnnotation);
                    continue;
                }
                if (strLine.startsWith("COMMENT")) {
                    annotationStr = strLine.replace("COMMENT", "").trim();
                    annotation = new Annotation(new QName(GBNAMESPACE, COMMENT, GBPREFIX), annotationStr);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("BASE COUNT")) {
                    annotationStr = strLine.replace("BASE COUNT", "").trim();
                    annotation = new Annotation(new QName(GBNAMESPACE, BASECOUNT, GBPREFIX), annotationStr);
                    annotations.add(annotation);
                    continue;
                }
                if (strLine.startsWith("FEATURE")) {
                    topCD = doc.createComponentDefinition(id, version, type);
                    if (circular) {
                        topCD.addType(SequenceOntology.CIRCULAR);
                    } else {
                        topCD.addType(SequenceOntology.LINEAR);
                    }
                    topCD.addRole(SequenceOntology.ENGINEERED_REGION);
                    if (!"".equals(description)) {
                        topCD.setDescription(description);
                    }
                    topCD.setAnnotations(annotations);
                    featureMode = true;
                    continue;
                }
                if (strLine.startsWith("ORIGIN")) {
                    originMode = true;
                    featureMode = false;
                    continue;
                }
                if (featureMode) {
                    if (strLine.startsWith("/")) {
                        SequenceAnnotation sa;
                        String tag = strLine.replace("/", "").trim();
                        String value = "";
                        if (-1 != strLine.indexOf(61)) {
                            String[] splitStr = strLine.split("=");
                            tag = splitStr[0].replace("/", "");
                            value = splitStr[1];
                        }
                        StringBuilder sbValue = new StringBuilder();
                        sbValue.append(value);
                        if (value.startsWith("\"") && !value.endsWith("\"")) {
                            do {
                                strLine = GenBank.readGenBankLine(br).trim();
                                sbValue.append(strLine);
                            } while (!strLine.endsWith("\""));
                        }
                        if (null != (sa = topCD.getSequenceAnnotation("annotation" + (featureCnt - 1)))) {
                            if (value.startsWith("\"")) {
                                value = value.replaceAll("\"", "");
                                annotation = new Annotation(new QName(GBCONVNAMESPACE, tag, GBCONVPREFIX), value);
                            } else {
                                annotation = new Annotation(new QName(GBCONVNAMESPACE, tag, GBCONVPREFIX), value);
                            }
                            sa.addAnnotation(annotation);
                        }
                    } else {
                        strLine = strLine.replace(", ", ",");
                        strSplit = strLine.split("\\s+");
                        URI role = GenBank.convertGenBanktoSO(strSplit[0]);
                        String range = strSplit[1];
                        boolean outerComplement = false;
                        OrientationType orientation = OrientationType.INLINE;
                        if (range.startsWith("complement")) {
                            outerComplement = true;
                            orientation = OrientationType.REVERSECOMPLEMENT;
                            range = range.replace("complement(", "").replace(")", "");
                        }
                        if (range.startsWith("join") || range.startsWith("order")) {
                            String multiType = "join";
                            if (range.startsWith("order")) {
                                multiType = "order";
                            }
                            range = range.replace("join(", "").replace(")", "");
                            range = range.replace("order(", "").replace(")", "");
                            String[] ranges = range.split(",");
                            int rangeCnt = 0;
                            SequenceAnnotation sa = null;
                            for (String r : ranges) {
                                orientation = OrientationType.INLINE;
                                if (r.startsWith("complement") || outerComplement) {
                                    orientation = OrientationType.REVERSECOMPLEMENT;
                                    r = r.replace("complement(", "").replace(")", "");
                                }
                                boolean startLessThan = false;
                                boolean endGreaterThan = false;
                                if (r.contains("<")) {
                                    startLessThan = true;
                                    r = r.replace("<", "");
                                }
                                if (r.contains(">")) {
                                    endGreaterThan = true;
                                    r = r.replace(">", "");
                                }
                                boolean singleBaseRange = false;
                                String[] rangeSplit = null;
                                if (range.contains(".") && !range.contains("..")) {
                                    rangeSplit = r.split("\\.");
                                    singleBaseRange = true;
                                } else {
                                    rangeSplit = r.split("\\.\\.");
                                }
                                int start = Integer.parseInt(rangeSplit[0]);
                                int end = Integer.parseInt(rangeSplit[1]);
                                Range newRange = null;
                                if (rangeCnt == 0) {
                                    sa = topCD.createSequenceAnnotation("annotation" + featureCnt, "range" + rangeCnt, start, end, orientation);
                                    sa.addRole(role);
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, MULTIRANGETYPE, GBCONVPREFIX), multiType);
                                    sa.addAnnotation(annotation);
                                    newRange = (Range)sa.getLocation("range" + rangeCnt);
                                } else if (sa != null) {
                                    newRange = sa.addRange("range" + rangeCnt, start, end, orientation);
                                }
                                annotation = outerComplement ? new Annotation(new QName(GBCONVNAMESPACE, POSITION, GBCONVPREFIX), POSITION + (ranges.length - 1 - rangeCnt)) : new Annotation(new QName(GBCONVNAMESPACE, POSITION, GBCONVPREFIX), POSITION + rangeCnt);
                                newRange.addAnnotation(annotation);
                                if (startLessThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, STARTLESSTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (endGreaterThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, ENDGREATERTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (singleBaseRange) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, SINGLEBASERANGE, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                ++rangeCnt;
                            }
                        } else if (range.contains("^")) {
                            String[] rangeSplit = range.split("\\^");
                            int at = Integer.parseInt(rangeSplit[0]);
                            SequenceAnnotation sa = topCD.createSequenceAnnotation("annotation" + featureCnt, "cut", at, orientation);
                            sa.addRole(role);
                        } else {
                            Range newRange;
                            boolean startLessThan = false;
                            boolean endGreaterThan = false;
                            if (range.contains("<")) {
                                startLessThan = true;
                                range = range.replace("<", "");
                            }
                            if (range.contains(">")) {
                                endGreaterThan = true;
                                range = range.replace(">", "");
                            }
                            boolean singleBaseRange = false;
                            String[] rangeSplit = null;
                            if (range.contains(".") && !range.contains("..")) {
                                rangeSplit = range.split("\\.");
                                singleBaseRange = true;
                            } else {
                                rangeSplit = range.split("\\.\\.");
                            }
                            int start = Integer.parseInt(rangeSplit[0]);
                            int end = Integer.parseInt(rangeSplit[0]);
                            if (rangeSplit.length > 1) {
                                end = Integer.parseInt(rangeSplit[1]);
                            }
                            if (start > end && circular) {
                                SequenceAnnotation sa = topCD.createSequenceAnnotation("annotation" + featureCnt, "range0", start, baseCount, orientation);
                                sa.addRole(role);
                                annotation = new Annotation(new QName(GBCONVNAMESPACE, STRADLESORIGIN, GBCONVPREFIX), "true");
                                sa.addAnnotation(annotation);
                                newRange = (Range)sa.getLocation("range");
                                if (startLessThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, STARTLESSTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (singleBaseRange) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, SINGLEBASERANGE, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                newRange = sa.addRange("range1", 1, end, orientation);
                                if (singleBaseRange) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, SINGLEBASERANGE, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (endGreaterThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, ENDGREATERTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                            } else {
                                SequenceAnnotation sa = topCD.createSequenceAnnotation("annotation" + featureCnt, "range", start, end, orientation);
                                sa.addRole(role);
                                newRange = (Range)sa.getLocation("range");
                                if (startLessThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, STARTLESSTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (endGreaterThan) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, ENDGREATERTHAN, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                                if (singleBaseRange) {
                                    annotation = new Annotation(new QName(GBCONVNAMESPACE, SINGLEBASERANGE, GBCONVPREFIX), "true");
                                    newRange.addAnnotation(annotation);
                                }
                            }
                        }
                        ++featureCnt;
                    }
                } else if (originMode) {
                    if (elements == null) {
                        elements = new String("");
                    }
                    if (strLine.startsWith("//")) {
                        cont = true;
                        break;
                    }
                    strSplit = strLine.split(" ");
                    for (i = 1; i < strSplit.length; ++i) {
                        sbSequence.append(strSplit[i]);
                    }
                }
                cont = false;
            }
            if (topCD == null) continue;
            Sequence sequence = doc.createSequence(id + "_seq", version, sbSequence.toString(), Sequence.IUPAC_DNA);
            topCD.addSequence(sequence);
            GenBank.createSubComponentDefinitions(doc, topCD, type, sbSequence.toString(), version);
        } while (cont);
        br.close();
    }
}

