/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;
import org.sbolstandard.core2.TopLevel;
import org.sbolstandard.core2.URIcompliance;

public class GenericTopLevel
extends TopLevel {
    private QName rdfType;

    GenericTopLevel(URI identity, QName rdfType) throws SBOLValidationException {
        super(identity);
        if (rdfType.getNamespaceURI().equals(Sbol2Terms.sbol2.getNamespaceURI())) {
            throw new SBOLValidationException("sbol-12302", this);
        }
        this.rdfType = rdfType;
    }

    private GenericTopLevel(GenericTopLevel genericTopLevel) throws SBOLValidationException {
        super(genericTopLevel);
        this.setRDFType(genericTopLevel.getRDFType());
    }

    void copy(GenericTopLevel genericTopLevel) throws SBOLValidationException {
        this.copy((Identified)genericTopLevel);
    }

    public QName getRDFType() {
        return this.rdfType;
    }

    public void setRDFType(QName rdfType) throws SBOLValidationException {
        if (rdfType == null) {
            throw new SBOLValidationException("sbol-12302", this);
        }
        this.rdfType = rdfType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rdfType == null ? 0 : this.rdfType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTopLevel other = (GenericTopLevel)obj;
        return !(this.rdfType == null ? other.rdfType != null : !this.rdfType.equals(other.rdfType));
    }

    @Override
    GenericTopLevel deepCopy() throws SBOLValidationException {
        return new GenericTopLevel(this);
    }

    @Override
    GenericTopLevel copy(String URIprefix, String displayId, String version) throws SBOLValidationException {
        GenericTopLevel cloned = this.deepCopy();
        cloned.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        cloned.setDisplayId(displayId);
        cloned.setVersion(version);
        URI newIdentity = URIcompliance.createCompliantURI(URIprefix, displayId, version);
        if (!this.getIdentity().equals(newIdentity)) {
            cloned.addWasDerivedFrom(this.getIdentity());
        } else {
            cloned.setWasDerivedFroms(this.getWasDerivedFroms());
        }
        cloned.setIdentity(newIdentity);
        return cloned;
    }

    @Override
    void checkDescendantsURIcompliance() {
    }

    @Override
    public String toString() {
        return "GenericTopLevel [" + super.toString() + ", rdfType=" + this.rdfType + "]";
    }
}

