/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.sbolstandard.core2.Annotation;
import org.sbolstandard.core2.Collection;
import org.sbolstandard.core2.Component;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.Cut;
import org.sbolstandard.core2.FunctionalComponent;
import org.sbolstandard.core2.GenericLocation;
import org.sbolstandard.core2.GenericTopLevel;
import org.sbolstandard.core2.Interaction;
import org.sbolstandard.core2.MapsTo;
import org.sbolstandard.core2.Model;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.Range;
import org.sbolstandard.core2.SBOLDocument;
import org.sbolstandard.core2.SBOLValidate;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.Sbol2Terms;
import org.sbolstandard.core2.Sequence;
import org.sbolstandard.core2.SequenceAnnotation;
import org.sbolstandard.core2.SequenceConstraint;
import org.sbolstandard.core2.URIcompliance;
import org.sbolstandard.core2.Version;

public abstract class Identified {
    private URI identity;
    private URI persistentIdentity;
    private String version;
    private List<Annotation> annotations;
    private Set<URI> wasDerivedFroms;
    private String displayId;
    private SBOLDocument sbolDocument = null;
    private String name;
    private String description;

    Identified(URI identity) throws SBOLValidationException {
        this.wasDerivedFroms = new HashSet<URI>();
        this.setIdentity(identity);
        this.annotations = new ArrayList<Annotation>();
    }

    Identified(Identified identified) throws SBOLValidationException {
        this.setIdentity(identified.getIdentity());
        this.wasDerivedFroms = new HashSet<URI>();
        this.annotations = new ArrayList<Annotation>();
        if (identified.hasAnnotations()) {
            ArrayList<Annotation> clonedAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : identified.getAnnotations()) {
                clonedAnnotations.add(annotation.copy());
            }
            this.setAnnotations(clonedAnnotations);
        }
        if (identified.isSetDisplayId()) {
            this.setDisplayId(identified.getDisplayId());
        }
        if (identified.isSetVersion()) {
            this.setVersion(identified.getVersion());
        }
        if (identified.isSetPersistentIdentity()) {
            this.setPersistentIdentity(URI.create(identified.getPersistentIdentity().toString()));
        }
        for (URI wasDerivedFrom : identified.getWasDerivedFroms()) {
            this.addWasDerivedFrom(URI.create(wasDerivedFrom.toString()));
        }
        for (URI wasDerivedFrom : identified.getWasDerivedFroms()) {
            this.addWasDerivedFrom(URI.create(wasDerivedFrom.toString()));
        }
        if (identified.isSetName()) {
            this.setName(identified.getName());
        }
        if (identified.isSetDescription()) {
            this.setDescription(identified.getDescription());
        }
    }

    void copy(Identified identified) throws SBOLValidationException {
        this.annotations = new ArrayList<Annotation>();
        if (identified.hasAnnotations()) {
            ArrayList<Annotation> clonedAnnotations = new ArrayList<Annotation>();
            for (Annotation annotation : identified.getAnnotations()) {
                clonedAnnotations.add(annotation.copy());
            }
            this.setAnnotations(clonedAnnotations);
        }
        for (URI wasDerivedFrom : identified.getWasDerivedFroms()) {
            this.addWasDerivedFrom(URI.create(wasDerivedFrom.toString()));
        }
        if (identified.isSetName()) {
            this.setName(identified.getName());
        }
        if (identified.isSetDescription()) {
            this.setDescription(identified.getDescription());
        }
    }

    public URI getIdentity() {
        return this.identity;
    }

    final void setIdentity(URI identity) throws SBOLValidationException {
        if (identity == null) {
            throw new SBOLValidationException("sbol-10201", this);
        }
        this.identity = identity;
    }

    public boolean isSetPersistentIdentity() {
        return this.persistentIdentity != null;
    }

    public URI getPersistentIdentity() {
        if (this.isSetPersistentIdentity()) {
            return this.persistentIdentity;
        }
        return this.identity;
    }

    void setPersistentIdentity(URI persistentIdentity) {
        this.persistentIdentity = persistentIdentity;
    }

    public boolean isSetVersion() {
        return this.version != null;
    }

    @Deprecated
    public boolean isSetWasDerivedFrom() {
        return this.wasDerivedFroms.size() > 0;
    }

    public String getVersion() {
        return this.version;
    }

    void setVersion(String version) throws SBOLValidationException {
        if (version == null || version.equals("")) {
            this.version = null;
            return;
        }
        if (!URIcompliance.isVersionValid(version)) {
            throw new SBOLValidationException("sbol-10206", this);
        }
        this.version = version;
    }

    public boolean isSetDisplayId() {
        return this.displayId != null;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    void setDisplayId(String displayId) throws SBOLValidationException {
        if (!URIcompliance.isDisplayIdValid(displayId)) {
            throw new SBOLValidationException("sbol-10204", this);
        }
        this.displayId = displayId;
    }

    public boolean addWasDerivedFrom(URI wasDerivedFromURI) {
        return this.wasDerivedFroms.add(wasDerivedFromURI);
    }

    public boolean removeWasDerivedFrom(URI wasDerivedFromURI) {
        return this.wasDerivedFroms.remove(wasDerivedFromURI);
    }

    public boolean containsWasDerivedFrom(URI wasDerivedFromURI) {
        return this.wasDerivedFroms.contains(wasDerivedFromURI);
    }

    public void clearWasDerivedFroms() {
        this.wasDerivedFroms.clear();
    }

    public Set<URI> getWasDerivedFroms() {
        HashSet<URI> result = new HashSet<URI>();
        result.addAll(this.wasDerivedFroms);
        return result;
    }

    @Deprecated
    public URI getWasDerivedFrom() {
        URI wasDerivedFrom = null;
        if (this.wasDerivedFroms.size() > 0) {
            wasDerivedFrom = (URI)this.wasDerivedFroms.toArray()[0];
        }
        return wasDerivedFrom;
    }

    @Deprecated
    public void setWasDerivedFrom(URI wasDerivedFrom) throws SBOLValidationException {
        if (this.sbolDocument != null) {
            if (!SBOLValidate.checkWasDerivedFromVersion(this.sbolDocument, this, wasDerivedFrom)) {
                throw new SBOLValidationException("sbol-10305", this);
            }
            SBOLValidate.checkWasDerivedFromCycle(this.sbolDocument, this, wasDerivedFrom, new HashSet<URI>());
        }
        this.clearWasDerivedFroms();
        this.addWasDerivedFrom(wasDerivedFrom);
    }

    public void setWasDerivedFroms(Set<URI> wasDerivedFroms) {
        this.clearWasDerivedFroms();
        if (wasDerivedFroms == null) {
            return;
        }
        for (URI wasDerivedFrom : wasDerivedFroms) {
            this.addWasDerivedFrom(wasDerivedFrom);
        }
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public Annotation createAnnotation(QName qName, String literal) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, literal);
        this.addAnnotation(annotation);
        return annotation;
    }

    public Annotation createAnnotation(QName qName, double literal) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, literal);
        this.addAnnotation(annotation);
        return annotation;
    }

    public Annotation createAnnotation(QName qName, int literal) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, literal);
        this.addAnnotation(annotation);
        return annotation;
    }

    public Annotation createAnnotation(QName qName, boolean literal) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, literal);
        this.addAnnotation(annotation);
        return annotation;
    }

    public Annotation createAnnotation(QName qName, URI literal) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, literal);
        this.addAnnotation(annotation);
        return annotation;
    }

    public Annotation createAnnotation(QName qName, QName nestedQName, URI nestedURI, List<Annotation> annotations) throws SBOLValidationException {
        Annotation annotation = new Annotation(qName, nestedQName, nestedURI, annotations);
        this.addAnnotation(annotation);
        return annotation;
    }

    private void addNamespace(Annotation annotation) throws SBOLValidationException {
        if (this.sbolDocument == null) {
            return;
        }
        QName qName = annotation.getQName();
        QName qNameInNamespace = this.sbolDocument.getNamespace(URI.create(qName.getNamespaceURI()));
        if (qNameInNamespace == null) {
            String prefix = qName.getPrefix();
            if (this.sbolDocument.getNamespace(prefix) != null) {
                prefix = this.sbolDocument.getNamespacePrefix(URI.create(qName.getNamespaceURI()));
                annotation.setQName(new QName(qName.getNamespaceURI(), qName.getLocalPart(), prefix));
            } else {
                this.sbolDocument.addNamespace(URI.create(qName.getNamespaceURI()), qName.getPrefix());
            }
        } else if (qName.getPrefix() != qNameInNamespace.getPrefix()) {
            annotation.setQName(new QName(qName.getNamespaceURI(), qName.getLocalPart(), qNameInNamespace.getPrefix()));
        }
        if (annotation.isNestedAnnotations()) {
            qName = annotation.getNestedQName();
            qNameInNamespace = this.sbolDocument.getNamespace(URI.create(qName.getNamespaceURI()));
            if (qNameInNamespace == null) {
                this.sbolDocument.addNamespace(URI.create(qName.getNamespaceURI()), qName.getPrefix());
            } else if (qName.getPrefix() != qNameInNamespace.getPrefix()) {
                annotation.setNestedQName(new QName(qName.getNamespaceURI(), qName.getLocalPart(), qNameInNamespace.getPrefix()));
            }
            for (Annotation nestedAnnotation : annotation.getAnnotations()) {
                this.addNamespace(nestedAnnotation);
            }
        }
    }

    void addAnnotation(Annotation annotation) throws SBOLValidationException {
        if (this.annotations.contains(annotation)) {
            return;
        }
        if (annotation.getQName().getNamespaceURI().equals(Sbol2Terms.sbol2.getNamespaceURI())) {
            if (this instanceof Sequence) {
                throw new SBOLValidationException("sbol-10401", new Identified[0]);
            }
            if (this instanceof ComponentDefinition) {
                throw new SBOLValidationException("sbol-10501", new Identified[0]);
            }
            if (this instanceof Component) {
                throw new SBOLValidationException("sbol-10701", new Identified[0]);
            }
            if (this instanceof MapsTo) {
                throw new SBOLValidationException("sbol-10801", new Identified[0]);
            }
            if (this instanceof SequenceAnnotation) {
                throw new SBOLValidationException("sbol-10901", new Identified[0]);
            }
            if (this instanceof Range) {
                throw new SBOLValidationException("sbol-11101", new Identified[0]);
            }
            if (this instanceof Cut) {
                throw new SBOLValidationException("sbol-11201", new Identified[0]);
            }
            if (this instanceof GenericLocation) {
                throw new SBOLValidationException("sbol-11301", new Identified[0]);
            }
            if (this instanceof SequenceConstraint) {
                throw new SBOLValidationException("sbol-11401", new Identified[0]);
            }
            if (this instanceof Model) {
                throw new SBOLValidationException("sbol-11501", new Identified[0]);
            }
            if (this instanceof ModuleDefinition) {
                throw new SBOLValidationException("sbol-11601", new Identified[0]);
            }
            if (this instanceof Module) {
                throw new SBOLValidationException("sbol-11701", new Identified[0]);
            }
            if (this instanceof FunctionalComponent) {
                throw new SBOLValidationException("sbol-11801", new Identified[0]);
            }
            if (this instanceof Interaction) {
                throw new SBOLValidationException("sbol-11901", new Identified[0]);
            }
            if (this instanceof Participation) {
                throw new SBOLValidationException("sbol-12001", new Identified[0]);
            }
            if (this instanceof Collection) {
                throw new SBOLValidationException("sbol-12101", new Identified[0]);
            }
            if (this instanceof GenericTopLevel) {
                throw new SBOLValidationException("sbol-12301", new Identified[0]);
            }
        }
        this.addNamespace(annotation);
        this.annotations.add(annotation);
    }

    public boolean removeAnnotation(Annotation annotation) {
        return this.annotations.remove(annotation);
    }

    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        annotations.addAll(this.annotations);
        return annotations;
    }

    public Annotation getAnnotation(QName qName) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.getQName().equals(qName)) continue;
            return annotation;
        }
        return null;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    void setAnnotations(List<Annotation> annotations) throws SBOLValidationException {
        this.clearAnnotations();
        for (Annotation annotation : annotations) {
            this.addAnnotation(annotation);
        }
    }

    @Deprecated
    public void unsetWasDerivedFrom() {
        this.clearWasDerivedFroms();
    }

    void setSBOLDocument(SBOLDocument sbolDocument) {
        this.sbolDocument = sbolDocument;
    }

    SBOLDocument getSBOLDocument() {
        return this.sbolDocument;
    }

    abstract Identified deepCopy() throws SBOLValidationException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + (this.persistentIdentity == null ? 0 : this.persistentIdentity.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.displayId == null ? 0 : this.displayId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identified other = (Identified)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.containsAll(other.annotations)) {
            return false;
        }
        if (this.identity == null ? other.identity != null : !this.identity.equals(other.identity)) {
            return false;
        }
        if (this.persistentIdentity == null ? other.persistentIdentity != null : !this.persistentIdentity.equals(other.persistentIdentity)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayId == null ? other.displayId != null : !this.displayId.equals(other.displayId)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @SafeVarargs
    final <I extends Identified> void addChildSafely(I child, Map<URI, I> siblingsMap, String typeName, Map<URI, ? extends Identified> ... maps) throws SBOLValidationException {
        if (URIcompliance.isChildURIformCompliant(this.getIdentity(), child.getIdentity())) {
            URI persistentId = URI.create(URIcompliance.extractPersistentId(child.getIdentity()));
            if (URIcompliance.keyExistsInAnyMap(persistentId, maps)) {
                throw new SBOLValidationException("sbol-10202", child);
            }
            if (siblingsMap.containsKey(child.getIdentity())) {
                throw new SBOLValidationException("sbol-10202", child);
            }
            siblingsMap.put(child.getIdentity(), child);
            Identified latest = (Identified)siblingsMap.get(persistentId);
            if (latest == null) {
                siblingsMap.put(persistentId, child);
            } else if (Version.isFirstVersionNewer(URIcompliance.extractVersion(child.getIdentity()), URIcompliance.extractVersion(latest.getIdentity()))) {
                siblingsMap.put(persistentId, child);
            }
        } else {
            if (URIcompliance.keyExistsInAnyMap(child.getIdentity(), maps)) {
                throw new SBOLValidationException("sbol-10202", child);
            }
            if (siblingsMap.containsKey(child.getIdentity())) {
                throw new SBOLValidationException("sbol-10202", child);
            }
            siblingsMap.put(child.getIdentity(), child);
        }
    }

    final <I extends Identified> boolean removeChildSafely(Identified identified, Map<URI, I> siblingsMap) {
        HashSet<Identified> objectsToRemove = new HashSet<Identified>();
        objectsToRemove.add(identified);
        return siblingsMap.values().removeAll(objectsToRemove);
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void unsetDescription() {
        this.description = null;
    }

    public String toString() {
        return "identity=" + this.identity + (this.isSetPersistentIdentity() ? ", persistentIdentity=" + this.persistentIdentity : "") + (this.isSetDisplayId() ? ", displayId=" + this.displayId : "") + (this.isSetVersion() ? ", version=" + this.version : "") + (this.isSetName() ? ", name=" + this.name : "") + (this.isSetDescription() ? ", description=" + this.description : "") + (this.annotations.size() > 0 ? ", annotations=" + this.annotations : "") + (this.wasDerivedFroms.size() > 0 ? ", wasDerivedFroms=" + this.wasDerivedFroms : "");
    }
}

