/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.DirectionType;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.Participation;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class Interaction
extends Identified {
    private Set<URI> types = new HashSet<URI>();
    private HashMap<URI, Participation> participations = new HashMap();
    private ModuleDefinition moduleDefinition = null;

    Interaction(URI identity, Set<URI> types) throws SBOLValidationException {
        super(identity);
        this.setTypes(types);
    }

    private Interaction(Interaction interaction) throws SBOLValidationException {
        super(interaction);
        HashSet<URI> type = new HashSet<URI>();
        for (URI typeElement : interaction.getTypes()) {
            type.add(URI.create(typeElement.toString()));
        }
        this.setTypes(type);
        HashSet<Participation> participations = new HashSet<Participation>();
        for (Participation participation : interaction.getParticipations()) {
            participations.add(participation.deepCopy());
        }
        this.setParticipations(participations);
    }

    void copy(Interaction interaction) throws SBOLValidationException {
        this.copy((Identified)interaction);
        for (Participation participation : interaction.getParticipations()) {
            String displayId = participation.getDisplayId();
            if (displayId == null) {
                displayId = URIcompliance.extractDisplayId(participation.getIdentity());
            }
            Participation newParticipation = this.createParticipation(displayId, participation.getParticipant().getDisplayId(), participation.getRoles());
            newParticipation.copy(participation);
        }
    }

    public boolean addType(URI typeURI) {
        return this.types.add(typeURI);
    }

    public boolean removeType(URI typeURI) throws SBOLValidationException {
        if (this.types.size() == 1 && this.types.contains(typeURI)) {
            throw new SBOLValidationException("sbol-11902", this);
        }
        return this.types.remove(typeURI);
    }

    public void setTypes(Set<URI> types) throws SBOLValidationException {
        if (types == null || types.size() == 0) {
            throw new SBOLValidationException("sbol-11902", this);
        }
        this.clearTypes();
        for (URI type : types) {
            this.addType(type);
        }
    }

    public Set<URI> getTypes() {
        return this.types;
    }

    public boolean containsType(URI typeURI) {
        return this.types.contains(typeURI);
    }

    private void clearTypes() {
        this.types.clear();
    }

    private Participation createParticipation(URI identity, URI participant, Set<URI> roles) throws SBOLValidationException {
        Participation participation = new Participation(identity, participant, roles);
        this.addParticipation(participation);
        return participation;
    }

    public Participation createParticipation(String displayId, String participantId, URI role) throws SBOLValidationException {
        HashSet<URI> roles = new HashSet<URI>();
        roles.add(role);
        return this.createParticipation(displayId, participantId, roles);
    }

    public Participation createParticipation(String displayId, String participantId, Set<URI> roles) throws SBOLValidationException {
        URI participantURI = URIcompliance.createCompliantURI(this.moduleDefinition.getPersistentIdentity().toString(), participantId, this.moduleDefinition.getVersion());
        if (this.getSBOLDocument() != null && this.getSBOLDocument().isCreateDefaults() && this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(participantURI) == null) {
            this.moduleDefinition.createFunctionalComponent(participantId, AccessType.PUBLIC, participantId, "", DirectionType.INOUT);
        }
        return this.createParticipation(displayId, participantURI, roles);
    }

    public Participation createParticipation(String displayId, URI participant, URI role) throws SBOLValidationException {
        HashSet<URI> roles = new HashSet<URI>();
        roles.add(role);
        return this.createParticipation(displayId, participant, roles);
    }

    public Participation createParticipation(String displayId, URI participant, Set<URI> roles) throws SBOLValidationException {
        String parentPersistentIdStr = this.getPersistentIdentity().toString();
        String version = this.getVersion();
        if (parentPersistentIdStr == null) {
            throw new IllegalStateException("Cannot create a child on a parent that has the non-standard compliant identity " + this.getIdentity());
        }
        Participation p = this.createParticipation(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, version), participant, roles);
        p.setPersistentIdentity(URIcompliance.createCompliantURI(parentPersistentIdStr, displayId, ""));
        p.setDisplayId(displayId);
        p.setVersion(version);
        return p;
    }

    private void addParticipation(Participation participation) throws SBOLValidationException {
        if (this.moduleDefinition != null && this.moduleDefinition.getFunctionalComponent(participation.getParticipantURI()) == null) {
            throw new SBOLValidationException("sbol-12003", participation);
        }
        this.addChildSafely(participation, this.participations, "participation", new Map[0]);
        participation.setSBOLDocument(this.getSBOLDocument());
        participation.setModuleDefinition(this.moduleDefinition);
    }

    public boolean removeParticipation(Participation participation) {
        return this.removeChildSafely(participation, this.participations);
    }

    public Participation getParticipation(String displayId) {
        try {
            return this.participations.get(URIcompliance.createCompliantURI(this.getPersistentIdentity().toString(), displayId, this.getVersion()));
        }
        catch (SBOLValidationException e) {
            return null;
        }
    }

    public Participation getParticipation(URI participationURI) {
        return this.participations.get(participationURI);
    }

    public Set<Participation> getParticipations() {
        return new HashSet<Participation>(this.participations.values());
    }

    public void clearParticipations() {
        Object[] valueSetArray;
        for (Object participation : valueSetArray = this.participations.values().toArray()) {
            this.removeParticipation((Participation)participation);
        }
    }

    void setParticipations(Set<Participation> participations) throws SBOLValidationException {
        this.clearParticipations();
        for (Participation participation : participations) {
            this.addParticipation(participation);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.participations == null ? 0 : this.participations.hashCode());
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interaction other = (Interaction)obj;
        if (this.participations == null ? other.participations != null : !this.participations.equals(other.participations)) {
            return false;
        }
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    @Override
    Interaction deepCopy() throws SBOLValidationException {
        return new Interaction(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
        int count = 0;
        for (Participation participation : this.getParticipations()) {
            if (!participation.isSetDisplayId()) {
                participation.setDisplayId("participation" + ++count);
            }
            participation.updateCompliantURI(this.getPersistentIdentity().toString(), participation.getDisplayId(), version);
            this.removeChildSafely(participation, this.participations);
            this.addParticipation(participation);
            String participantId = URIcompliance.extractDisplayId(participation.getParticipantURI());
            participation.setParticipant(URIcompliance.createCompliantURI(URIprefix, participantId, version));
        }
    }

    void setModuleDefinition(ModuleDefinition moduleDefinition) {
        this.moduleDefinition = moduleDefinition;
    }

    @Override
    public String toString() {
        return "Interaction [" + super.toString() + ", types=" + this.types + (this.participations.size() > 0 ? ", participations=" + this.participations : "") + "]";
    }
}

