/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.OrientationType;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public abstract class Location
extends Identified
implements Comparable<Location> {
    private OrientationType orientation;

    Location(URI identity) throws SBOLValidationException {
        super(identity);
    }

    Location(Location location) throws SBOLValidationException {
        super(location);
        this.setOrientation(location.getOrientation());
    }

    void copy(Location location) throws SBOLValidationException {
        this.copy((Identified)location);
    }

    @Override
    abstract Location deepCopy() throws SBOLValidationException;

    public boolean isSetOrientation() {
        return this.orientation != null;
    }

    public OrientationType getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationType orientation) {
        this.orientation = orientation;
    }

    public void unsetOrientation() {
        this.orientation = null;
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
    }

    @Override
    public String toString() {
        return super.toString() + (this.isSetOrientation() ? ", orientation=" + (Object)((Object)this.orientation) : "");
    }
}

