/*
 * Decompiled with CFR 0.152.
 */
package org.sbolstandard.core2;

import java.net.URI;
import org.sbolstandard.core2.AccessType;
import org.sbolstandard.core2.ComponentDefinition;
import org.sbolstandard.core2.ComponentInstance;
import org.sbolstandard.core2.Identified;
import org.sbolstandard.core2.Module;
import org.sbolstandard.core2.ModuleDefinition;
import org.sbolstandard.core2.RefinementType;
import org.sbolstandard.core2.SBOLValidationException;
import org.sbolstandard.core2.URIcompliance;

public class MapsTo
extends Identified {
    private RefinementType refinement;
    private URI local;
    private URI remote;
    private ModuleDefinition moduleDefinition = null;
    private Module module = null;
    private ComponentDefinition componentDefinition = null;
    private ComponentInstance componentInstance = null;

    MapsTo(URI identity, RefinementType refinement, URI local, URI remote) throws SBOLValidationException {
        super(identity);
        this.setRefinement(refinement);
        this.setLocal(local);
        this.setRemote(remote);
    }

    private MapsTo(MapsTo mapsTo) throws SBOLValidationException {
        super(mapsTo);
        this.setRefinement(mapsTo.getRefinement());
        this.setLocal(mapsTo.getLocalURI());
        this.setRemote(mapsTo.getRemoteURI());
    }

    void copy(MapsTo mapsTo) throws SBOLValidationException {
        this.copy((Identified)mapsTo);
    }

    public RefinementType getRefinement() {
        return this.refinement;
    }

    public void setRefinement(RefinementType refinement) {
        this.refinement = refinement;
    }

    public URI getLocalURI() {
        return this.local;
    }

    public ComponentInstance getLocal() {
        if (this.moduleDefinition != null) {
            return this.moduleDefinition.getFunctionalComponent(this.local);
        }
        if (this.componentDefinition != null) {
            return this.componentDefinition.getComponent(this.local);
        }
        return null;
    }

    public ComponentDefinition getLocalDefinition() {
        if (this.moduleDefinition != null) {
            return this.moduleDefinition.getFunctionalComponent(this.local).getDefinition();
        }
        if (this.componentDefinition != null) {
            return this.componentDefinition.getComponent(this.local).getDefinition();
        }
        return null;
    }

    public void setLocal(URI local) throws SBOLValidationException {
        if (local == null) {
            throw new SBOLValidationException("sbol-10802", this);
        }
        if (this.moduleDefinition != null) {
            if (this.moduleDefinition.getFunctionalComponent(local) == null) {
                throw new SBOLValidationException("sbol-10804", this);
            }
        } else if (this.componentDefinition != null && this.componentDefinition.getComponent(local) == null) {
            throw new SBOLValidationException("sbol-10803", this);
        }
        this.local = local;
    }

    public URI getRemoteURI() {
        return this.remote;
    }

    public ComponentInstance getRemote() {
        if (this.module != null) {
            if (this.module.getDefinition() == null) {
                return null;
            }
            return this.module.getDefinition().getFunctionalComponent(this.remote);
        }
        if (this.componentInstance != null) {
            if (this.componentInstance.getDefinition() == null) {
                return null;
            }
            return this.componentInstance.getDefinition().getComponent(this.remote);
        }
        return null;
    }

    public ComponentDefinition getRemoteDefinition() {
        if (this.module != null) {
            if (this.module.getDefinition() == null) {
                return null;
            }
            return this.module.getDefinition().getFunctionalComponent(this.remote).getDefinition();
        }
        if (this.componentInstance != null) {
            if (this.componentInstance.getDefinition() == null) {
                return null;
            }
            return this.componentInstance.getDefinition().getComponent(this.remote).getDefinition();
        }
        return null;
    }

    public void setRemote(URI remote) throws SBOLValidationException {
        if (remote == null) {
            throw new SBOLValidationException("sbol-10805", this);
        }
        if (this.module != null) {
            if (this.module.getDefinition() != null) {
                if (this.module.getDefinition().getFunctionalComponent(remote) == null) {
                    throw new SBOLValidationException("sbol-10809", this);
                }
                if (this.module.getDefinition().getFunctionalComponent(remote).getAccess().equals((Object)AccessType.PRIVATE)) {
                    throw new SBOLValidationException("sbol-10807", this);
                }
            }
        } else if (this.componentInstance != null && this.componentInstance.getDefinition() != null) {
            if (this.componentInstance.getDefinition().getComponent(remote) == null) {
                throw new SBOLValidationException("sbol-10808", this);
            }
            if (this.componentInstance.getDefinition().getComponent(remote).getAccess().equals((Object)AccessType.PRIVATE)) {
                throw new SBOLValidationException("sbol-10807", this);
            }
        }
        this.remote = remote;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
        result = 31 * result + (this.refinement == null ? 0 : this.refinement.hashCode());
        result = 31 * result + (this.remote == null ? 0 : this.remote.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapsTo other = (MapsTo)obj;
        if (this.local == null ? other.local != null : !this.local.equals(other.local)) {
            return false;
        }
        if (this.refinement != other.refinement) {
            return false;
        }
        return !(this.remote == null ? other.remote != null : !this.remote.equals(other.remote));
    }

    @Override
    MapsTo deepCopy() throws SBOLValidationException {
        return new MapsTo(this);
    }

    void updateCompliantURI(String URIprefix, String displayId, String version) throws SBOLValidationException {
        if (!this.getIdentity().equals(URIcompliance.createCompliantURI(URIprefix, displayId, version))) {
            this.addWasDerivedFrom(this.getIdentity());
        }
        this.setIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, version));
        this.setPersistentIdentity(URIcompliance.createCompliantURI(URIprefix, displayId, ""));
        this.setDisplayId(displayId);
        this.setVersion(version);
    }

    void setModuleDefinition(ModuleDefinition moduleDefinition) {
        this.moduleDefinition = moduleDefinition;
    }

    void setModule(Module module) {
        this.module = module;
    }

    void setComponentDefinition(ComponentDefinition componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    void setComponentInstance(ComponentInstance componentInstance) {
        this.componentInstance = componentInstance;
    }

    @Override
    public String toString() {
        return "MapsTo [" + super.toString() + ", refinement=" + (Object)((Object)this.refinement) + ", local=" + this.local + ", remote=" + this.remote + "]";
    }
}

